'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2890 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B DS2890
1-Wire Digital Potentiometer
.SH SYNOPSIS
Variable resistance
.PP
.B 2C
[.]XXXXXXXXXXXX[XX][/[
.B chargepump
|
.B wiper
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 2C
.SH SPECIAL PROPERTIES
.SS chargepump
.I read-write, yes-no
.br
State of the
.I chargepump
in the chip (0 = off 1 = on). Only available if external power is available (hence not in the TO-92 packaging) at pin Vdd.
.br
When
.I chargepump
is on, the
.I wiper
resistance will range between Rh and Rl relatively linearly.
.br
When
.I chargepump
is off, the
.I wiper
resistance (to ground) will range relatively linearly (to 100kOhms).
.SS wiper
.I read-write, unsigned integer
.br
Value of the variable element, 0 to 255. The actual interpretation of
.I wiper
depands on the
.I chargepump
state, but in general 0 is low and 255 is high.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
The device condition that will cause individual
.B DS2890s
to participate in a Conditional Search is a wiper position located at the power-on default setting (00h). This feature enables the bus master to easily determine whether a potentiometer has gone through a power-on reset and needs to be re-configured with a required wiper position setting.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2890
The
.B D2890 (3)
allows variable resistance under 1-wire control. Possible uses are analog feedback mechanisms (sound pitch, light level).
.P
Although there are provisions in the datasheet for different
.B DS2890
configurations (non-linear wiper ranges, multiple wipers, different resistance scales) non are in production. To simplify implementation, this driver assumes the standard
.B DS2890
design.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2890.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
