<?php

/**
* OWL_API.php
*
* This is a work in progress.  First I'd like to get the basics working (Add File/Folder, Browse, Search within files)
* and then add features from there.
*
* @author Steve Bourgeois <owl@bozzit.com> and Justin Cooper <justin@braverock.com>
*
* @copyright Copyright (c) 2004-2005 Owl Development Team 
* @copyright Copyright (c) 2004-2005 XRMS Development Team 
* 
* $Id: OWL_API.php,v 1.9 2006/01/04 21:09:10 b0zz Exp $
*/

// defined by XRMS in plugins/owl/owl_plugin.php

global $owl_location;
global $xrms_file_root;
global $include_directory;
require_once($xrms_file_root . '/include-locations.inc');
require_once($include_directory . '/adodb/adodb.inc.php');
require_once($owl_location . '/lib/pclzip/pclzip.lib.php');

// *********************************
// BEGIN OWL Config Stuff
// *********************************

global $default;
global $owl_lang;



require_once("$owl_location/config/owl.php");

global $owl_con;
$owl_con = adonewconnection('mysql');
//$owl_con->connect('terminus', 'xrms_owl','xrms_0wl' , 'xrms_owl');
$owl_con->connect($default->owl_db_host[0], $default->owl_db_user[0] ,$default->owl_db_pass[0] , $default->owl_db_name[0]);


$default->folder_security_policy = "56";
$default->folder_group_owner = "0"; // Owl Administrator Group
$default->folder_owner = "1"; // Owl Administrator User

$default->file_security_policy = "4";
$default->file_group_owner = "0"; // Owl Administrator Group
$default->file_owner = "1"; // Owl Administrator User
$default->file_metadata = 'XRMS Inserted File'; // Default Meta Data (used in searches)

$owl_lang->log_del_det          = "Entire Content was also deleted";
$owl_lang->err_root_delete              = "The Root Folder cannot be deleted";
$owl_lang->err_file_indexing            = "Temporary 'TEXT' File Creation Failure";
$owl_lang->log_detail           = "No Additional Details";
$owl_lang->virus_infected               = "VIRUS INFECTED FILE";
$owl_lang->err_update_file_lock         = "You cannot update this file, it is currently held by";
$owl_lang->err_file_not_exist           = "File does not exist on the file system";
$owl_lang->err_file_no_longer_exists    = "The File No Longer Exist in the Owl Repository";
$owl_lang->err_folder_no_longer_exists    = "The Folder No Longer Exist in the Owl Repository";
$owl_lang->err_backup_folder_create     = "Backup Folder Creation error";
$owl_lang->err_file_update              = "Updating a file requires the filename to remain the same, please try again using the same filename";
$owl_lang->err_upload                   = "Upload error";
$owl_lang->err_backup_file              = "Error backing up existing file";
$owl_lang->err_general                  = "An Error has occured";



OwlAPI_fGetPrefs();

//print("<pre>");
//print_r($default);
//print("</pre>");

// *********************************
// END OWL Config Stuff
// *********************************

global $tmp_dir;
// Start connection

/**
* Given the form's file field name and some meta-information about the file,
* add the file to the owl system and return the OWL internal id for the file.
*
* @param string name of the <input type=file> field
* @param array meta information about the file, containing 'parent_id' of the file.
* Array
* (
*   [file_pretty_name] => SOMENAME
*   [file_description] => SOME DESC
*   [file_name] => tools.tar.gz
*   [file_size] => 2541
*   [file_type] => application/x-gzip
*   [on_what_table] => contacts
*   [on_what_id] => 1
*   [entered_at] => 1128536941
*   [entered_by] => 1
*   [modified_on] => 1128536941
*   [modified_by] => 1
*   [parent_id] => 8
*   [error] => 
*   [file_stored] => 1
* )
* 
* @return array the same array that was passed in, setting 'external_id' to the internal id.
*/

function OWL_Add_File($file_field_name, $file_info) {

	// dummy id returned
	$file_info['error'] = false;
	$file_info['file_stored'] = true;

	// actually add the file to the DB now..

	global $tmp_dir;
	global $owl_con;
	global $default;
   	global $owl_lang;


	global $owl_error;
	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

        //print("<pre>$file_field_name \n");
	//print_r($_FILES);
	//print_r($file_info);
        //print("</pre>");

	//$title 		= $_FILES[$file_field_name]['name'];
	if(empty($file_info['file_pretty_name']))
	{
	   $title = $_FILES[$file_field_name]['name'];
	}
	else
	{
	   $title = $file_info['file_pretty_name'];
	}

	$new_name 	= $_FILES[$file_field_name]['name'];
	$size 		= $_FILES[$file_field_name]['size'];
	$tmp_name	= $_FILES[$file_field_name]['tmp_name'];
	$security       = $default->file_security_policy;
        $description    = $file_info['file_description'];
        $creatorid      = $default->file_owner;
	$metadata	= $default->file_metadata;
        $groupdid	= $default->file_group_owner;
	$smodified = date("Y-m-d H:i:s", $file_info['entered_at']);
	$parent		= $file_info['parent_id'];
	$bErrorOccured = false;

	if (empty($parent) or $parent == "")
	{
	   $parent = 1;
	}

        // Adjust Owl Quotas??

	// Notify Owl users monitoring this folder?

	// Notify Owl users that a new file has been uploaded?


	if ($default->owl_use_fs)
	{
    	$newpath = $default->owl_db_FileDir[0] . "/" . OwlAPI_fFindPath($parent) . "/" . $new_name;
       	if (file_exists($newpath))
       	{
	   		$owl_error['error_status'] = true;
	   		$owl_error['error_text'] = "The File '$new_name' already exists in OWL";
	   		return false;
       	}
	   	else
	   	{
           copy($_FILES[$file_field_name]['tmp_name'], $newpath);
        
           if (!file_exists($newpath))
           {
	   			$owl_error['error_status'] = true;
	   	  		$owl_error['error_text'] = "The was an Upload error";
	   	  		return false;
          }
	   }
    }

	if(!OwlAPI_fVirusCheck($_FILES[$file_field_name]['tmp_name'], $_FILES[$file_field_name]['name']))
	{
	   return false;
	}


        $sql = "INSERT INTO $default->owl_files_table (name,filename,f_size,creatorid,updatorid,parent,description,metadata,security,groupid,created, smodified,checked_out, major_revision, minor_revision, url, doctype, password, linkedto, approved) VALUES ('$title', '$new_name', '" . $size . "', '$creatorid', '$creatorid', '$parent', '$description', '$metadata', '$security', '$groupid', '$smodified', '$smodified','0','1','0', '0', '1', '' ,'0', '1')";

   	//echo $sql;

	$rst = $owl_con->execute($sql);
   
	if(!$rst) {
    	   db_error_handler($owl_con, $sql);
	} else {
           $id = $owl_con->Insert_Id();
	   $file_info['external_id'] = $id;
           if ($id !== null && $tmp_name and $default->owl_use_fs === false)
           {
              $fd = fopen($tmp_name, 'rb');
              $filedata = addSlashes(fread($fd, $size));
              fclose($fd);
              $compressed = 0;
	
              $sql = "INSERT INTO $default->owl_files_data_table (id, data, compressed) VALUES ('$id', '$filedata', '$compressed')";
              $rst = $owl_con->execute($sql);
	
              if(!$rst) {
    		 db_error_handler($owl_con, $sql);
              } 
           } 
	}


        // Index file for Searching
	OwlAPI_fIndexAFile($new_name, $_FILES[$file_field_name]['tmp_name'], $id);
	OwlAPI_fSyslog(FILE_UPLOAD, $default->file_owner, $new_name, $parent, $owl_lang->log_detail, "FILE");

        // remove the temporary file
	if(file_exists($_FILES[$file_field_name]['tmp_name']))
	{
           unlink($_FILES[$file_field_name]['tmp_name']);
	}

	return $file_info;
}

function OWL_Upd_File($file_field_name, $file_info, $versionchange = "minor_revision" ) {

	// dummy id returned
	$file_info['error'] = false;
	$file_info['file_stored'] = true;

	// actually add the file to the DB now..

        //print("<pre>");
	//print_r($file_field_name);
        //print("</pre>");
	//exit;
	global $tmp_dir;
	global $owl_con;
	global $default;
   	global $owl_lang;

	global $owl_error;
	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

	if(!OwlAPI_DoesFileExists($file_info['external_id']))
	{
	   return false;
	}

	if(!OwlAPI_fVirusCheck($_FILES[$file_field_name]['tmp_name'], $_FILES[$file_field_name]['name']))
	{
	   return false;
	}

	if(empty($file_info['file_pretty_name']))
	{
		$title = $_FILES[$file_field_name]['name'];
	}
	else
	{
		$title = $file_info['file_pretty_name'];
	}
    $userid = $default->file_owner;

	$new_name       = $_FILES[$file_field_name]['name'];
	$description    = $file_info['file_description'];
	$newdesc    	= $file_info['file_description'];
	$id 		= $file_info['external_id'];
	$size           = $_FILES[$file_field_name]['size'];
	$security       = $default->file_security_policy;
	$creatorid      = $default->file_owner;
	$metadata       = $default->file_metadata;
	$groupdid       = $default->file_group_owner;
	$parent 	= OwlAPI_fGetFileParent($id);

	$smodified = date("Y-m-d H:i:s");

	if (empty($file_field_name)) 
	{
               	$sql = "UPDATE $default->owl_files_table SET smodified='$smodified', description='$newdesc', updatorid='$userid', name='$title'  WHERE id='$id'";
	
	    	$rst = $owl_con->execute($sql);
            	if(!$rst) {
	    		unlink($newpath);
	       		db_error_handler($owl_con, $sql);
	    	} 
	
               	$sql = "UPDATE $default->owl_files_table SET smodified='$smodified', description='$newdesc', updatorid='$userid', name='$title'   WHERE linkedto='$id'";
	    	$rst = $owl_con->execute($sql);
            	if(!$rst) {
	    		unlink($newpath);
	       		db_error_handler($owl_con, $sql);
	    	} 
               	OwlAPI_fSyslog(FILE_CHANGED, $userid, OwlAPI_fGetFileName($id), $parent, $version_name, "FILE");

   	        return $file_info;
	}

	$newpath = $default->owl_db_FileDir[0] . "/" . OwlAPI_fFindPath($parent) . "/" . $new_name;

	// Get the current INFO From the Owl Database to save with the backup version if Version Control is turned on
      	if ($default->owl_version_control == 1)
      	{
         	if ($default->owl_use_fs)
         	{
            		$sql = "SELECT * from $default->owl_files_table WHERE id='$id'";
         	} 
         	else
         	{ 
            		// this is guaranteed to get the ID of the most recent revision, just in case we're updating a previous rev.
            		$sql = "SELECT distinct b.* from $default->owl_files_table a, $default->owl_files_table b WHERE b.id='$id' AND a.name=b.name AND a.parent=b.parent order by major_revision, minor_revision desc";
         	} 

	 	$rst = $owl_con->execute($sql);
		if(!$rst)
		{
			db_error_handler($owl_con, $sql);
		}
		else
		{
			$return = $rst->fields;
		}


            	// save state information
            	if ($return['checked_out'] > 0 and $return['checked_out'] <>  $userid)
            	{
	      		$owl_error['error_status'] = true;
	      		$owl_error['error_text'] = $owl_lang->err_update_file_lock;
	      		return false;
            	}

            	$major_revision = $backup_major = $return['major_revision'];
            	$minor_revision = $backup_minor = $return['minor_revision'];
            	$linkedto = $backup_linkedto = $return['linkedto'];
            	$backup_filename = $return['filename'];
            	$backup_name = $return['name'];
	
            	$backup_name = stripslashes($backup_name);
            	$backup_name = ereg_replace("'", "\\'" , ereg_replace("[<>]", "", $backup_name));
	
            	$backup_size = $return['f_size'];
            	$backup_creatorid = $return['creatorid']; 
            	$backup_updatorid = $return['updatorid']; 

            	$backup_smodified = $return['smodified'];

            	$dCreateDate = $smodified;
            	$backup_description = $return['description']; 

            	$backup_description = stripslashes($backup_description);
            	$backup_description = ereg_replace("'", "\\'" , $backup_description);
            	$backup_name = stripslashes($backup_name);
            	$backup_name = ereg_replace("'", "\\'" , $backup_name);
            	$backup_metadata = $return['metadata'];
            	$backup_metadata = stripslashes($backup_metadata);
            	$backup_metadata = ereg_replace("'", "\\'" , ereg_replace("[<>]", "", $backup_metadata));
	
            	$backup_parent = $return['parent'];
            	$backup_security = $return['security'];
            	$backup_groupid = $groupid = $return['groupid'];

            	$filename = $return['filename'];
            	$title = $return['name'];
            	$description = $return['description']; 
	
            	$description = stripslashes($description);
            	$description = ereg_replace("'", "\\'" , $description);

            	$title = stripslashes($title);
            	$title = ereg_replace("'", "\\'" , ereg_replace("[<>]", "", $title));

            	if ($default->owl_use_fs)
            	{
               		if ($default->owl_db_FileDir[0] . "/" . OwlAPI_fFindPath($parent) . "/" . $return['filename'] != $newpath and !empty($file_field_name))
               		{
	      			$owl_error['error_status'] = true;
	      			$owl_error['error_text'] = $owl_lang->err_file_update;
	      			return false;
               		}
            	} 
      } 

      if ($default->owl_use_fs and !empty($file_field_name))
      {
         	if ($default->owl_version_control == 1)
         	{
            		if (!(file_exists($newpath) == 1) || $backup_filename != $new_name) 
            		{
	      			$owl_error['error_status'] = true;
	      			$owl_error['error_text'] = $owl_lang->err_file_not_exist;
	      			return false;
            		}
            		// Get the file extension.
            		$extension = explode(".", $new_name); 
		
            		$extensioncounter = 0;
            		while ($extension[$extensioncounter + 1] != null)
            		{ 
               			// pre-append a "." separator in the name for each
               			// subsequent part of the the name of the file.
               			if ($extensioncounter != 0)
               			{
                  			$version_name = $version_name . ".";
               			} 
               			$version_name = $version_name . $extension[$extensioncounter];
               			$extensioncounter++;
            		} 

            		if ($extensioncounter != 0)
            		{
               			$version_name = $version_name . "_$major_revision-$minor_revision.$extension[$extensioncounter]";
            		}
            		else
            		{
               			$version_name = $extension[0] . "_$major_revision-$minor_revision"; 
            		}

            		// specify path for new file in the /backup/ file of each directory.
            		$backuppath = $default->owl_db_FileDir[0]  . "/" . OwlAPI_fFindPath($parent) . "/backup/$version_name"; 
	
            		if (!is_dir($default->owl_db_FileDir[0] ."/" . OwlAPI_fFindPath($parent) . "/backup"))
            		{
               			mkdir($default->owl_db_FileDir[0] ."/" . OwlAPI_fFindPath($parent) . "/backup", $default->directory_mask); 

               			// is there already a backup directory for current dir?
               			if (is_dir($default->owl_db_FileDir[0] ."/" . OwlAPI_fFindPath($parent) . "/backup"))
               			{
                  			$sql = "INSERT into $default->owl_folders_table (name, parent, security, groupid, creatorid, description)  values ('backup', '$parent', '" . OwlAPI_fCurFolderSecurity($parent) ."', '" . OwlAPI_fGetFolderGroup($parent) ."', '" . OwlAPI_fGetFolderCreator($parent) . "', '')";
		  			$rst = $owl_con->execute($sql);
		  			if(!$rst) {
	             				db_error_handler($owl_con, $sql);
		  			} 
               			} 
               			else
               			{
	      				$owl_error['error_status'] = true;
	      				$owl_error['error_text'] = $owl_lang->err_backup_folder_create;
	      				return false;
               			} 
            		} 
            		copy($newpath, $backuppath); // copy existing file to backup folder
         	} 

         	if (!file_exists($newpath) == 1) 
         	{
	      		$owl_error['error_status'] = true;
	      		$owl_error['error_text'] = $owl_lang->err_file_update;
	      		return false;
         	}
         	copy($_FILES[$file_field_name]['tmp_name'], $newpath);
         	unlink($_FILES[$file_field_name]['tmp_name']);

         	if (!file_exists($newpath))
         	{
            		if ($default->debug == true)
            		{
	      			$owl_error['error_status'] = true;
	      			$owl_error['error_text'] = "DEBUG: " . $owl_lang->err_upload . ": " . $newpath;
	      			return false;
            		}
            		else
            		{
	      			$owl_error['error_status'] = true;
	      			$owl_error['error_text'] = $owl_lang->err_upload;
	      			return false;
            		}
         	}

         	if ($default->owl_version_control == 1)
         	{
            		if (!file_exists($backuppath))
            		{
	      			$owl_error['error_status'] = true;
	      			$owl_error['error_text'] = $owl_lang->err_backup_file;
	      			return false;
            		}
            		// find id of the backup folder you are saving the old file to
            		$sql = ("SELECT id from $default->owl_folders_table WHERE name='backup' and parent='$parent'");
            		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	   			db_error_handler($owl_con, $sql);
	    		} 
	    		else
	    		{
               			$return = $rst->fields;
            		}
            		$backup_parent =  $return['id'];
         	} 
      	} 

      	if ($versionchange == 'major_revision')
      	{ 
         	// if someone requested a major revision, must
         	// make the minor revision go back to 0
         	// $versionchange = "minor_revision='0', major_revision";
         	// $new_version_num = $major_revision + 1;
         	$new_major = $major_revision + 1;
         	$new_minor = 0;
         	$versionchange = "minor_revision='0', major_revision";
         	$new_version_num = $major_revision + 1;
      	} 
      	else
      	{ 
         	// simply increment minor revision number
         	$new_version_num = $minor_revision + 1;
         	$new_minor = $minor_revision + 1;
         	$new_major = $major_revision;
      	} 

      	$groupid = $default->file_group_owner;
      	$iDocApproved = 1;
	 

     	if ($default->owl_version_control == 1)
     	{ // 1
         	if ($default->owl_use_fs)
         	{  // 2
            	// insert entry for backup file
            		$sql = "INSERT into $default->owl_files_table (name,filename,f_size,creatorid,updatorid,parent,created, smodified,groupid,description,metadata,security,major_revision,minor_revision, doctype, linkedto, approved) values ('$backup_name','$version_name','$backup_size','$backup_creatorid','$backup_updatorid','$backup_parent','$dCreateDate','$backup_smodified','$backup_groupid', '$backup_description','$backup_metadata','$backup_security','$backup_major','$backup_minor', '$doctype', '$backup_linkedto', '1')";
	    		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	    			unlink($newpath);
				unlink($backuppath);
	       			db_error_handler($owl_con, $sql);
	    		} else {
				$idbackup = $owl_con->Insert_Id();
	    		}
	
               		$sql = "UPDATE $default->owl_files_table SET f_size='" . $_FILES[$file_field_name]['size'] . "',smodified='$smodified', $versionchange='$new_version_num',description='$newdesc', approved = '$iDocApproved', updatorid='$userid', name='$title'  WHERE id='$id'";
	
	    		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	    			unlink($newpath);
	       			db_error_handler($owl_con, $sql);
	    		} 
	
               		$sql = "UPDATE $default->owl_files_table SET f_size='" . $_FILES[$file_field_name]['size'] . "',smodified='$smodified', $versionchange='$new_version_num',description='$newdesc', updatorid='$userid', name='$title'   WHERE linkedto='$id'";
	    		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	    			unlink($newpath);
	       			db_error_handler($owl_con, $sql);
	    		} 
	
               		$sql = "UPDATE $default->owl_searchidx SET owlfileid='$idbackup'  WHERE owlfileid='$id'";
	    		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	    			unlink($newpath);
	       			db_error_handler($owl_con, $sql);
	    		} 
               		OwlAPI_fIndexAFile($backup_filename, $newpath, $id);
               		OwlAPI_fSyslog(FILE_UPDATED, $userid, $_FILES[$file_field_name]["name"], $parent, $version_name, "FILE");
         	} 
         	else
         	{ 
            		$compressed = '0';
            		$fsize = $_FILES[$file_field_name]['size'];

            		$sql = "INSERT into $default->owl_files_table (name,filename,f_size,creatorid,updatorid,parent, created, smodified,groupid,description,metadata,security,major_revision,minor_revision, doctype, linkedto, approved) values ('$backup_name','" . $_FILES[$file_field_name]['name'] . "','" . $_FILES[$file_field_name]['size'] . "','$backup_creatorid','$backup_updatorid','$parent','$dCreateDate','$smodified','$backup_groupid', '$newdesc', '$backup_metadata','$backup_security','$new_major','$new_minor', '$doctype', '$backup_linkedto', '$iDocApproved')";

	    		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	       			db_error_handler($owl_con, $sql);
	    		} else {
            			$fid = $id;
	    			$id = $owl_con->Insert_Id();
	    		}
	
	
            		$sql = "SELECT * from $default->owl_monitored_file_table WHERE fid = $fid and userid = '$userid'";
            		$rst = $owl_con->execute($sql);
            		if(!$rst) {
	       			db_error_handler($owl_con, $sql);
	    		}
	    		$numrows=$rst->RowCount();
            		if ($numrows != 0)
            		{ // 3
               			$sql = "SELECT id from $default->owl_files_table WHERE name = '$backup_name' and parent = '$parent' and major_revision = '$new_major' and minor_revision = '$new_minor'";
               			$rst = $owl_con->execute($sql);
               			if(!$rst) {
	       	   			db_error_handler($owl_con, $sql);
	       			}
	       			else
	       			{
	          			$return = $rst->fields;
                  			$newmonitorid = $return['id'];
                  			$sql = "UPDATE $default->owl_monitored_file_table SET fid = '$newmonitorid'";
                  			$rst = $owl_con->execute($sql);
                  			if(!$rst) {
	       	      				db_error_handler($owl_con, $sql);
	          			}
	       			}
            		} // 3
	
            		// If pdftotext was set and exists
            		// Create a search index for this text file.
            		OwlAPI_fIndexAFile($_FILES[$file_field_name]['name'], $_FILES[$file_field_name]['tmp_name'], $id);
	
            		if ($default->owl_compressed_database && file_exists($default->gzip_path))
            		{ // 4
               			system($default->gzip_path . " " . escapeshellarg($_FILES[$file_field_name]['tmp_name']));
               			$fd = fopen($_FILES[$file_field_name]['tmp_name'] . ".gz", 'rb');
               			$_FILES[$file_field_name]['tmp_name'] = $_FILES[$file_field_name]['tmp_name'] . ".gz";
               			$fsize = filesize($_FILES[$file_field_name]['tmp_name']);
               			$compressed = '1';
            		} 
            		else
            		{
               			$fd = fopen($_FILES[$file_field_name]['tmp_name'], 'rb');
            		} // 4 
            		$filedata = fread($fd, $fsize);
            		fclose($fd);
            		unlink($_FILES[$file_field_name]['tmp_name']);
	
            		if ($id !== null && $filedata)
            		{ // 5
               			$sql->query("INSERT into $default->owl_files_data_table (id, data, compressed) values ('$id', '" . addslashes($filedata) ."','$compressed')");
            		} // 5
            		OwlAPI_fSyslog(FILE_UPDATED, $userid, $_FILES[$file_field_name]["name"], $parent, $backup_name, "FILE"); 
         	} // 2
   	} 
   	else // versioning not included in the DB update
   	{
      		if ($default->owl_use_fs)
        	{ // 6
        		$filename = $_FILES[$file_field_name]['name'];
               		$sql->query("UPDATE $default->owl_files_table SET f_size='" . $_FILES[$file_field_name]['size'] . "',creatorid='$userid',smodified='$smodified', approved='$iDocApproved' WHERE id='$id'") or unlink($newpath);
    		} // 7
      		$fid = $id;
	
        	// Index file for Searching
		OwlAPI_fIndexAFile($new_name, $_FILES[$file_field_name]['tmp_name'], $id);
		OwlAPI_fSyslog(FILE_UPLOAD, $default->file_owner, $new_name, $parent, $owl_lang->log_detail, "FILE");
	
  	}  //1
  	// remove the temporary file
   	if(file_exists($_FILES[$file_field_name]['tmp_name']))
   	{
   		unlink($_FILES[$file_field_name]['tmp_name']);
   	}
	
   	return $file_info;
}
	
/**
* Delete a file given the file's id.
* @param array meta information about the file
* Array
* (
*    [file_id] => 48
*    [file_name] => httpd.conf
*    [file_pretty_name] => DELETE ME
*    [file_description] => dasdfasdf
*    [file_filesystem_name] => 
*    [file_size] => 51712
*    [file_type] => application/octet-stream
*    [on_what_table] => contacts
*    [on_what_id] => 1
*    [entered_at] => 2005-10-25 10:22:13
*    [entered_by] => 1
*    [last_modified_on] => 0000-00-00 00:00:00
*    [last_modified_by] => 
*    [file_record_status] => d
*    [external_id] => 56
* )
*
* 
* @return array the same array that was passed in, setting 'external_id' to the internal id.
*/
function OWL_Delete_File($file_info) {

	global $owl_error;

	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

	if(!OwlAPI_DoesFileExists($file_info['external_id']))
	{
	   return false;
	}

	OwlAPI_fDeleteFile($file_info['external_id']);
	return $file_info;
}


/**
* Given some meta-information about the folder,
* add the folder to the owl system and return the OWL internal id for the folder.
*
* @param array containing 'external_id' of the folder.
* 
* Array
* (
*    [external_id] => N,
* )
*
* @return array Array('files' => Array(M1, M2, M3, etc), 'folders' =>  Array(N1, N2, N3, etc));
* 
*/

function OWL_Delete_Folder($folder_info)
{
	global $aDeleteFiles;
	global $aDeleteFolders;

	$aDeleteFiles = array();
	$aDeleteFolders = array();
	$aDeleteFilesAndFolders = array();


	global $owl_error;

	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

	if(!OwlAPI_DoesFolderExists($folder_info['external_id']))
	{
	   return false;
	}
	OwlAPI_fDeleteFolder($folder_info['external_id']);

	$aDeleteFilesAndFolders['files'] = $aDeleteFiles;
	$aDeleteFilesAndFolders['folders'] = $aDeleteFolders;
	return $aDeleteFilesAndFolders;
}


/**
* Given some meta-information about the folder,
* add the folder to the owl system and return the OWL internal id for the folder.
*
* @param array meta information about the folder, containing 'parent_id' of the folder.
* 
* Array
* (
*    [folder_name] => xxxxx
*    [folder_description] => 
*    [on_what_table] => contacts
*    [on_what_id] => 1
*    [entered_at] => 1128536182
*    [entered_by] => 1
*    [parent_id] => 8
*)
*
* 
* @return array the same array that was passed in, setting 'external_id' to the internal id.
*/
function OWL_Add_Folder($folder_info) {

	$folder_info['error'] = false;
	$folder_info['folder_stored'] = true;

	global $tmp_dir;
	global $owl_con;
	global $default;
	global $owl_error;
	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

	$name 			= $folder_info['name'];
	$description	= $folder_info['description'];
	$parent			= $folder_info['parent_id'];

        ////print("<pre>");
	//print_r($folder_info);
        //print("</pre>");

	$smodified = date("Y-m-d H:i:s", $folder_info['entered_at']);

	if(!$parent) {
		$parent = 1;
		$folder_info['parent_id'] = $parent;
	}

        if ($default->owl_use_fs)
        {	
	   $path = $default->owl_db_FileDir[0] . "/" . OwlAPI_fFindPath($parent);
           if (file_exists("$path/$name"))
           {
	      $owl_error['error_status'] = true;
	      $owl_error['error_text'] = "The Folder '$name' already exists";
	      return false;
           }
           else
	   {
	      mkdir($path . "/" . $name, $default->directory_mask);
              if (!is_dir("$path/$name"))
              {
	         $owl_error['error_status'] = true;
	         $owl_error['error_text'] = "There was a problem Creating the Folder '$name'";
	         return false;
              }
           }
	}
	// Check to see if the folder exist before Creating it and adding it to the databse

	$sql = "INSERT INTO $default->owl_folders_table (name,parent,security,description,groupid,creatorid, password, smodified) VALUES ('$name', '$parent', '$default->folder_security_policy', '$description', '$default->folder_group_owner', '$default->folder_owner', '', '$smodified')";


	$rst = $owl_con->execute($sql);

	if(!$rst) {
    	   db_error_handler($owl_con, $sql);
	} else {
           $folder_info['external_id'] = $owl_con->Insert_Id();
	}
	return $folder_info;
}


/**
* OWL_Download_File
*
* Send file contents to the browser and exit.
*
* @return no return
*/
function OWL_Download_File($id, $sVersionNumber = NULL) 
{
   global $owl_con;
   global $default;
   global $owl_error;
   $owl_error['error_status'] = false;
   $owl_error['error_text'] = "";


   $id =  OwlAPI_fGetFileIdForVersion($id , $sVersionNumber);

   if(!OwlAPI_DoesFileExists($id))
   {
	return false;
   }

   $filename = OwlAPI_fGetFileName($id);
   $parent = OwlAPI_fGetFileParent($id);

   $mimeType = "application/octet-stream";

      if ($filetype = strrchr($filename, "."))
      {
         $filetype = substr($filetype, 1);
	 $mimeType = OwlAPI_fGetMimeType($filetype);

      } 

   if ($default->owl_use_fs)
   {
      $path = OwlAPI_fFindPath($parent) . "/" . $filename;
      $fspath = $default->owl_db_FileDir[0] . "/" . $path;
      if (!file_exists($fspath))
      {
         if ($default->debug == true)
         {
	      				$owl_error['error_status'] = true;
	      				$owl_error['error_text'] = $owl_lang->err_file_not_exist . ":" . $fspath;
	      				return false;
         }
         else
         { 
	      				$owl_error['error_status'] = true;
	      				$owl_error['error_text'] = $owl_lang->err_file_not_exist;
	      				return false;
         }
      } 
      $fsize = filesize($fspath);
   } 
   else
   {
      $fsize = OwlAPI_fGetFileSize($id);
   } 
   header("Cache-control:");
   header("Content-Disposition: attachment; filename=\"$filename\"");
   header("Content-Location: $filename");
   header("Content-Type: $mimeType");
   header("Content-Length: $fsize");
   header("Expires: 0"); 

   if ($default->owl_use_fs)
   {
      if (substr(php_uname(), 0, 7) != "Windows")
      {
         $fp = fopen("$fspath", "r");
      }
      else
      {
         $fp = fopen("$fspath", "rb");
      }
      fpassthru($fp); 
   } 
   else
   {
      $sql = "SELECT data,compressed from " . $default->owl_files_data_table . " WHERE id='$id'";

      $rst = $owl_con->execute($sql);
      if(!$rst)
      {
         db_error_handler($owl_con, $sql);
      }
      else
      {
         $return = $rst->fields;
      }

         if ($return['compressed'])
         {
            $tmpfile = $default->owl_tmpdir . "/" . "owltmp.$id";
            if (file_exists($tmpfile)) unlink($tmpfile);

            $fp = fopen($tmpfile, "w");
            fwrite($fp, $return['data']);
            fclose($fp);
            flush(passthru($default->gzip_path . " -dfc $tmpfile"));
            unlink($tmpfile);
         } 
         else
         {
            print $return['data'];
            flush();
         } 
   } 
   OwlAPI_fSyslog(FILE_DOWNLOADED, $userid, $filename, $parent, "", "FILE");
   exit();
}


/**
* OWL_Get_File_Info
*
* Given a file_id (id of OWL database), return the file data

* @return array contining file data
*/
function OWL_Get_File_Info($file_info, $sVersionNumber = NULL) 
{
   global $default;
   global $owl_con;
   global $owl_error;
   $owl_error['error_status'] = false;
   $owl_error['error_text'] = "";

   $file_info['versions'] = array();

   if(!OwlAPI_DoesFileExists($file_info['external_id']))
   {
	return false;
   }

   $fileid =  OwlAPI_fGetFileIdForVersion($file_info['external_id'] , $sVersionNumber);

   $parent = OwlAPI_fGetFileParent($fileid);

   // GET The info of the current file

   	$sql = "SELECT filename, f_size,major_revision,minor_revision, description, smodified, created from $default->owl_files_table where id = '$fileid'";
      //$logdate = date("Y-m-d G:i:s");
   	$rst = $owl_con->execute($sql);
   	if(!$rst)
   	{
      		db_error_handler($owl_con, $sql);
   	}
   	else
   	{
      		$return = $rst->fields;
   	}
	$file_info['file_size'] = $return['f_size'];
	$file_info['file_description'] = $return['description'];
	$file_info['selected_version'] = $return['major_revision'] . "." . $return['minor_revision'];
	$file_info['last_modified_on'] = $return['smodified'];
	$file_info['entered_at'] = $return['created'];

   // GET all Revisions available

   	$filename = $return['filename'];

   	$filesearch = explode('.', $filename);
   	$extensioncounter = 0;
   	while ($filesearch[$extensioncounter + 1] != null)
   	{
        	// pre-append a "." separator in the name for each
         	// subsequent part of the the name of the file.
	    	if ($extensioncounter != 0)
	       	{
	       		$firstpart = $firstpart . ".";
		}
		$firstpart = $firstpart . $filesearch[$extensioncounter];
		$extensioncounter++;
	}
	if ($extensioncounter == 0)
	{
		$firstpart = $filename;
		$file_extension = '';
	}
	else
	{
		$file_extension = $filesearch[$extensioncounter];
	}

	if ($default->owl_use_fs)
	{
		$sql = "SELECT id FROM $default->owl_folders_table WHERE name='backup' AND parent='$parent'";
		$rst = $owl_con->execute($sql);
	    	$numrows=$rst->RowCount();
            	if ($numrows != 0)
		{
			$return = $rst->fields;
			   $backup_parent = $return['id'];
		}
		else
		{
			$backup_parent = $parent;
		}
		$sql = "select * from $default->owl_files_table where (filename LIKE '" . $firstpart . "\\_%" . $file_extension . "' OR filename = '$filename') AND (parent = '$backup_parent' OR parent = '$parent') order by major_revision desc, minor_revision desc";
	}
	else
	{
		$name =  OwlAPI_fGetFileName($fileid);
		$sql = "select * from $default->owl_files_table where name='$name' AND parent='$parent' order by major_revision desc, minor_revision desc";
		
		
	}

	$rst = $owl_con->execute($sql);
	while(!$rst->EOF) 
	{
		$return = $rst->fields;
   		$choped = split("\.", $return['filename']);
      		$pos = count($choped);
         	$ext = strtolower($choped[$pos-1]);
		$file_info['versions'][] =  $return['major_revision'] . "." . $return['minor_revision'];
		$rst->moveNext();
	}

        //print("<pre>");
	//print_r($file_info);
        //print("</pre>");
   	return $file_info;
}

/**
* OWL_Browse_Files
*
* Pull file and folder information from the OWL database and merge it with the $files_in array.
* For folders, this function should set 'is_folder' to true.
* This function should also filter the files_in, checking against the parent_id. (or maybe we could move that to the plugin?)
*
* return an array of file information
* @param int parent_id describing which folder we are in.
* @param array an array of file records where $row['external_id'] points to OWL's internal ID
*
* @return array a filtered array of files that is a merge of files_in and OWL's data, also folders.
*/
function OWL_Browse_Files($parent_id, $files_in, $folders_in) {

	global $owl_con;
	global $default;
   global $owl_error;
   $owl_error['error_status'] = false;
   $owl_error['error_text'] = "";



	if(!$parent_id) $parent_id=1;

	$return = array();
	$i=0; 

        if ($parent_id > 1)
	{
		$row['name'] = '.. (folder)';
		$row['id'] = OwlAPI_fGetFolderParent($parent_id);
		$row['is_folder'] = true;
		$row['link_parent'] = true;
		$return[$i] = $row;
		$i++;
	}


	// add folders first
	foreach($folders_in as $row) {

		$sql = "SELECT * FROM $default->owl_folders_table WHERE id = '{$row['external_id']}' AND parent='$parent_id' and name <> 'backup'";

       		$rst = $owl_con->execute($sql);
	
		if(!$rst) {
			db_error_handler($owl_con, $sql);
		} else {
			while(!$rst->EOF) {
	
				$return[$i] = $rst->fields;
				$return[$i]['is_folder'] = true;
				$i++;
				$rst->moveNext();
			}
		}
	}

	foreach($files_in as $row) {
		$sql = "SELECT * FROM $default->owl_files_table  WHERE id='{$row['external_id']}' and parent='$parent_id'";

    		$rst = $owl_con->execute($sql);

		if(!$rst) {
			db_error_handler($owl_con, $sql);
		} else {
		        
			while(!$rst->EOF) {
		      		$return[$i] = $row;
				$i++;
				$rst->moveNext();
			}
		}

	}
	return $return;
}


/**
* OWL_Search_Files
*
* Pull file and folder information from the OWL database and merge it with the $files_in array.
* For folders, this function should set 'is_folder' to true.
* This function should also filter the files_in, checking against the parent_id. (or maybe we could move that to the plugin?)
*
* return an array of file information
* @param int parent_id describing which folder we are in.
* @param array an array of file records where $row['external_id'] points to OWL's internal ID
*
* @return array a filtered array of files that is a merge of files_in and OWL's data, also folders.
*/
function OWL_Search_Files($owl_search_string, $files_in) {

	global $owl_con;
	global $default;
   	global $owl_error;
   	$owl_error['error_status'] = false;
   	$owl_error['error_text'] = "";



// if the is an $owl_search_string, perform the search on the OWL files based on the list of files in $files_in
// see the browse function for an example.
	if (empty($owl_search_string)) {
		return $files_in;
	} else {

   $keywords = strtolower($owl_search_string);
   $keywords = str_replace(', ', ' ', $keywords);
   $keywords = str_replace(',', ' ', $keywords);
   $keywords = str_replace('  ', ' ', $keywords);

   #Replace asterisks with % signs for MySQL wildcards

   $keywords = str_replace("*", "%", $keywords);

   #Tack the search terms onto the query
      $keywordid = "";
      $sqlquery .= " AND (";
      if($boolean == "phrase")
      {
            $keywords = strtolower($keywords);

            $sql = "SELECT * from $default->owl_wordidx where word like '%$keywords%'";
    	    $rst = $owl_con->execute($sql);
            if(!$rst) {
		db_error_handler($owl_con, $sql);
	    } 

	    $numrows=$rst->RowCount();
            if ($numrows != 0)
	    {
		while(!$rst->EOF) {
		      	$return = $rst->fields;
                        $keywordid .= " OR wordid = '" . $return['wordid'] . "'";
			$rst->moveNext();
		}
	    }
            else
            {
               $keywordid = " OR wordid = '-1' ";
            }
         $sqlquery .= "name LIKE '%$keywords%' OR metadata LIKE '%$keywords%' OR description LIKE '%$keywords%' OR filename LIKE '%$keywords%' $keywordid";
      }
      else
      {
         #Match any or all words
         $keywordid = '';
         $tok = strtok($keywords, " ");
         while($tok)
         {
 

            $sql = "SELECT * from $default->owl_wordidx where word like '%$tok%'";
    	    $rst = $owl_con->execute($sql);
            if(!$rst) {
		db_error_handler($owl_con, $sql);
	    } 

	    $numrows=$rst->RowCount();
            if ($numrows != 0)
	    {
		while(!$rst->EOF) {
		      	$return = $rst->fields;
                        $keywordid .= " OR wordid = '" . $return['wordid'] . "'";
			$rst->moveNext();
		}
	    }
            else
            {
               $keywordid = " OR wordid = '-1' ";
            }

            $sqlquery .= "$glue (name LIKE '%$tok%' OR metadata LIKE '%$tok%' OR description LIKE '%$tok%' OR filename LIKE '%$tok%' ";

            $sqlquery .= " $keywordid)";

            $glue = ($boolean == "all") ? " AND" : " OR";
            $tok = strtok(" ");
         }
      }
      $sqlquery .= ")";

     $sql =  "SELECT f.id as fid FROM $default->owl_files_table f left outer join $default->owl_searchidx on owlfileid=f.id where approved = '1' $sqlquery group by f.id";


    	$rst = $owl_con->execute($sql);
        if(!$rst) {
		db_error_handler($owl_con, $sql);
	    } 
	    else
	    {
	        $i = 0;
		$aFilesOut = array();
		while(!$rst->EOF) {
		      	$return = $rst->fields;
                        foreach($files_in as $aIsInXRMS)
			{
                           if ($aIsInXRMS['external_id'] == $return['fid'])
			   {
		              $aFilesOut[$i] = $aIsInXRMS;
			      $i++;
			      //print_r($aIsInXRMS);
			   }
			}
			$rst->moveNext();
		}
	    }

     }
    return $aFilesOut;
}


/**
* $Log: OWL_API.php,v $
* Revision 1.9  2006/01/04 21:09:10  b0zz
* Added error handling on line 1315
*
* Revision 1.8  2005/12/13 21:42:18  b0zz
* Ajusted xrms Includes as per Justin
*
*/


// Converted Owl Functions

function OwlAPI_DoesFolderExists($fileid)
{
   global $default;
   global $owl_con;
   global $owl_error;
   global $owl_lang;

   $owl_error['error_status'] = false;
   $owl_error['error_text'] = "";

   $sql = "SELECT id FROM $default->owl_folders_table WHERE id = '$fileid'";
   $rst = $owl_con->execute($sql);

   $numrows=$rst->RowCount();
   if ($numrows != 0)
   {
      	return true;
   }

   $owl_error['error_status'] = true;
   $owl_error['error_text'] = $owl_lang->err_folder_no_longer_exists;

   return false;
}

function OwlAPI_DoesFileExists($fileid)
{
   global $default;
   global $owl_con;
   global $owl_error;
   global $owl_lang;

   $owl_error['error_status'] = false;
   $owl_error['error_text'] = "";

   $sql = "SELECT id FROM $default->owl_files_table WHERE id = '$fileid'";
   $rst = $owl_con->execute($sql);

   if(!$rst)
   {
      db_error_handler($owl_con, $sql);
   }
   else
   {
      $numrows=$rst->RowCount();
   }

   if ($numrows != 0)
   {
      	return true;
   }

   $owl_error['error_status'] = true;
   $owl_error['error_text'] = $owl_lang->err_file_no_longer_exists;
   return false;
}

function OwlAPI_fFidToName($parent)
{
   global $default;
   global $owl_con;

   if (empty($parent))
   {
      $parent=1;
   }

   $sql = "SELECT name FROM $default->owl_folders_table WHERE id = '$parent'";

   $rst = $owl_con->execute($sql);

   if(!$rst)
   {
      db_error_handler($owl_con, $sql);
   }
   else
   {
      $return = $rst->fields;
   }
   return $return['name'];
}


function OwlAPI_fFindPath($parent)
{
   global $default;
   global $owl_con;

   $path = OwlAPI_fFidToName($parent);

   while ($parent != 1)
   {
      $sql = "SELECT parent FROM $default->owl_folders_table WHERE id = '$parent'";

      $rst = $owl_con->execute($sql);
      $numrows=$rst->RowCount();
      if ($numrows == 0)
      {
         $path = NULL;
	 break;
      }

      if(!$rst) 
      {
         db_error_handler($owl_con, $sql);
      } 
      else
      {
         $return = $rst->fields;
      }

      $path = OwlAPI_fFidToName($return['parent']) . "/" . $path;
      $parent = $return['parent'];
  }
  return $path;
}

function OwlAPI_fGetPrefs ()
{
   global $default;
   global $owl_con;

   define ("LOGIN", "1");
   define ("LOGIN_FAILED", "2");
   define ("LOGOUT", "3");
   define ("FILE_DELETED", "4");
   define ("FILE_UPLOAD", "5");
   define ("FILE_UPDATED", "6");
   define ("FILE_DOWNLOADED", "7");
   define ("FILE_CHANGED", "8");
   define ("FILE_LOCKED", "9");
   define ("FILE_UNLOCKED", "10");
   define ("FILE_EMAILED", "11");
   define ("FILE_MOVED", "12");
   define ("FOLDER_CREATED", "13");
   define ("FOLDER_DELETED", "14");
   define ("FOLDER_MODIFIED", "15");
   define ("FOLDER_MOVED", "16");
   define ("FORGOT_PASS", "17");
   define ("USER_REG", "18");
   define ("FILE_VIEWED", "19");
   define ("FILE_VIRUS", "20");
   define ("FILE_COPIED", "21");
   define ("FOLDER_COPIED", "22");
   define ("FILE_LINKED", "23");

   $sql = "SELECT * FROM $default->owl_prefs_table";

   $rst = $owl_con->execute($sql);

   if(!$rst)
   {
   db_error_handler($owl_con, $sql);
   }
   else
   {
      $owlprefs = $rst->fields;
   }

   $default->owl_email_from = $owlprefs['email_from'];
   $default->owl_email_fromname = $owlprefs['email_fromname'];
   $default->owl_email_replyto = $owlprefs['email_replyto'];
   $default->owl_email_server = $owlprefs['email_server'];
   $default->owl_email_subject = $owlprefs['email_subject'];
   $default->use_smtp = $owlprefs['use_smtp'];
   $default->use_smtp_auth = $owlprefs['use_smtp_auth'];
   $default->smtp_auth_login  = $owlprefs['smtp_auth_login'];
   $default->smtp_passwd = $owlprefs['smtp_passwd'];
   //
   // LookAtHD is not supported with $default->owl_use_fs = false
   //
   if ($default->owl_use_fs)
   {
   $default->owl_LookAtHD = $owlprefs['lookathd'];
   }
   else
   {
   if (substr(php_uname(), 0, 7) == "Windows")
   {
   $default->owl_compressed_database = 0;
   }
   $default->owl_LookAtHD = "false";
   }
   
   $default->owl_lookAtHD_del = $owlprefs['lookathddel'];
   $default->owl_def_file_security = $owlprefs['def_file_security'];
   $default->owl_def_file_group_owner = $owlprefs['def_file_group_owner'];
   $default->owl_def_file_owner = $owlprefs['def_file_owner'];
   $default->owl_def_file_title = $owlprefs['def_file_title'];
   $default->owl_def_file_meta = $owlprefs['def_file_meta'];
   $default->owl_def_fold_security = $owlprefs['def_fold_security'];
   $default->owl_def_fold_group_owner = $owlprefs['def_fold_group_owner'];
   $default->owl_def_fold_owner = $owlprefs['def_fold_owner'];
   $default->max_filesize = $owlprefs['max_filesize'];
   $default->owl_timeout = $owlprefs['timeout'];
   if ($owlprefs['tmpdir'] == "")
   {
   $default->owl_tmpdir = $default->owl_db_FileDir[0] ;
   $default->owl_tmpdir .= "/" . owl_fFidToName(1);
   }
   else
   {
   $default->owl_tmpdir = $owlprefs['tmpdir'];
   }
   $default->expand = $owlprefs['expand'];
   $default->owl_version_control = $owlprefs['version_control'];
   $default->major_revision = $owlprefs['major_revision'];
   $default->minor_revision = $owlprefs['minor_revision'];
   
   $default->restrict_view = $owlprefs['restrict_view'];
   $default->dbdump_path = $owlprefs['dbdump_path'];
   $default->gzip_path = $owlprefs['gzip_path'];
   $default->tar_path = $owlprefs['tar_path'];
   $default->unzip_path = $owlprefs['unzip_path'];
   $default->pod2html_path = $owlprefs['pod2html_path'];
   $default->pdftotext_path = $owlprefs['pdftotext_path'];
   $default->wordtotext_path = $owlprefs['wordtotext_path'];
   $default->file_perm = $owlprefs['file_perm'];
   $default->folder_perm = $owlprefs['folder_perm'];
   
   $default->anon_ro = $owlprefs['anon_ro'];
   $default->anon_user = $owlprefs['anon_user'];
   $default->file_admin_group = $owlprefs['file_admin_group'];
   
   $default->hide_backup = $owlprefs['hide_backup'];
   
   $default->collect_trash = $owlprefs['collect_trash'];
   $default->collect_trash = $owlprefs['collect_trash'];
   if ($owlprefs['trash_can_location'] == "")
   {
   $default->trash_can_location = $default->owl_db_FileDir[0]  . "/TrashCan";
   }
   else
   {
   $default->trash_can_location = $owlprefs['trash_can_location'];
   }
   
   $default->allow_popup = $owlprefs['allow_popup'];
   $default->show_file_stats = $owlprefs['status_bar_location'];
   
   $default->show_prefs = $owlprefs['pref_bar'];
   $default->show_search = $owlprefs['search_bar'];
   $default->show_bulk = $owlprefs['bulk_buttons'];
   $default->show_action = $owlprefs['action_buttons'];
   $default->show_folder_tools = $owlprefs['folder_tools'];
   
   //$default->hide_bulk = $owlprefs['hide_bulk'];
   //
   // Logging options
   //
   $default->logging = $owlprefs['logging'];
   $default->log_file = $owlprefs['log_file'];
   $default->log_login = $owlprefs['log_login'];
   $default->log_rec_per_page = $owlprefs['log_rec_per_page'];
   //
   // Sticky loggin (remember me Link)
   //
   $default->remember_me = $owlprefs['remember_me'];
   $default->cookie_timeout = $owlprefs['cookie_timeout'];
   $default->hide_folder_doc_count      = $owlprefs['hide_folder_doc_count'];
   $default->old_action_icons   = $owlprefs['old_action_icons'];
   $default->search_result_folders      = $owlprefs['search_result_folders'];
   $default->restore_file_prefix        = $owlprefs['restore_file_prefix'];
   
   
   $default->doc_id_prefix = $owlprefs['doc_id_prefix'];
   $default->doc_id_num_digits = $owlprefs['doc_id_num_digits'];
   
   $default->view_doc_in_new_window = $owlprefs['view_doc_in_new_window'];
   
   $default->admin_login_to_browse_page = $owlprefs['admin_login_to_browse_page'];
      
   $default->save_keywords_to_db = $owlprefs['save_keywords_to_db'];
   $default->anon_access = $owlprefs['anon_ro'];
   
   $default->document_peer_review = $owlprefs['peer_review'];
   $default->document_peer_review_optional = $owlprefs['peer_opt'];
   $default->hide_folder_size = $owlprefs['folder_size'];
   $default->use_zip_for_folder_download = $owlprefs['download_folder_zip'];
   $default->display_password_override = $owlprefs['display_password_override'];
   $default->virus_path = $owlprefs['virus_path'];
   
}

function OwlAPI_fFindFileExtension ($filename)
{
   $FirstPartAndExtension = array();

   $filesearch = explode('.', $filename);
   $extensioncounter = 0;
   while ($filesearch[$extensioncounter + 1] != null)
   {
      // pre-append a "." separator in the name for each
      // subsequent part of the the name of the file.
      if ($extensioncounter != 0)
      {
         $firstpart = $firstpart . ".";
      }
      $firstpart = $firstpart . $filesearch[$extensioncounter];
      $extensioncounter++;
   }
   if ($extensioncounter == 0)
   {
      $firstpart = $filename;
      $file_extension = '';
   }
   else
   {
      $file_extension = $filesearch[$extensioncounter];
   }

   return strtolower($file_extension);
}


function OwlAPI_fIndexAFile($new_name, $newpath, $id)
{
   	global $default;
	global $owl_error;
	global $owl_location;

	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

   // IF the file was inserted in the database now INDEX it for SEARCH.
   $sSearchExtension = OwlAPI_fFindFileExtension($new_name);
   
   if ($sSearchExtension == 'pdf' || $sSearchExtension == 'c' || $sSearchExtension == 'html' || $sSearchExtension == 'htm' || $sSearchExtension == 'php' || $sSearchExtension == 'pl' || $sSearchExtension == 'txt' || $sSearchExtension == 'doc' || $sSearchExtension == 'xls' or $sSearchExtension == 'sxw' or $sSearchExtension == 'log' )
   {
      if(file_exists($default->pdftotext_path) and $sSearchExtension == 'pdf')
      {
         $command = $default->pdftotext_path . '  "' . $newpath . '" "' .  $default->owl_tmpdir . "/" . $new_name . '.text"';
      
         $last_line = system($command, $retval);
         if ($retval > 0)
         {
            if ($default->debug == true)
            {
               switch ($retval)
               {
                  case "1":
                     $sPdfError = "Error opening a PDF file. (Not A PDF File?)";
                  break;
                  case "2":
                     $sPdfError = "Error opening an ouput file. ($default->owl_tmpdir Writeable by the webserver?)";
                  break;
               }
	         $owl_error['error_status'] = true;
	         $owl_error['error_text'] = 'DEBUG: Indexing PDF File \'' . $newpath . '\' Failed:'. $sPdfError;
	         return false;
            }
         }
         OwlAPI_fIndexATextFile($default->owl_tmpdir . "/" . $new_name . '.text', $id);
         unlink($default->owl_tmpdir . "/" . $new_name . '.text');
      }
      elseif (file_exists($default->wordtotext_path) and $sSearchExtension == 'doc')
      {
         $command = $default->wordtotext_path . '  "' . $newpath . '" > "' .  $default->owl_tmpdir . "/" . $new_name . '.text"';

         $last_line = system($command, $retval);
         if ($retval > 0)
         {
            if ($default->debug == true)
            {
               $sPdfError = "Return: $retval $last_line";
	       $owl_error['error_status'] = true;
	       $owl_error['error_text'] = 'DEBUG: Indexing MS WORD File \'' . $newpath . '\' Failed:' . $sPdfError;
	       return false;
            }
         }
      
         OwlAPI_fIndexATextFile($default->owl_tmpdir . "/" . $new_name . '.text', $id);
         unlink($default->owl_tmpdir . "/" . $new_name . '.text');
      }
      elseif($sSearchExtension == 'sxw')
      {
         $tmpDir = $default->owl_tmpdir . "/owltmp.$sess";
         if (file_exists($tmpDir))
         {
            OwlAPI_fMyDelete($tmpDir);
         }
      
         mkdir($tmpDir,$default->directory_mask);
      
      
         $archive = new PclZip($newpath);
         $aListOfFiles = $archive->listContent();
      
         while ($aFileDetails = current($aListOfFiles)) 
	 {
            if($aFileDetails["filename"] == "content.xml")
            {
               $iContentFileIndex = $aFileDetails["index"];
               break;
            }
            next($aListOfFiles);
         }
      
         if ($archive->extractByIndex($iContentFileIndex, $tmpDir) == 0)
         {
	    $owl_error['error_status'] = true;
	    $owl_error['error_text'] = "DEBUG: " .$archive->errorInfo(true) . "N: $newpath P: $tmpDir";
	    return false;
         }
         $text = file_get_contents("$tmpDir/content.xml");
         $fp = fopen($tmpDir ."/content.xml.text", "w");
         fwrite($fp, strip_tags($text));
         fclose($fp);
         
         OwlAPI_fIndexATextFile($tmpDir ."/content.xml.text", $id);
         OwlAPI_fMyDelete($tmpDir);
      }
      elseif($sSearchExtension == 'xls')
      {
         $xlwords = '';
         require_once($owl_location . '/lib/xlread.inc');
         $xl = new Spreadsheet_Excel_Reader();
         $xl->read($newpath);
         for ($k = count($xl->sheets)-1; $k>=0; $k--)
         {
            for ($i = 1; $i <= $xl->sheets[$k]['numRows']; $i++)
            {
               for ($j = 1; $j <= $xl->sheets[$k]['numCols']; $j++)
               {
                  $xlwords .= $xl->sheets[$k]['cells'][$i][$j] . ' ';
               }
            }
         }
         $xlwords = preg_replace('# +#si',' ',$xlwords);
         $xlwords = preg_replace('# $#si','',$xlwords);
         OwlAPI_fIndexABigString($xlwords, $id);
      }
      else
      {
         if ($sSearchExtension != 'pdf' and $sSearchExtension != 'doc' and $sSearchExtension != 'xls')
         {
            OwlAPI_fIndexATextFile($newpath, $id);
         }
      }
   }
   return true;
}


function OwlAPI_fIndexATextFile($filename, $owlfileid)
{
   global $default;
   global $owl_con;
   global $owl_lang;
	global $owl_error;
	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

   $fileidnum = $owlfileid;

   $sql = "SELECT * FROM $default->owl_wordidx"; //Import all words and indexes

   $rst = $owl_con->execute($sql);

   $nextwordindex = 0;
   $wordindex = array();

   if(!$rst) 
   {
      db_error_handler($owl_con, $sql);
   } 
   else 
   {
      while(!$rst->EOF) 
      {
         $words = $rst->fields;
         $wordindex[$words['word']] = $words['wordid'];
         if ($words['wordid'] > $nextwordindex)
         {
            $nextwordindex = $words['wordid']; //get largest word index in table
         }
         $rst->moveNext();
      }
   }

   $nextwordindex++;

   // Note: again, here we've just read in the big wordidx, we should index as many
   // files as possible while we have this index in memory, here we
   // only index a single filename, but if someone wants to greatly improve performance,
   // index an array of filenames here...
   if (file_exists($filename))
   {
      $fp = fopen($filename, "rb");
      while (!feof($fp))
      {
         $line = fgets($fp, 128);
         $line = strtolower($line);
         $wordtemp = preg_split("/\s+/", $line); //split line into words a word is any # of A-Za-z's separated by somethign not a-zA-Z
         if (!isset($wordtemp)) continue;

         foreach($wordtemp as $wd)
         {
            $wd = stripslashes(ereg_replace("[$default->list_of_chars_to_remove_from_wordidx]","",str_replace("]", "", str_replace("[", "",$wd))));
         
            if (strlen(trim($wd)) > 0)
            {
               $words[$wd]++; //keep a count of how often each word is seen

               if ($words[$wd] == 1) // if this is the first time we've seen this word in this document...
               {
                  if ($wordindex[$wd]) // if this word was already in the wordidx table...
                  {
                     $sql = "INSERT INTO $default->owl_searchidx VALUES('$wordindex[$wd]','$fileidnum')"; //add a searchidx table entry for this fileidnum (owlidnum)
                     $rst = $owl_con->execute($sql);
                     if(!$rst) 
		     {
                        db_error_handler($owl_con, $sql);
                     }
                  }
                  else // if word not in word index, add to both wordidx and searchidx
                  {
                     if (!empty($default->words_to_exclude_from_wordidx))
                     {
                        array($WordList);
                        $WordList = $default->words_to_exclude_from_wordidx;
            
                        $checkword = str_replace("+", "\+", $wd);
                        $checkword = str_replace("'", "\'", $checkword);
                        $checkword = str_replace("{", "\{", $checkword);

                        if (!(preg_grep("/$checkword/", $WordList)))
                        {
                           $wordindex[$wd] = $nextwordindex; //first remember this word as being in the wordindex
                           $sql = "INSERT INTO $default->owl_searchidx VALUES('$wordindex[$wd]', '$fileidnum')"; //add pointer to owlidnum for this wordindexnum
                           $rst = $owl_con->execute($sql);
                           if(!$rst) 
		           {
                              db_error_handler($owl_con, $sql);
                           }

                           $wd = ereg_replace("'", "\\'" , $wd);
                           $sql = "SELECT wordid FROM $default->owl_wordidx WHERE word = '$wd'";
                           $rst = $owl_con->execute($sql);
			   $numrows=$rst->RowCount();
			   $rst->close();

                           if ( $numrows == 0 )
                           {
                              $sql = "INSERT INTO $default->owl_wordidx VALUES('$nextwordindex', '$wd')";
                              $rst = $owl_con->execute($sql);
                              if(!$rst) 
		              {
                                 db_error_handler($owl_con, $sql);
                              }
                              $nextwordindex++;
                           }
                        }
                     }
                     else
                     {
                        $wordindex[$wd] = $nextwordindex; //first remember this word as being in the wordindex
                        $sql = "INSERT INTO $default->owl_searchidx VALUES('$wordindex[$wd]', '$fileidnum')"; //add pointer to owlidnum for this wordindexnum
                        $rst = $owl_con->execute($sql);
                        if(!$rst) 
		        {
                           db_error_handler($owl_con, $sql);
                        }
         
                        $wd = ereg_replace("'", "\\'" , $wd);
                        $sql = "SELECT wordid FROM $default->owl_wordidx WHERE word = '$wd'";
                        $rst = $owl_con->execute($sql);
			$numrows=$rst->RowCount();
			$rst->close();

                        if ( $numrows == 0 )
                        {
                           $sql = "INSERT INTO $default->owl_wordidx VALUES('$nextwordindex', '$wd')";
                           $rst = $owl_con->execute($sql);
                           if(!$rst) 
		           {
                              db_error_handler($owl_con, $sql);
                           }
                           $nextwordindex++;
                        }
                     }
                  }
               } //if first instance of this word...
            }
         } //for each word
      } //while!feof
   }
   else
   {
      if ($default->debug == true)
      {
	$owl_error['error_status'] = true;
	$owl_error['error_text'] = "DEBUG: $owl_lang->err_file_indexing";
	 return false;
      }
   }
   return true;
}

function OwlAPI_fSyslog($action, $userid, $filename, $logparent, $detail, $type)
{
   global $default;
   global $owl_con;
   global $owl_location;

	$default->debug = true;

	require_once("$owl_location/lib/disp.lib.php");
	require_once("$owl_location/lib/owl.lib.php");

   if ($default->logging == 1)
   {

      $sql = new Owl_DB;
      $log = 0;

      $logdate = date("Y-m-d G:i:s");
      if ($_SERVER["HTTP_CLIENT_IP"])
      {
         $ip = $_SERVER["HTTP_CLIENT_IP"];
      } 
      elseif ($_SERVER["HTTP_X_FORWARDED_FOR"])
      {
         $forwardedip = $_SERVER["HTTP_X_FORWARDED_FOR"];
         list($ip, $ip2, $ip3, $ip4) = split (",", $forwardedip);
      }
      else
      {
         $ip = $_SERVER["REMOTE_ADDR"];
      }
      $agent = $_SERVER["HTTP_USER_AGENT"];
      if ($default->log_file == 1 && $type == "FILE")
      {
         $log = 1;
      }
      if ($default->log_login == 1 && $type == "LOGIN")
      {
         $log = 1;
      }
      if ($log == 1)
      {
         if (empty($logparent))
         {
            $logparent = 0;
         }
         $sql = "INSERT INTO $default->owl_log_table (userid, filename, action, parent, details, logdate, ip, agent, type) VALUES ('$userid', '$filename', '$action', '$logparent', '$detail', '$logdate', '$ip', '$agent', '$type')";
         $rst = $owl_con->execute($sql);
         if(!$rst) 
	 {
            db_error_handler($owl_con, $sql);
         }
      }
   }
   return true;
}

function OwlAPI_fVirusCheck($filename, $name)
{
   global $default, $parent, $owl_lang;
	global $owl_error;
	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

   if (trim($default->virus_path) <> "")
   {
      system($default->virus_path . " " . $filename, $retval);
      if ($retval > 0)
      {
	 OwlAPI_fSyslog(FILE_VIRUS, $default->file_owner, $name, $parent, $owl_lang->log_detail, "FILE");
         if ($default->debug == true)
         {
		$owl_error['error_status'] = true;
		$owl_error['error_text'] = "DEBUG: $owl_lang->virus_infected -- $filename <br /> DEBUG: $owl_lang->virus_return_val";
		return false;
         }
         else
         {
		$owl_error['error_status'] = true;
		$owl_error['error_text'] = $owl_lang->virus_infected;
		return false;
         }
      }
   }
   return true;
}

function OwlAPI_fGetMimeType($filetype)
{
   global $default;
   global $owl_con;

   $sql = "SELECT * from $default->owl_mime_table WHERE filetype = '$filetype'";
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      db_error_handler($owl_con, $sql);
   }
   else
   {
      $return = $rst->fields;
   }
   return $return['mimetype'];
}

function OwlAPI_fGetFileSize($fileid)
{
   global $default;
   global $owl_con;

   $sql = "SELECT f_size from $default->owl_files_table where id = '$fileid'";
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      db_error_handler($owl_con, $sql);
   }
   else
   {
      $return = $rst->fields;
   }
   return $return['f_size'];
}

function OwlAPI_fGetFileName($fileid)
{
   global $default;
   global $owl_con;

   $sql = "SELECT filename from $default->owl_files_table where id = '$fileid'";
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      db_error_handler($owl_con, $sql);
   }
   else
   {
      $return = $rst->fields;
   }
   return $return['filename'];
}

function OwlAPI_fGetFileParent($fileid)
{
   global $default;
   global $owl_con;

   $sql = "SELECT parent from $default->owl_files_table where id = '$fileid'";
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      db_error_handler($owl_con, $sql);
   }
   else
   {
      $return = $rst->fields;
   }
   return $return['parent'];
}

function OwlAPI_fGetFolderParent($folderid)
{
   global $default;
   global $owl_con;

   if ( $default->HomeDir == $folderid )
   {
      $folderparent = 1;
   }
   else
   {
      $sql = "SELECT parent from $default->owl_folders_table where id = '$folderid'";
      $rst = $owl_con->execute($sql);
      if(!$rst)
      {
         db_error_handler($owl_con, $sql);
      }
      else
      {
         $return = $rst->fields;
      }
      $folderparent =  $return['parent'];
   }
   return $folderparent;
}
function OwlAPI_fCurFolderSecurity($folderid)
{
   global $default;
   global $owl_con;

      $sql = "SELECT security from $default->owl_folders_table where id = '$folderid'";
      $rst = $owl_con->execute($sql);
      if(!$rst)
      {
         db_error_handler($owl_con, $sql);
      }
      else
      {
         $return = $rst->fields;
      }
	return $return['security'];
}
function OwlAPI_fGetFolderGroup($folderid)
{
      global $default;
      global $owl_con;

      $foldergroup = 0;
      $sql = "SELECT groupid from $default->owl_folders_table where id = '$folderid'";
      $rst = $owl_con->execute($sql);
      if(!$rst)
      {
         db_error_handler($owl_con, $sql);
      }
      else
      {
         $return = $rst->fields;
      	$foldergroup = $return['groupid'];
      }
	 return $foldergroup;

}
function OwlAPI_fGetFolderCreator($folderid)
{
   	global $default;
   	global $owl_con;
	
   	$foldercreator = 0;
   	$sql = "SELECT creatorid from " . $default->owl_folders_table . " where id = '$folderid'";
      	if(!$rst)
      	{
         	db_error_handler($owl_con, $sql);
      	}
      	else
      	{
        	$return = $rst->fields;
      		$foldercreator = $return['creatorid'];
      	}
	return $foldercreator;
}

function OwlAPI_fDeleteFile($id)
{
   	global $default;
   	global $owl_lang;
   	global $owl_con;
   	global $owl_location;
	$default->debug = true;

	require_once("$owl_location/lib/disp.lib.php");
	require_once("$owl_location/lib/owl.lib.php");

	global $owl_error;
	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";

        $userid = $default->file_owner;

      // Get additional Information about this file

      $sql = "SELECT * from $default->owl_files_table WHERE id = '$id'";
      $rst = $owl_con->execute($sql);
      if(!$rst)
      {
         db_error_handler($owl_con, $sql);
      }
      else
      {
        $return = $rst->fields;
        $path = OwlAPI_fFindPath($return['parent']);
        $filename = $return['filename'];
        $filesize = $return['f_size'];
        $owner = $return['creatorid'];
        $parent = $return['parent'];
      }

         if ($default->owl_use_fs)
         {
            if (file_exists($default->owl_db_FileDir[0] . "/" . $path . "/" . $filename))
            { 
               // This is where we move the file to
               // the trash can
               if ($default->collect_trash == 1)
               {
                  $sTrashDir = explode('/', $path);
                  $sCreatePath = $default->trash_can_location;
                  foreach($sTrashDir as $sDir)
                  {
                     $sCreatePath .= "/" . $sDir;
                     if (!file_exists($sCreatePath))
                     {
                        mkdir("$sCreatePath", $default->directory_mask);
                     } 
                  } 
                  if (substr(php_uname(), 0, 7) != "Windows")
                  {
                     $cmd = "mv " . "\"" . $default->owl_db_FileDir[0] . "/" . $path . "/" . $filename . "\" \"" . $default->trash_can_location . "/" . $path . "/" . $filename . "\" 2>&1";
                     $lines = array();
                     $errco = 0;
                     $result = OwlAPI_fMyExec($cmd, $lines, $errco);
                     if ($errco != 0)
		     {
	                $owl_error['error_status'] = true;
	                $owl_error['error_text'] = $owl_lang->err_general . " -- " . $result;
			return false;
		     }
                  } 
                  else
                  {
                     copy($default->owl_db_FileDir[0] . "/$path/$filename", "$default->trash_can_location/$path/$filename");
                     unlink($default->owl_db_FileDir[0] . "/" . $path . "/" . $filename);
                  } 
               } 
               else
               {
                  unlink($default->owl_db_FileDir[0] . "/" . $path . "/" . $filename);
               } 
            } 
            OwlAPI_fSyslog(FILE_DELETED, $userid, $filename, $parent, $owl_lang->log_detail, "FILE");

            $sql = "DELETE from $default->owl_files_table WHERE id = '$id'"; 
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all monitored files with that id
            $sql = "DELETE from $default->owl_monitored_file_table WHERE fid = '$id'"; 
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all comments with this file
            $sql = "DELETE from $default->owl_comment_table WHERE fid = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all comments with this file
            $sql = "DELETE from $default->owl_docfieldvalues_table WHERE file_id = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all linked files
            $sql = "DELETE from $default->owl_files_table WHERE linkedto = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all linked files
            $sql = "DELETE from $default->owl_peerreview_table WHERE file_id = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean Up SEARCH Indexes for this file
            OwlAPI_fDeleteFileIndexID($id); 
            // Clean up all previous versions as well
            $sql = "SELECT id FROM $default->owl_folders_table WHERE name='backup' and parent='$parent'";
            $rst = $owl_con->execute($sql);
	    $numrows=$rst->RowCount();
            if ($numrows != 0)
            {
               $aParentFolder = $rst->fields;
               $backup_parent = $aParentFolder['id'];

               $filesearch = explode('.', $filename);
               $extensioncounter = 0;
               while ($filesearch[$extensioncounter + 1] != null)
               { 
                  // pre-append a "." separator in the name for each
                  // subsequent part of the the name of the file.
                  if ($extensioncounter != 0)
                  {
                     $firstpart = $firstpart . ".";
                  } 
                  $firstpart = $firstpart . $filesearch[$extensioncounter];
                  $extensioncounter++;
               } 
               if ($extensioncounter == 0)
               {
                  $firstpart = $filename;
                  $file_extension = '';
               } 
               else
               {
                  $file_extension = $filesearch[$extensioncounter];
               } 

               $Quota = new Owl_DB;
               $sql = "SELECT * from $default->owl_files_table WHERE filename LIKE '" . $firstpart . "\\_%" . $file_extension . "' OR filename = '$filename' AND (parent = $backup_parent OR parent = $parent) order by major_revision desc, minor_revision desc";
      		$rst = $owl_con->execute($sql);
      		while(!$rst->EOF) 
      		{
         	  $aPreviousVersions = $rst->fields;
                  $path = OwlAPI_fFindPath($aPreviousVersions['parent']);
                  $filename = $aPreviousVersions['filename']; 
                  // Clean Up SEARCH Indexes for the Backup files
                  OwlAPI_fDeleteFileIndexID($aPreviousVersions['id']);
                  // Update the Quota for the Backup files

                  if (file_exists($default->owl_db_FileDir[0] . "/" . $path . "/" . $filename))
                  {
                     if ($default->collect_trash == 1)
                     {
                        $sTrashDir = explode('/', $path);
                        $sCreatePath = $default->trash_can_location;
                        foreach($sTrashDir as $sDir)
                        {
                           $sCreatePath .= "/" . $sDir ;
                           if (!file_exists($sCreatePath))
                           {
                              mkdir("$sCreatePath", $default->directory_mask);
                           } 
                        } 
                        if (substr(php_uname(), 0, 7) != "Windows")
                        {
                           $cmd = "mv " . "\"" . $default->owl_db_FileDir[0] . "/" . $path . "/" . $filename . "\" \"" . $default->trash_can_location . "/" . $path . "/" . $filename . "\" 2>&1";
                           $lines = array();
                           $errco = 0;
                           $result = OwlAPI_fMyExec($cmd, $lines, $errco);
                           if ($errco != 0)
			   {
	                	$owl_error['error_status'] = true;
	                	$owl_error['error_text'] = $owl_lang->err_general . " -- " . $result;
				return false;
			   }
                        } 
                        else
                        {
                           rename($default->owl_db_FileDir[0] . "/$path/$filename", "$default->trash_can_location/$path/$filename");
                        } 
                     } 
                     else
                     {
                        unlink($default->owl_db_FileDir[0] . "/" . $path . "/" . $filename);
                     } 
                  } 
         		$rst->moveNext();
               } 
               $sql = "DELETE FROM $default->owl_files_table WHERE filename LIKE '" . $firstpart . "\\_%" . $file_extension . "' OR filename = '$filename' AND (parent = $backup_parent OR parent = $parent)";
      		$rst = $owl_con->execute($sql);
            } 
         } 
         else
         {
            $sql = "DELETE from $default->owl_files_table WHERE id = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all monitored files with that id
            $sql = "DELETE from $default->owl_monitored_file_table WHERE fid = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            $sql = "DELETE from $default->owl_files_data_table WHERE id = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            $sql = "DELETE from $default->owl_comment_table WHERE fid = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all comments with this file
            $sql = "DELETE from $default->owl_docfieldvalues_table WHERE file_id = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all linked files
            $sql = "DELETE from $default->owl_files_table WHERE linkedto = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean up all linked files
            $sql = "DELETE from $default->owl_peerreview_table WHERE file_id = '$id'";
	    $rst = $owl_con->execute($sql);
	    if(!$rst)
            {
	       db_error_handler($owl_con, $sql);
            }
            // Clean Up SEARCH Indexes for this file
            OwlAPI_fDeleteFileIndexID($id);
            OwlAPI_fSyslog(FILE_DELETED, $userid, $filename, $parent, $owl_lang->log_detail, "FILE");
         } 
} 

function OwlAPI_fDeleteFolder($iFolderID)
{
   	global $default;
   	global $owl_lang;
   	global $owl_con;
   	global $owl_location;

	global $owl_error;
	global $folderList, $fCount;



	$owl_error['error_status'] = false;
	$owl_error['error_text'] = "";
	

        $userid = $default->folder_owner;
	$id = $iFolderID;
	
   	if ($id == 1) // Document Folder
   	{
	    	$owl_error['error_status'] = true;
		$owl_error['error_text'] = $owl_lang->err_root_delete;
		return false;
   	} 

   	$sql = "SELECT id,name,parent from $default->owl_folders_table order by name"; 
   	$rst = $owl_con->execute($sql);
	$fCount=$rst->RowCount();
   	if(!$rst)
   	{
      		db_error_handler($owl_con, $sql);
   	}
   	else
   	{
      		$i = 0;
		while(!$rst->EOF) 
		{
      			$return = $rst->fields;
         		$folderList[$i][0] = $return['id'];
         		$folderList[$i][2] = $return['parent'];
         		$i++;
			$rst->MoveNext();
   		} 
   	}

      	if ($default->owl_use_fs)
      	{ 
         	// This is WHERE we move the file to
         	// the trash can
         	if ($default->collect_trash == 1)
         	{
            		$path = OwlAPI_fFindPath($id);
            		$sTrashDir = explode('/', $path);
            		$sCreatePath = $default->trash_can_location;
            		foreach($sTrashDir as $sDir)
            		{
               			$sDestPath = $sCreatePath;
               			$sCreatePath .= "/" . $sDir;
               			if (!file_exists($sCreatePath))
               			{
                  			mkdir("$sCreatePath", $default->directory_mask);
               			} 
            		} 
            		if (substr(php_uname(), 0, 7) != "Windows")
            		{
               			$cmd = "cp -r " . '"' . $default->owl_db_FileDir[0] . "/" . $path . '" "' . $sDestPath . '" 2>&1';
               			$lines = array();
               			$errco = 0;
               			$result = OwlAPI_fMyExec($cmd, $lines, $errco);
               			if ($errco != 0)
               			{
				       	$owl_error['error_status'] = true;
					$owl_error['error_text'] = $owl_lang->err_general . " -- " . $result;
					return false;
               			}
            		} 
            		else
            		{
               			rename($default->owl_db_FileDir[0] ."/$path", "$default->trash_can_location");
            		} 
         	} 

                
         	OwlAPI_fMyDelete($default->owl_db_FileDir[0] . "/" . OwlAPI_fFindPath($id));
      	} 

      	$log_name = OwlAPI_fGetFileName($id);
      	OwlAPI_fDeleteFolderTree($id);
      	OwlAPI_fSyslog(FOLDER_DELETED, $userid, $log_name, $parent, $owl_lang->log_del_det, "FILE");
}

function OwlAPI_fMyExec($_cmd, &$lines, &$errco)
{
	$cmd = "$_cmd ; echo $?";
	exec($cmd, $lines);
	// Get rid of the last errco line...
	$errco = (integer) array_pop($lines);
	if (count($lines) == 0)
	{
		return "";
	}
	else
	{
		return $lines[count($lines) - 1];
	}
}

function OwlAPI_fDeleteFileIndexID($fidtoremove)
{
	global $default;
   	global $owl_con;

   	$sql = "DELETE from $default->owl_searchidx where owlfileid = '$fidtoremove'";
   	$rst = $owl_con->execute($sql);
   	if(!$rst)
   	{
		db_error_handler($owl_con, $sql);
     	}
}

function OwlAPI_fGetFileIdForVersion($external_id , $sVersionNumber = NULL)
{
   global $default;
   global $owl_con;

   if(empty($sVersionNumber))
   {
      $fileid = $external_id;
   }
   else
   {
      // NEED to get the id of the version that was requested
       $filename = OwlAPI_fGetFileName($external_id); 
       $parent = OwlAPI_fGetFileParent($external_id);

	$sql = "SELECT id FROM $default->owl_folders_table WHERE name='backup' AND parent='$parent'";
	$rst = $owl_con->execute($sql);
	$numrows=$rst->RowCount();
        if ($numrows != 0)
	{
		$return = $rst->fields;
		$backup_parent = $return['id'];
	}
	else
	{
		$backup_parent = $parent;
	}

   	$filesearch = explode('.', $filename);
   	$extensioncounter = 0;

   	while ($filesearch[$extensioncounter + 1] != null)
   	{
        	// pre-append a "." separator in the name for each
         	// subsequent part of the the name of the file.
	    	if ($extensioncounter != 0)
	       	{
	       		$firstpart = $firstpart . ".";
		}
		$firstpart = $firstpart . $filesearch[$extensioncounter];
		$extensioncounter++;
	}
	if ($extensioncounter == 0)
	{
		$firstpart = $filename;
		$file_extension = '';
	}
	else
	{
		$file_extension = $filesearch[$extensioncounter];
	}

       list($major, $minor) = split("\.", $sVersionNumber);

       $filename = $firstpart . '_'.$major.'-'.$minor.'.'.$file_extension;


        $sql = "SELECT id from $default->owl_files_table where filename = '$filename' AND (parent = '$backup_parent' OR parent = '$parent')";

   	$rst = $owl_con->execute($sql);
   	if(!$rst)
   	{
      		db_error_handler($owl_con, $sql);
   	}
   	else
   	{
      		$return = $rst->fields;
   	}
	$numrows=$rst->RowCount();
	if($numrows == 0)
	{
           $fileid = $external_id;
	}
	else
	{
           $fileid = $return['id'];
	}
   }
   return $fileid;
}


function OwlAPI_fIndexABigString($bigstring, $owlfileid)
{
   global $default;
   global $owl_con;

   $fileidnum = $owlfileid;

   $sql = "SELECT * from $default->owl_wordidx"; //Import all words and indexes
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      	db_error_handler($owl_con, $sql);
   }
   else
   {
   	$nextwordindex = 0;
   	$wordindex = array();
	while(!$rst->EOF) 
	{
      		$return = $rst->fields;
      	        $wordindex[$return['word']] = $return['wordid'];
      		if ($return['wordid'] > $nextwordindex)
      		{
         		$nextwordindex = $return['wordid']; //get largest word index in table
      		} 
			$rst->MoveNext();
   	} 
   	$nextwordindex++;
   }

   // Note: again, here we've just read in the big wordidx, we should index as many
   // files as possible while we have this index in memory, here we
   // only index a single filename, but if someone wants to greatly improve performance,
   // index an array of filenames here...
   $wordtemp = preg_split("/\s+/", strtolower($bigstring)); //split line into words a word is any # of A-Za-z's separated by somethign not a-zA-Z
   if (!isset($wordtemp)) return;
   
   foreach($wordtemp as $wd)
   {
      $wd = ereg_replace("[$default->list_of_chars_to_remove_from_wordidx]","",$wd);

      if (strlen(trim($wd)) > 0) 
      {
         $words[$wd]++; //keep a count of how often each word is seen
         //print("WORDS: $words[$wd] ---- ");
         if ($words[$wd] == 1) // if this is the first time we've seen this word in this document...
         {
            if ($wordindex[$wd]) // if this word was already in the wordidx table...
            {
               $sql = "INSERT into $default->owl_searchidx values('$wordindex[$wd]','$fileidnum')"; //add a searchidx table entry for this fileidnum (owlidnum)
   		$rst = $owl_con->execute($sql);
   		if(!$rst)
   		{
      			db_error_handler($owl_con, $sql);
   		}
            } 
            else // if word not in word index, add to both wordidx and searchidx
            {
               $wordindex[$wd] = $nextwordindex; //first remember this word as being in the wordindex
               $sql = "INSERT into $default->owl_searchidx values('$wordindex[$wd]', '$fileidnum')"; //add pointer to owlidnum for this wordindexnum
   		$rst = $owl_con->execute($sql);
   		if(!$rst)
   		{
      			db_error_handler($owl_con, $sql);
   		}

               $wd = ereg_replace("'", "\\'" , $wd);
               $sql = "SELECT wordid from $default->owl_wordidx where word = '$wd'";
               $rst = $owl_con->execute($sql);
               if(!$rst) {
	       	   db_error_handler($owl_con, $sql);
	       }
	       $numrows=$rst->RowCount();
               if ( $numrows == 0 )
               {
                  $sql = "INSERT into $default->owl_wordidx values('$nextwordindex', '$wd')";
   		  $rst = $owl_con->execute($sql);
   		  if(!$rst)
   		  {
      			  db_error_handler($owl_con, $sql);
   		  }
                  $nextwordindex++;
               }
            } 
         } //if first instance of this word...
      }
   } //for each word
}
function OwlAPI_fMyDelete($file)
{
   if (file_exists($file))
   {
   	if (is_dir($file))
   	{
   		$handle = opendir($file);
   		while ($filename = readdir($handle))
   		{
   			if ($filename != "." && $filename != "..")
   			{
   				OwlAPI_fMyDelete($file . "/" . $filename);
   			}
   		}
   		closedir($handle);
   		rmdir($file);
   	}
   	else
   	{
   		unlink($file);
   	}
   }
}


function OwlAPI_fDeleteFolderTree($fid)
{
   global $fCount, $folderList, $default; 
   global $owl_con;

   global $aDeleteFiles;
   global $aDeleteFolders;

   $aDeleteFolders[] = $fid;

   $sql = "DELETE from $default->owl_folders_table where id = '$fid'";
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      	db_error_handler($owl_con, $sql);
   }

   $sql = "DELETE from $default->owl_monitored_folder_table where fid = '$fid'";
   $rst = $owl_con->execute($sql);
   if(!$rst)
   {
      	db_error_handler($owl_con, $sql);
   }

   $sql = "SELECT id from $default->owl_files_table where parent = '$fid'"; 
   $rst = $owl_con->execute($sql);
   // Clean up Comments and Monitored Files from each file we are going to
   // delete
   if(!$rst) 
   {
	db_error_handler($owl_con, $sql);
   } 
   else 
   {
	while(!$rst->EOF)
	{
		$return = $rst->fields;
      		$iFileid = $return['id'];
                $aDeleteFiles[] = $iFileid;

      		$del = "DELETE from $default->owl_monitored_file_table where fid = '$iFileid'";
                $rst2 = $owl_con->execute($del);
   		if(!$rst2) 
   		{
			db_error_handler($owl_con, $sql);
   		} 
      		$del = "DELETE from $default->owl_comment_table where fid = '$iFileid'";
                $rst2 = $owl_con->execute($del);
   		if(!$rst2) 
   		{
			db_error_handler($owl_con, $sql);
   		} 
      		if (!$default->owl_use_fs)
      		{
         		$del = "DELETE from $default->owl_files_data_table  where id = '$iFileid'";
                	$rst2 = $owl_con->execute($del);
   			if(!$rst2) 
   			{
				db_error_handler($owl_con, $sql);
   			} 
      		} 
		$rst->moveNext();
   	} 
   	$del = "DELETE from $default->owl_files_table where parent = '$fid'";
        $rst2 = $owl_con->execute($del);
   	if(!$rst2) 
   	{
		db_error_handler($owl_con, $sql);
   	} 
	
   	for ($c = 0; $c < $fCount; $c++)
   	{
      		if ($folderList[$c][2] == $fid)
      		{
         		OwlAPI_fDeleteFolderTree($folderList[$c][0]);
      		} 
   	} 
   }
} 
?>
