dnl
dnl checking for joystick
dnl
AC_DEFUN([AC_CHECK_JOYSTICK], [
    AC_ARG_ENABLE([joystick], 
                  AC_HELP_STRING([--disable-joystick], 
                                 [do not activate joystick support]),
                  [enable_joystick=$enableval], [enable_joystick=yes])

    if test x"$enable_joystick" = xyes; then
        AC_DEFINE([HAVE_JOYSTICK],,[Define this if you want oxine to use a joystick.])

        AC_ARG_WITH([jsw],
                    AC_HELP_STRING([--without-jsw],
                                   [Turn off libjsw support.]),
                    [], [with_jsw=yes])

        if test x"$with_jsw" = xyes; then
            have_jsw=yes
            AC_CHECK_LIB(jsw, JSInit,, have_jsw=no)
            if test x"$have_jsw" == x"no"; then
                AC_MSG_WARN([*** It is recommended that you install the joystick wrapper library. ***])
                AC_MSG_WARN([*** libjsw is available from http://wolfpack.twu.net/libjsw/         ***])
            fi
        else
            have_jsw=no
        fi
    fi
])
