
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 * Most of this file was copied from the xine-ui project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: download.h 678 2006-01-18 15:31:17Z mschwerin $
 *
 */

#ifndef HAVE_WEATHER_H
#define HAVE_WEATHER_H
#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_WEATHER

typedef struct {
    int length;
    char **names;
    char **values;

    char *station_id;
    char *station_name;

    char *update_time;
    char *icon_name;

    time_t retrieval_time;
} weather_t;

weather_t *get_current_weather (const char *acid);
void weather_free (weather_t * weather);

void start_weather_thread (void * oxine_p);
void stop_weather_thread (void);

#endif /* HAVE_WEATHER */

#ifdef __cplusplus
}
#endif
#endif /* HAVE_WEATHER_H */
