
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menulist.h 1406 2006-10-21 12:25:25Z mschwerin $
 *
 */

#ifndef HAVE_MENU_LIST_H
#define HAVE_MENU_LIST_H
#ifdef __cplusplus
extern "C" {
#endif

#include "list.h"
#include "otk.h"

typedef struct menuitem_s menuitem_t;
typedef struct menulist_s menulist_t;

struct menuitem_s {
    char *title;

    menulist_t *submenu;
    int is_uplink;

    void (*cb) (void *data);
    void *cb_data;
};

struct menulist_s {
    l_list_t *list;

    menulist_t *parent;
};

menulist_t *menulist_new (const char *mrl, menulist_t * parent);
void menulist_free (menulist_t * menulist);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_MENU_LIST_H */
