
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: desktop_entry.h 1592 2006-11-27 16:27:17Z mschwerin $
 *
 */
#ifndef HAVE_DESKTOP_ENTRY_H
#define HAVE_DESKTOP_ENTRY_H
#ifdef __cplusplus
extern "C" {
#endif


/// Returns a localized string from a desktop entry.
/**
 * @param mrl                   The MRL of the desktop entry file.
 * @param group_name            The name of the entries group.
 * @param entry_name            The name of the entry to retrieve.
 * @return                      The entries value. This string must be freed
 *                              after use.
 */
char *get_localestring_from_desktop_entry (const char *mrl,
                                           const char *group_name,
                                           const char *entry_name);


/// Returns a (non-localized) string from a desktop entry.
/**
 * @param mrl                   The MRL of the desktop entry file.
 * @param group_name            The name of the entries group.
 * @param entry_name            The name of the entry to retrieve.
 * @return                      The entries value. This string must be freed
 *                              after use.
 */
char *get_string_from_desktop_entry (const char *mrl,
                                     const char *group_name,
                                     const char *entry_name);


/// Returns a integer value from a desktop entry.
/**
 * @param mrl                   The MRL of the desktop entry file.
 * @param group_name            The name of the entries group.
 * @param entry_name            The name of the entry to retrieve.
 * @return                      The entries value.
 */
int get_boolean_from_desktop_entry (const char *mrl,
                                    const char *group_name,
                                    const char *entry_name);


/// Returns a double value from a desktop entry.
/**
 * @param mrl                   The MRL of the desktop entry file.
 * @param group_name            The name of the entries group.
 * @param entry_name            The name of the entry to retrieve.
 * @return                      The entries value.
 */
double get_numeric_from_desktop_entry (const char *mrl,
                                       const char *group_name,
                                       const char *entry_name);

#ifdef __cplusplus
}
#endif
#endif
