
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: disc_hal.h 2351 2007-06-27 15:48:02Z mschwerin $
 *
 */

#ifndef HAVE_DBUS_H
#define HAVE_DBUS_H

#include "oxine.h"
#include "types.h"

#ifdef HAVE_HAL

#include <libhal.h>

bool hal_monitor_start (void);
bool hal_monitor_free (void);

LibHalContext *hal_get_context (void);

char *hal_volume_get_udi_from_device (const char *device);
char *hal_volume_get_label_from_device (const char *device);

bool hal_volume_is_mountable (const char *device);
bool hal_volume_is_mounted (const char *device);

#endif /* HAVE_HAL */

#endif /* HAVE_DBUS_H */
