
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 * Some of the code in this file was copied from the xine-ui project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: mutex.h 2580 2007-07-22 13:31:00Z mschwerin $
 *
 */

#ifndef HAVE_MUTEX_H
#define HAVE_MUTEX_H

#include <pthread.h>

// #define DEBUG_THREADS

#if defined (DEBUG_THREADS)

int _mutex_lock (pthread_mutex_t * mutex, char *file, int line);
int _mutex_unlock (pthread_mutex_t * mutex, char *file, int line);

#define mutex_lock(mutex)               _mutex_lock(mutex,__FILE__,__LINE__)
#define mutex_trylock(mutex)            pthread_mutex_trylock(mutex)
#define mutex_unlock(mutex)             _mutex_unlock(mutex,__FILE__,__LINE__)

#elif defined (DEBUG)

int _mutex_lock (pthread_mutex_t * mutex, char *file, int line);

#define mutex_lock(mutex)               _mutex_lock(mutex,__FILE__,__LINE__)
#define mutex_trylock(mutex)            pthread_mutex_trylock(mutex)
#define mutex_unlock(mutex)             pthread_mutex_unlock(mutex)

#else

#define mutex_lock(mutex)               pthread_mutex_lock(mutex)
#define mutex_trylock(mutex)            pthread_mutex_trylock(mutex)
#define mutex_unlock(mutex)             pthread_mutex_unlock(mutex)

#endif /* DEBUG_THREADS */

#endif /* HAVE_MUTEX_H */
