
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: utils_gui.h 2519 2007-07-17 08:39:07Z mschwerin $
 *
 */

#ifndef HAVE_UTILS_GUI_H
#define HAVE_UTILS_GUI_H

#include "i18n.h"
#include "otk.h"
#include "playlist.h"

void schedule_hide_gui_job (int timeout);

void cancel_hide_gui_job (void);

void show_user_interface (void *data_p);

void hide_user_interface (void *data_p);

void show_menu_background (const char *background);

otk_widget_t *create_new_window (bool persistent, bool with_clock);

void show_stream_parameter (odk_stream_param_t param);

typedef enum {
    DIALOG_PLAIN,
    DIALOG_OK,
    DIALOG_OK_CANCEL,
    DIALOG_YES_NO,
    DIALOG_RETRY_CANCEL
} message_dialog_type_t;

void show_message_dialog (otk_cb_t ok_cb, void *ok_cb_data,
                          otk_cb_t cancel_cb, void *cancel_cb_data,
                          message_dialog_type_t type,
                          const char *background_mrl,
                          const char *format, ...);

void repaint_message_dialog (void *data_p);

static inline void
please_wait (void)
{
    show_message_dialog (NULL, NULL, NULL, NULL, DIALOG_PLAIN,
                         NULL, _("Please wait..."));
}

#endif /* HAVE_UTILS_GUI_H */
