
/*
 * Copyright (C) 2006 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: vdr.h 2594 2007-07-24 22:37:58Z mschwerin $
 *
 */

#ifndef HAVE_VDR_H
#define HAVE_VDR_H

#include "types.h"
#include "filelist.h"

#ifdef HAVE_VDR


/// Reads the currently programmed VDR timers into a filelist.
bool vdr_timers_read (filelist_t * filelist);


/// Reads the currently available VDR recordings into a filelist.
bool vdr_recordings_read (filelist_t * filelist);


/// Plays a VDR recording.
bool vdr_recording_play (const char *mrl);


/// Removes a VDR recording.
bool vdr_recording_remove (const char *mrl);


/// Remove a VDR timer.
bool vdr_timer_remove (const char *mrl);


#endif /* HAVE_VDR */
#endif /* HAVE_VDR_H */
