//
// C++ Interface: debtagshelper
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __NUTIL_DEBTAGSHELPER_H_2005_09_24
#define __NUTIL_DEBTAGSHELPER_H_2005_09_24

#include <string>

#include <tagcoll/OpSet.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/entity/tag.h>
#include <apt-front/cache/cache.h>
#include <apt-front/cache/component/tags.h>

using namespace std;

using namespace aptFront::cache;

namespace NUtil
{


inline Tagcoll::OpSet<string> packagesToStrings(const set<entity::Package>& packages)
{
	Tagcoll::OpSet<string> result;
	for (set<entity::Package>::const_iterator it = packages.begin(); it != packages.end(); ++it)
	{
		result.insert(it->name());
	}
	return result;
}


inline Tagcoll::OpSet<string> tagsToStrings(const set<entity::Tag>& tags)
{
	Tagcoll::OpSet<string> result;
	for (set<entity::Tag>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(it->fullname());
	}
	return result;
}

inline Tagcoll::OpSet<entity::Tag> stringsToTags(const set<string>& tags)
{
	Tagcoll::OpSet<entity::Tag> result;
	const aptFront::cache::component::Tags& tagsComponent = aptFront::cache::Global::get().tags();
	for (set<string>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(tagsComponent.tagByName(*it));
	}
	return result;
}

/** Returns the entity::Package with this package name. */
inline entity::Package getPackageByName(const string package)
{
	return aptFront::cache::Global::get().packages().packageByName(package);
}


}

#endif //  __NUTIL_DEBTAGSHELPER_H_2005_09_24
