//
// C++ Interface: taglistviewitem.h
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// The first version of this file was generated by umbrello 
// on Tue May 18 2004 at 20:55:55

#ifndef __TAGLISTVIEWITEM_H_2004_05_18
#define __TAGLISTVIEWITEM_H_2004_05_18

#include <q3listview.h>
#include "tagitem.h"

using namespace std;

namespace Tagcoll
{
	template <typename T> class OpSet;
}


/** We have to inherit this from QObject because else we will see no result of the insertion.
  * Do not ask me why!
  */
class TagListViewItem : public QObject, public Q3ListViewItem, public TagItem 
{
	Q_OBJECT
public:
	/** @brief Adds the Item as child of the handed QListViewItem.
	  *
	  * @param pParent parent item
	  * @param fullTagname full name of the tag to be created
	  * @param description short description for the tag to be created
	  */
	TagListViewItem(Q3ListViewItem* pParent, const string& fullTagname, const string& description="");
	
	/** @brief Adds the Item as child of the handed QListView.
	  *
	  * @param pParent parent listview
	  * @param fullTagname full name of the tag to be created
	  * @param description short description for the tag to be created
	  */
	TagListViewItem(Q3ListView* pParent, const string& fullTagname, const string& description="");

	/** @returns the full name of the tag, this should be unique. */
	virtual const string& fullTagname() const	{ return _fullTagname; };
	/** @returns the #_description property */
	virtual const string& description() const { return _description; }
	/** Sets the #_description property and the text of the second column. */
	void setDescription (const string& value ) 
	{ 
		_description = value; 
		// set the collumn text
		setText(1, QString(_description.c_str()));
	}
	/** @brief Filters the item against the given pattern.
	  *
	  * Checks if the fullTagname() of the item matches the pattern. Recureses in any subitems.
	  * Items that match might make themselves visible, e.g. by expanding a tree.
	  * @param pattern to be searched for
	  * @returns if the pattern was found in the item or recursivly in any subitem
	  */
	virtual bool filterByName(const string& pattern);
	/** @brief Filters the item against the set given set of tags.
	  *
	  * Checks if the the full tagname of the item or a subitem is in the handed 
	  * set and hides the item if not.
	  *
	  * @param shownTags the tags to be shown
	  * @returns if the item is contained in the set, or recursivly in any subitem
	  */
	bool filterByTagset(const Tagcoll::OpSet<string>& shownTags);
private:
	string _description;
	string _fullTagname;
};

#endif	// __TAGLISTVIEWITEM_H_2004_05_18

