//
// C++ Interface: aptfrontpackage
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NAPT_APTFRONTPACKAGE_H_2005_12_26
#define __NAPT_APTFRONTPACKAGE_H_2005_12_26

#include <ipackage.h>

#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/entity/tag.h>
#include <apt-front/cache/component/packagetags.h>
#include <apt-front/cache/component/tags.h>

#include <helpers.h>

namespace NApt 
{

/**
@author Benjamin Mesing
*/
class AptFrontPackage : public IPackage
{
	typedef aptFront::cache::entity::Package Package;
	Package _source;
public:
	AptFrontPackage(const Package& sourcePackage);
	~AptFrontPackage();
	
	virtual QString name() const;
	virtual QString essential() const;
	virtual QString priority() const;
	virtual QString section() const;
	virtual QString installedSize() const;
	virtual QString maintainer() const;
	virtual QString architecture() const;
	virtual QString source() const;
	virtual QString version() const;
	virtual QString replaces() const;
	virtual QString provides() const;
	virtual QString preDepends() const;
	virtual QString depends() const;
	virtual QString recommends() const;
	virtual QString suggests() const;
	virtual QString conflicts() const;
	virtual QString filename() const;
	virtual QString size() const;
	virtual QString md5sum() const;
	virtual QString conffiles() const;
	virtual QString description() const;
	virtual InstalledState installedState() const;
	virtual QString installedVersion() const;
	virtual QString shortDescription() const;

	virtual uint getInstalledSize() const;
	virtual uint getSize() const;

	/** @brief Returns if the source apt-front package is valid. */
	bool isValid()	{ return _source.valid(); }

protected:
	/** @brief Returns a string representation for all relations of the handed type. */
	QString getRelation(aptFront::cache::entity::Relation::Type type) const;

private:
	static QString _emptyString;
};

}

#endif	// __NAPT_APTFRONTPACKAGE_H_2005_12_26
