//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __DUMPAVAILPACKAGEDB_H_2005_02_19
#define __DUMPAVAILPACKAGEDB_H_2005_02_19

#include <map>

#include "ipackagedb.h"
#include "iaptsearch.h"

namespace NPlugin
{
	class IProvider;
}

namespace NApt
{

/**
This is a package database that gets its information from the apt-cache dumpavail command.

@author Benjamin Mesing
*/
class DumpAvailPackageDB : public IPackageDB, public IAptSearch
{
	typedef map<string, Package> PackageMap;
	/** @brief This maps the packages to the package structures. */
	PackageMap _packages;
	/** @brief This holds estimated number of packages. 
	  *
	  * After construction (where set directly) this holds the number of packages
	  * read during the last reloadPackageInformation() call. 
	  */
	uint _estimatedPackageNum;
public:
	typedef QStringList PackageContainer;
	/** Create a new DB parsing the output of apt-cache dumpavail this may take
	  * some time. 
	  *
	  * @param pLoader the observer where to report the progress, 0 if no progress should be reported  
	  * @param estimatedPackageNum the estimated number of packages available (used for progress information)
	  * hand 0 if you can make no assumption (progress reporting will be surpressed
	  */
	DumpAvailPackageDB(NUtil::IProgressObserver* pObserver, uint estimatedPackageNum);

	virtual ~DumpAvailPackageDB();
	/** @name IPackageDB Interface
	  * 
	  * Implementation of the IPackageDB
	  */
	//@{
	virtual const Package& getPackageRecord(const QString& pkg) const;
	virtual const Package& getPackageRecord(const string& package) const;
	virtual const QString getShortDescription(const string& package) const;
	virtual Package::InstalledState getState(const string& package) const;
	virtual void reloadPackageInformation(NUtil::IProgressObserver* pObserver);
	virtual int getDescriptionCount(const string& package, const QString& pattern, bool caseSensitive=false) const;
	virtual bool matchesName(const string& package, const QString& pattern, bool caseSensitive=false) const;
	//@}

	
	/** @name IAptSearch Interface
	  * 
	  * Implementation of the IAptSearch
	  */
	//@{
	virtual bool search(Tagcoll::OpSet<string>& result, const QStringList& includePatterns, 
		const QStringList& excludePatterns, bool searchDescr=true, bool caseSensitive=false) const;
	virtual bool search(Tagcoll::OpSet<string>& result, const QString& pattern, 
		bool searchDescr=true, bool caseSensitive=false) const;
	//@}


};

}	// NApt

#endif	//  __DUMPAVAILPACKAGEDB_H_2005_02_19
