//
// C++ Implementation: unselectedtagsview
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "unselectedtagsview.h"

#include <cassert>
#include <QSortFilterProxyModel>

// NTagModel
#include "vocabularymodelrole.h"
#include "emptytagfilter.h"


/** A filter which accepts a node if it is accepted according to the filter settings <b>or</b>
  * if one of the child nodes is accepted.
  *
  * @author Benjamin Mesing
  */
class TreeSortFilter : public QSortFilterProxyModel
{ 
public:
	TreeSortFilter(QObject * pParent = 0) : QSortFilterProxyModel(pParent)
	{}
	virtual bool filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const
	{
// 		if (filterRegExp().isEmpty())
// 			return true;
		QModelIndex current = sourceModel()->index(sourceRow, 0, sourceParent);
		for( int i = 0; i < sourceModel()->rowCount(current); ++i )
		{
			const QModelIndex child = current.child(i, 0);
			if (filterAcceptsRow(i, current))
				return true;
		}
		return QSortFilterProxyModel::filterAcceptsRow(sourceRow, sourceParent);
	}
};

namespace NTagModel
{


UnselectedTagsView::UnselectedTagsView(QWidget * parent, VocabularyModel* pVocabularyModel)
 : QTreeView(parent), _filterSelectedProxyModel(false, this), _hiddenFilterProxyModel(false, this), _pVocabularyModel(pVocabularyModel)
{
	connect(this, SIGNAL(doubleClicked(const QModelIndex&)), SLOT(onItemDoubleClicked(const QModelIndex&)));
	
	_hiddenFilterProxyModel.setDynamicSortFilter(true);

	_pTagFilter = new EmptyTagFilter(_pVocabularyModel, this);
	_pTagFilter->setDynamicSortFilter(true);
 	
 	_filterSelectedProxyModel.setDynamicSortFilter(true);

// 	TreeSortFilter* pTextFilter2 = new TreeSortFilter(this);
// 	// according to QT-Doc setting the column to -1 should search in all columns
// 	// however this seems not to work
// 	pTextFilter2->setFilterKeyColumn(1);
// 	pTextFilter2->setFilterCaseSensitivity(Qt::CaseInsensitive);
// 	pTextFilter2->setDynamicSortFilter(true);

	_pTextFilter = new TreeSortFilter(this);
	// according to QT-Doc setting the column to -1 should search in all columns
	// however this seems not to work
	_pTextFilter->setFilterKeyColumn(1);
	_pTextFilter->setFilterCaseSensitivity(Qt::CaseInsensitive);
	_pTextFilter->setDynamicSortFilter(true);

// Matrix:
//           hidden empty selected text
// hidden      -      IR     R      R
// empty       -      -
// selected    -      -      -
// text        -      -      -      -
//
// R: repeat
// I: [EmptyTagFilter::filterAcceptsRow] Invalid model index!
// C: crash
	_filterChain.push_back(&_hiddenFilterProxyModel);
	_filterChain.push_back(_pTagFilter);
// seems to result in parents being shown again multiple times, but only in combination with EmptyTagFilter
// A->B->gray->A->B
 	_filterChain.push_back(&_filterSelectedProxyModel);
  	_filterChain.push_back(_pTextFilter);


 	vector<QAbstractProxyModel*>::iterator it = _filterChain.begin();
 	vector<QAbstractProxyModel*>::iterator oldIt = _filterChain.begin();
 	++it;
 	for (; it != _filterChain.end(); ++it )
 	{
 		(*it)->setSourceModel(*oldIt);
 		oldIt = it;
 	}
 	QTreeView::setModel(_filterChain.back());
}


UnselectedTagsView::~UnselectedTagsView()
{
}


void UnselectedTagsView::setModel(QAbstractItemModel* pModel)
{
	_filterChain.front()->setSourceModel(pModel);
//  	_hiddenFilterProxyModel.setSourceModel(pModel);
// 	QTreeView::setModel(pModel);
}


void UnselectedTagsView::onItemDoubleClicked(const QModelIndex& index )
{
	model()->setData(index, true, SelectedRole);
}


void UnselectedTagsView::setFilterFixedString(const QString& string)
{
	_pTextFilter->setFilterFixedString(string);
}

}

