#ifndef __APTPACKAGEDB_H_2024_04_07
#define __APTPACKAGEDB_H_2024_04_07

#include "ipackagedb.h"

#include <map>
#include <string>
#include <list>

// we would probably like to move this out of the header file, but C++ does not make this easy..
#include <apt-pkg/cachefile.h>
#include <apt-pkg/pkgrecords.h>

#include <aptpackage.h>

namespace NApt {

class AptPackageDB : public IPackageDB
{
    pkgCacheFile* _pCacheFile;
    pkgCache* _pPkgCache;
    pkgRecords* _pRecs;
    std::map<std::string, IPackage*> _packageMap;
    std::list<IPackage*> _packages;

    void initializePackages(NUtil::IProgressObserver *pObserver);
    void deletePackages();
public:
    AptPackageDB(NUtil::IProgressObserver *pObserver);
    ~AptPackageDB();

    // IPackageDB interface
public:
    const IPackage* getPackageRecord(const QString &pkg) const;
    const IPackage* getPackageRecord(const string &package) const;
    std::list<IPackage*>::const_iterator packagesBegin() const;
    std::list<IPackage*>::const_iterator packagesEnd() const;
    const QString getShortDescription(const string &package) const;
    IPackage::InstalledState getState(const string &package) const;
    void reloadPackageInformation(NUtil::IProgressObserver *pObserver);
};

} // namespace NApt


#endif // __APTPACKAGEDB_H_2024_04_07
