//=======================================================================
// find.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "find.h"
#include "pkg.h"
#include "pkgset.h"
#include "mainwindow.h"
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/stock.h>
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/liststore.h>

using sigc::mem_fun;
using namespace Gpaco;

Find* Find::spFind = NULL;


Find::Find()
:
	Gtk::Dialog("gpaco :: Find file", *gpMainWindow),
	mEntry(),
	mTreeView(),
	mpChooserDialog(NULL)
{
	set_position(Gtk::WIN_POS_CENTER_ON_PARENT);
	set_border_width(8);
	
	signal_response().connect(mem_fun(*this, &Find::response));

	Gtk::Button* pButtonBrowse = Gtk::manage(new Gtk::Button("_Browse", true));
	pButtonBrowse->signal_clicked().connect(mem_fun(*this, &Find::browse));

	Gtk::HBox* pHBox = Gtk::manage(new Gtk::HBox(false, 6));
	pHBox->pack_start(mEntry, true, true);
	pHBox->pack_start(*pButtonBrowse, false, false);

	Gtk::ScrolledWindow* pScrolledWindow = Gtk::manage(new Gtk::ScrolledWindow());
	pScrolledWindow->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	pScrolledWindow->add(mTreeView);

	get_vbox()->pack_start(*pHBox, false, false);
	get_vbox()->pack_start(*pScrolledWindow, true, true, 10);

	get_action_area()->set_layout(Gtk::BUTTONBOX_EDGE);

	Gtk::Button* pButtonFind = add_button(Gtk::Stock::FIND, Gtk::RESPONSE_APPLY);
	pButtonFind->grab_default();
	mEntry.set_activates_default();

	add_button(Gtk::Stock::CLOSE, Gtk::RESPONSE_CLOSE);

	show_all_children();
}


Find::~Find()
{
	g_assert(spFind != NULL);
}


// [static]
void Find::instance()
{
	if (!spFind)
		spFind = new Find();
	spFind->present();
}


void Find::response(int id)
{
	g_assert(spFind != NULL);

	if (id == Gtk::RESPONSE_APPLY)
		find();
	else {
		delete spFind;
		spFind = NULL;
	}
}


void Find::find()
{
	mTreeView.mpModel->clear();

	Glib::ustring path(mEntry.get_text());
	if (path[0] != '/')
		return;
	
	PkgSet& set = gpMainWindow->treeView().pkgSet();

	for (PkgSet::iterator p = set.begin(); p != set.end(); ++p) {
		if ((*p)->hasFile(path)) {
			Gtk::TreeModel::iterator it = mTreeView.mpModel->append();
			(*it)[mTreeView.mColumns.mPkg] = *p;
			(*it)[mTreeView.mColumns.mName] = (*p)->name();
		}
	}
}


void Find::browseResponse(int id)
{
	if (id == Gtk::RESPONSE_OK)
		mEntry.set_text(mpChooserDialog->get_filename());
}


void Find::browse()
{
	g_assert(mpChooserDialog == NULL);

	mpChooserDialog = new Gtk::FileChooserDialog(*this, "Select file");
	mpChooserDialog->add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
	mpChooserDialog->add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
	mpChooserDialog->set_show_hidden();
	mpChooserDialog->set_default_size(450, 350);

	Glib::ustring path(mEntry.get_text());

	mpChooserDialog->set_filename(path[0] == '/' ? path : "/");
	mpChooserDialog->signal_response().connect(mem_fun(*this, &Find::browseResponse));
	
	mpChooserDialog->run();

	delete mpChooserDialog;
	mpChooserDialog = NULL;
}


//--------------------//
// Find::PkgsTreeView //
//--------------------//


Find::PkgsTreeView::PkgsTreeView()
:
	mColumns(),
	mpModel(Gtk::ListStore::create(mColumns))
{
	set_model(mpModel);
	set_headers_visible(false);
	append_column("", mColumns.mName);
}


void Find::PkgsTreeView::presentPkgWindow()
{
	if (mpModel->children().empty())
		return;
	Gtk::TreeModel::iterator it = (get_selection())->get_selected();
	Pkg* pkg = (*it)[mColumns.mPkg];
	g_assert(pkg != NULL);
	pkg->presentWindow(TAB_FILES);
}


// [virtual]
bool Find::PkgsTreeView::on_key_press_event(GdkEventKey* e)
{
	bool ret = Gtk::TreeView::on_key_press_event(e);

	if (e->keyval == GDK_Return)
		presentPkgWindow();

	return ret;
}


// [virtual]
bool Find::PkgsTreeView::on_button_press_event(GdkEventButton* e)
{
	bool ret = Gtk::TreeView::on_button_press_event(e);

	if (e->type == GDK_2BUTTON_PRESS && e->button == 1)
		presentPkgWindow();

	return ret;
}


