//=======================================================================
// treeview.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "treeview.h"
#include <gtkmm/menu.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/actiongroup.h>

using namespace Gpaco;


TreeView::TreeView()
:
	Gtk::TreeView(),
	mpMenu(NULL),
	mpUIManager(Gtk::UIManager::create()),
	mpActionGroup(Gtk::ActionGroup::create()),
	mpSelection(get_selection())
{
	mpSelection->set_mode(Gtk::SELECTION_MULTIPLE);
	set_rules_hint();
}


// [virtual]
TreeView::~TreeView()
{ }


// [virtual]
void TreeView::writeLabel() const
{ }


int TreeView::countSelected()
{
	return mpSelection->count_selected_rows();
}


void TreeView::selectAll()
{
	mpSelection->select_all();
	writeLabel();
}


void TreeView::unselectAll()
{
	mpSelection->unselect_all();
	writeLabel();
}

