//=======================================================================
// options.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef PACO_OPTIONS_H
#define PACO_OPTIONS_H

#include "pkgset.h"
#include <vector>
#include <iosfwd>
#include <bitset>

namespace Paco {

// Positions in the bitset
enum {
	ALL_PKGS, 
	REVERSE_SORT,
	PRINT_TOTALS,
	PRINT_SIZE,
	PRINT_SIZE_MISS,
	PRINT_FILES_INST,
	PRINT_FILES_MISS,
	PRINT_FILES_SHARED,
	PRINT_FILES_NON_SHARED,
	ONE_COLUMN_LIST,
	PRINT_SYMLINKS,
	NO_PRINT_PKG_NAME,
	PRINT_WHO_SHARES,
	PRINT_DAY,
	PRINT_HOUR,
	REMOVE_UNLOG,
	REMOVE_SHARED,
	REMOVE_BATCH,
	LOG_APPEND,
	LOG_MISSING,
	LOG_IGNORE_ERRORS,
	N_BITS
};


enum Mode {
   	PKGLIST,
   	FILELIST,
   	UPDATE,
   	UNLOG,
   	QUERYFILES,
   	INFO,
   	CONFOPTS,
   	LOG,
   	REMOVE,
   	NMODES
};


class Options : public std::bitset<N_BITS>
{
	public:

	Options(int argc, char* argv[]);

	bool allPkgs() const				{ return test(ALL_PKGS); }
	bool size() const					{ return test(PRINT_SIZE); }
	bool sizeMiss() const				{ return test(PRINT_SIZE_MISS); }
	bool filesInst() const				{ return test(PRINT_FILES_INST); }
	bool filesMiss() const				{ return test(PRINT_FILES_MISS); }
	bool filesShared() const			{ return test(PRINT_FILES_SHARED); }
	bool filesNonShared() const			{ return test(PRINT_FILES_NON_SHARED); }
	bool symlinks() const				{ return test(PRINT_SYMLINKS); }
	bool noPkgName() const				{ return test(NO_PRINT_PKG_NAME); }
	bool whoShares() const				{ return test(PRINT_WHO_SHARES); }
	bool unlog() const					{ return test(REMOVE_UNLOG); }
	bool removeShared() const			{ return test(REMOVE_SHARED); }
	bool batch() const					{ return test(REMOVE_BATCH); }
	bool append() const					{ return test(LOG_APPEND); }
	bool logMissing() const				{ return test(LOG_MISSING); }
	bool logIgnoreErrors() const		{ return test(LOG_IGNORE_ERRORS); }
	bool reverse() const				{ return test(REVERSE_SORT); }
	bool day() const					{ return test(PRINT_DAY); }
	bool hour() const					{ return test(PRINT_HOUR); }

	SortType sortType() const			{ return mSortType; }
	int sizeUnit() const				{ return mSizeUnit; }
	std::string const& skip() const		{ return mSkip; }
	std::string const& logPkg() const	{ return mLogPkg; }
	std::string const& include() const	{ return mInclude; }
	std::string const& exclude() const	{ return mExclude; }
	Mode mode() const					{ return mMode; };
	std::vector<std::string> const& args() const	{ return mArgs; }
	
	bool oneColumn() const
	{
		return test(ONE_COLUMN_LIST) || size() || day() || sizeMiss()
			|| filesInst() || filesMiss() || filesShared();
	}

	bool total() const
	{
		return test(PRINT_TOTALS)
			&& (size() || sizeMiss() || filesInst() || filesMiss());
	}

	void logPkg(std::string const& x)	{ mLogPkg = x; }

	void setMode(Mode m, char optchar);

	private:

	SortType 					mSortType;
	int 						mSizeUnit;
	std::string 				mSkip;
	std::string 				mLogPkg;
	std::string 				mInclude;
	std::string 				mExclude;
	Mode 						mMode;
	std::vector<std::string>	mArgs;

};	// class Options

}	// namespace Paco


#endif  // PACO_OPTIONS_H
