/*
    Copyright (c) 2006 Benhur Stein
    
    This file is part of Paj.

    Paj is free software; you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    Paj is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
    for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Paj; if not, write to the Free Software Foundation, Inc.,
    59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include "EntityChunk.h"
#include "Macros.h"

@implementation EntityChunk

- (id)initWithEntityType:(PajeEntityType *)type
               container:(PajeContainer *)pc
{
    self = [super init];
    if (self != nil) {
        entityType = type;    // not retained
        container = pc;       // not retained
    }
    return self;
}

- (void)dealloc
{
    container = nil;
    entityType = nil;
    Assign(startTime, nil);
    Assign(endTime, nil);
    [super dealloc];
}


- (PajeContainer *)container
{
    return container;
}

- (PajeEntityType *)entityType
{
    return entityType;
}

- (NSDate *)startTime
{
    return startTime;
}

- (void)setStartTime:(NSDate *)time
{
    Assign(startTime, time);
}

- (NSDate *)endTime
{
    return endTime;
}

- (void)setEndTime:(NSDate *)time
{
    Assign(endTime, time);
}

- (id)filterEntity:(PajeEntity *)entity laterThan:(NSDate *)time
{
    if ([[entity startTime] isLaterThanDate:time]) {
        return nil;
    } else {
        return entity;
    }
}


- (NSEnumerator *)enumeratorOfAllCompleteEntities
{
    [self subclassResponsibility:_cmd];
    return nil;
}

- (NSEnumerator *)enumeratorOfCompleteEntitiesAfterTime:(NSDate *)time
{
    [self subclassResponsibility:_cmd];
    return nil;
}

- (NSEnumerator *)enumeratorOfAllEntities
{
    [self subclassResponsibility:_cmd];
    return nil;
}

- (NSEnumerator *)enumeratorOfEntitiesBeforeTime:(NSDate *)time
{
    [self subclassResponsibility:_cmd];
    return nil;
}

- (NSEnumerator *)enumeratorOfEntitiesFromTime:(NSDate *)sliceStartTime
                                        toTime:(NSDate *)sliceEndTime
{
    [self subclassResponsibility:_cmd];
    return nil;
}

- (id)copyWithZone:(NSZone *)z
{
    EntityChunk *copy;
    copy = [[[self class] alloc] initWithEntityType:entityType
                                          container:container];
    [copy setStartTime:startTime];
    [copy setEndTime:endTime];
    return copy;
}
@end
