-- some functions generating infinite lists:


-- the list of natural numbers:
from n = n : from (n+1)


-- Fibonacci numbers:
fibs = fibgen 1 1
fibgen n1 n2 = n1 : fibgen n2 (n1+n2)

goal1 = take 10 fibs


-- the list of primes generated by the
-- Sieve of Erathostenes:
primes = sieve (from 2)
 
sieve (x:xs) = x : sieve (filter (\y -> y `mod` x > 0) xs)

goal2 = take 5 primes


-- Hamming numbers:
ordMerge (x:xs) (y:ys) | x==y = x:ordMerge xs ys
                       | x<y  = x:ordMerge xs (y:ys)
                       | x>y  = y:ordMerge (x:xs) ys

hamming = 1:ordMerge (map (*2) hamming)
                     (ordMerge (map (*3) hamming)
                               (map (*5) hamming))

goal3 = take 10 hamming
