/*
**  Charset.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/Charset.h>

#include <Pantomime/Constants.h>

@implementation Charset

//
//
//
- (id) initWithCodeCharTable: (const struct charset_code *)c  length: (int)n
{
  self = [super init];
  
  codes = c;
  num_codes = n;
  
  identity_map = 0x20;
  if (n>0 && codes[0].code==0x20)
    {
      int i = 1;
      for (identity_map=0x20;
	   i < num_codes && codes[i].code == identity_map + 1 && codes[i].value == identity_map + 1;
	   identity_map++,i++) ;
    }

  return self;
}


//
//
//
- (unichar) characterForCode: (int) theCode;
{
  int l, h, m;
  
  if ( theCode <= identity_map )
    {
      return theCode;
    }

  l = 0;
  h = num_codes - 1;
  while (l <= h)
    {
      m = (l + h) / 2;
      
      if (codes[m].code == theCode)
	{
	  return codes[m].value;
	}
      
      if (codes[m].code > theCode)
	{
	  l = m + 1;
	}
      else
	{
	  h = m - 1;
	}
    }

  /* U+FFFD is supposed to be used for invalid characters */
  return 0xfffd;
}


//
// TODO: what should this return for eg. \t and \n?
//
- (int) codeForCharacter: (unichar) theCharacter;
{
  int i;

  if (theCharacter <= identity_map)
    {
      return theCharacter;
    }
  
  for (i = 0; i < num_codes; i++)
    {
      if (codes[i].value == theCharacter)
	{
	  return codes[i].code;
	}
    }
  
  return -1;
}


//
//
//
- (BOOL) characterIsInCharset: (unichar) theCharacter
{
  if (theCharacter <= identity_map)
    {
      return YES;
    }

  if ([self codeForCharacter: theCharacter] != -1)
    {
      return YES;
    }
  
  return NO;
}


//
// Returns the name of the Charset. Like:
// "iso-8859-1"
// 
- (NSString *) name
{
  [self subclassResponsibility: _cmd];
  return nil;
}

@end
