/*
**  IMAPMessage.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/IMAPMessage.h>

#include <Pantomime/Constants.h>
#include <Pantomime/Flags.h>
#include <Pantomime/IMAPFolder.h>
#include <Pantomime/IMAPStore.h>

#include <Foundation/NSDebug.h>
#include <Foundation/NSValue.h>


//
//
//
@implementation IMAPMessage 

- (id) init
{
  self = [super init];
  
  [self setUID: 0];

  return self;
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  // Must also encode Message's superclass
  [super encodeWithCoder: theCoder];
  
  [theCoder encodeObject: [NSNumber numberWithInt: [self UID]]];
}


//
//
//
- (id) initWithCoder: (NSCoder *) theCoder
{
  // Must also decode Message's superclass
  self = [super initWithCoder: theCoder];

  [self setUID: [[theCoder decodeObject] intValue]];

  return self;
}


//
// access / mutation methods
//
- (int) UID
{
  return UID;
}


//
//
//
- (void) setUID: (int) theUID
{
  UID = theUID;
}


//
// This method is called to initialize the message if it wasn't.
// If we set it to NO and we HAD a content, we release the content.
//
- (void) setInitialized: (BOOL) aBOOL
{
  [super setInitialized: aBOOL];

  if ( aBOOL )
    {
      id aStore;

      aStore = [(IMAPFolder *)[self folder] store];

      [aStore _sendCommand: [NSString stringWithFormat: @"UID FETCH %d:%d BODY.PEEK[HEADER.FIELDS.NOT (From To Cc Subject Date Message-ID References In-Reply-To MIME-Version)]", [self UID], [self UID]]];

      // If we are no longer connected to the IMAP server, we don't send the 2nd command.
      // This will prevent us from calling the delegate method twice (the one that handles
      // the disconnection from the IMAP server).
      if ( [aStore isConnected] )
	{
	  [aStore _sendCommand: [NSString stringWithFormat: @"UID FETCH %d:%d BODY[TEXT]", 
					  [self UID], [self UID]]];
	}
    }
  else
    {
      DESTROY(content);
    }
}


//
// IMAP specific implementation of the rawSource method.
//
- (NSData *) rawSource
{
  [(IMAPStore *)[[self folder] store] _sendCommand: [NSString stringWithFormat: @"UID FETCH %d:%d RFC822", 
							      [self UID], [self UID]]];
  
  return rawSource;
}


//
// This method will REPLACE all the flags on the server
// for this message with the flags specified in the argument.
//
- (void) setFlags: (Flags *) theFlags
{
  [[self folder] setFlags: theFlags
		 messages: [NSArray arrayWithObject: self]];
}

@end
