/*
**  LocalStore.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_LocalStore
#define _Pantomime_H_LocalStore

#include <Pantomime/Store.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSEnumerator.h>
#import <Foundation/NSFileManager.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

// Maibox formats supported
#define MAILBOX_FORMAT_MBOX	0
#define MAILBOX_FORMAT_MAILDIR	1
#define MAILBOX_FORMAT_FOLDER	2

@class Message;
@class LocalFolder;

@interface LocalStore : NSObject <Store>
{
  @private
    NSString *path;
    NSMutableDictionary *folders;
    NSFileManager *fileManager;
    NSMutableArray *folderArray;
}

- (id) initWithPathToDirectory: (NSString *) thePath;

- (NSEnumerator *) folderEnumerator;

- (NSString *) path;
- (void) setPath: (NSString *) thePath;

- (NSEnumerator *) openedFoldersEnumerator;
- (void) removeFolderFromOpenedFolders: (LocalFolder *) theFolder;
- (BOOL) folderForNameIsOpen: (NSString *) theName;

- (void) enforceMode: (unsigned long) theMode
              atPath: (NSString *) thePath;

@end


//
// Private interface
//
@interface LocalStore (Private)

- (void) _enforceFileAttributes;

- (NSEnumerator *) _rebuildFolderEnumerator;

@end

#endif // _Pantomime_H_LocalStore
