/*
**  URLName.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_URLName
#define _Pantomime_H_URLName

#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@interface URLName : NSObject
{
  // ivars
  NSString *protocol;

  NSString *foldername;
  NSString *path;
  
  NSString *host;
  int port;

  NSString *username;
  NSString *password;
}

- (id) initWithString: (NSString *) theString;

- (id) initWithString: (NSString *) theString
                 path: (NSString *) thePath;

- (void) dealloc;

//
// access/mutation methods
//

- (NSString *) protocol;

- (NSString *) foldername;
- (NSString *) path;

- (NSString *) host;
- (int) port;

- (NSString *) username;
- (NSString *) password;

- (NSString *) description;

- (NSString *) stringValue;

@end


//
// Private methods
//
@interface URLName (Private)

- (void) _decodeIMAP: (NSString *) theString;
- (void) _decodeLocal: (NSString *) theString;
- (void) _decodePOP3: (NSString *) theString;

- (void) _decodeURL: (NSString *) theString;

@end

#endif // _Pantomime_H_URLName
