#ifndef INCLUDE_LIST_H
#define INCLUDE_LIST_H

#include "Connection.h"
class PapayaListElement {

 public:

  PapayaListElement();
  ~PapayaListElement();

  void setNext(PapayaListElement *);
  PapayaListElement * getNext();

  void setConnection(Connection *);
  Connection * getConnection();

  void setData(void *);
  void * getData();

 private:

  PapayaListElement * next;
  Connection * connection;
  void * data;

};

class PapayaList {

 public:

  PapayaList();
  ~PapayaList();

  PapayaListElement * findEntry(Connection *);
  PapayaListElement * findEntry(void *);
  PapayaListElement * newEntry(Connection *, void *);
  PapayaListElement * newEntry(void *);
  void deleteEntry(Connection *);
  void deleteEntry(PapayaListElement *);
  void deleteAll();
  PapayaListElement * firstElement;


};

#endif // INCLUDE_LIST_H
