/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.collision.BulkContact;
import org.odejava.ode.OdeConstants;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLRigidBodyNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseContact
extends AbstractNode {
    protected static final int FIELD_APPLIED_PARAMETERS = 1;
    protected static final int FIELD_BODY1 = 2;
    protected static final int FIELD_BODY2 = 3;
    protected static final int FIELD_BOUNCE = 4;
    protected static final int FIELD_CONTACT_NORMAL = 5;
    protected static final int FIELD_DEPTH = 6;
    protected static final int FIELD_FRICTION_COEFFICIENTS = 7;
    protected static final int FIELD_FRICTION_DIRECTION = 8;
    protected static final int FIELD_GEOMETRY1 = 9;
    protected static final int FIELD_GEOMETRY2 = 10;
    protected static final int FIELD_MIN_BOUNCE_SPEED = 11;
    protected static final int FIELD_POSITION = 12;
    protected static final int FIELD_SLIP_COEFFICIENTS = 13;
    protected static final int FIELD_SURFACE_SPEED = 14;
    protected static final int FIELD_SOFTNESS_CFM = 15;
    protected static final int FIELD_SOFTNESS_ERP = 16;
    protected static final int LAST_CONTACT_INDEX = 16;
    private static final int NUM_FIELDS = 17;
    protected static final String BODY_PROTO_MSG = "Proto does not describe a Body object";
    protected static final String BODY_NODE_MSG = "Node does not describe a Body object";
    protected static final String GEOMETRY_PROTO_MSG = "Proto does not describe a X3DCollidableNode object";
    protected static final String GEOMETRY_NODE_MSG = "Node does not describe a X3DCollidableNode object";
    protected static final String NEG_BOUNCE_MSG = "bounce is required to be non-negative: ";
    protected static final String NEG_BOUNCE_SPEED_MSG = "minBounceSpeed is required to be non-negative: ";
    protected static final String NEG_ERP_MSG = "softnessErrorReduction is required to be non-negative: ";
    protected static final String NEG_CFM_MSG = "softnessConstantForceMix is required to be non-negative: ";
    private static final int[] nodeFields = new int[]{0, 2, 3, 9, 10};
    private static final VRMLFieldDeclaration[] fieldDecl = new VRMLFieldDeclaration[17];
    private static final HashMap fieldMap = new HashMap(51);
    protected static final HashMap parameterIdMap;
    protected VRMLRigidBodyNodeType vfBody1;
    protected VRMLProtoInstance pBody1;
    protected VRMLRigidBodyNodeType vfBody2;
    protected VRMLProtoInstance pBody2;
    protected VRMLNBodyCollidableNodeType vfGeometry1;
    protected VRMLProtoInstance pGeometry1;
    protected VRMLNBodyCollidableNodeType vfGeometry2;
    protected VRMLProtoInstance pGeometry2;
    protected String[] vfAppliedParameters;
    protected int numAppliedParameters = 1;
    protected float vfBounce;
    protected float vfMinBounceSpeed = 0.1f;
    protected float vfDepth = 0.0f;
    protected float[] vfContactNormal = new float[]{0.0f, 1.0f, 0.0f};
    protected float[] vfFrictionCoefficients = new float[2];
    protected float[] vfFrictionDirection = new float[]{0.0f, 1.0f, 0.0f};
    protected float[] vfPosition = new float[3];
    protected float[] vfSlipCoefficients = new float[2];
    protected float[] vfSurfaceSpeed = new float[2];
    protected float vfSoftnessErrorCorrection = 0.8f;
    protected float vfSoftnessConstantForceMix = 1.0E-4f;
    protected BulkContact odeContact;
    protected int contactIndex;
    private int surfaceModeFlags;

    public BaseContact() {
        super("Contact");
        this.vfAppliedParameters = new String[]{"BOUNCE"};
        this.surfaceModeFlags = OdeConstants.dContactApprox1 | OdeConstants.dContactBounce;
        this.hasChanged = new boolean[17];
    }

    public BaseContact(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("bounce");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("minBounceSpeed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinBounceSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("softnessConstantForceMix");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSoftnessConstantForceMix = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("softnessErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSoftnessErrorCorrection = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pBody1 != null) {
            this.pBody1.setupFinished();
        } else if (this.vfBody1 != null) {
            this.vfBody1.setupFinished();
        }
        if (this.pBody2 != null) {
            this.pBody2.setupFinished();
        } else if (this.vfBody2 != null) {
            this.vfBody2.setupFinished();
        }
        if (this.pGeometry1 != null) {
            this.pGeometry1.setupFinished();
        } else if (this.vfGeometry1 != null) {
            this.vfGeometry1.setupFinished();
        }
        if (this.pGeometry2 != null) {
            this.pGeometry2.setupFinished();
        } else if (this.vfGeometry2 != null) {
            this.vfGeometry2.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return -1;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 16) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pBody1 != null ? this.pBody1 : this.vfBody1;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pBody2 != null ? this.pBody2 : this.vfBody2;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfContactNormal;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfDepth;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfFrictionCoefficients;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfFrictionDirection;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pGeometry1 != null ? this.pGeometry1 : this.vfGeometry1;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pGeometry2 != null ? this.pGeometry2 : this.vfGeometry2;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPosition;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSlipCoefficients;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSurfaceSpeed;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfAppliedParameters;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.numAppliedParameters;
                break;
            }
            case 15: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSoftnessConstantForceMix;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 16: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSoftnessErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    if (this.pBody1 != null) {
                        vRMLNodeType.setValue(n2, this.pBody1);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfBody1);
                    break;
                }
                case 3: {
                    if (this.pBody2 != null) {
                        vRMLNodeType.setValue(n2, this.pBody2);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfBody2);
                    break;
                }
                case 9: {
                    if (this.pGeometry1 != null) {
                        vRMLNodeType.setValue(n2, this.pGeometry1);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfGeometry1);
                    break;
                }
                case 10: {
                    if (this.pGeometry2 != null) {
                        vRMLNodeType.setValue(n2, this.pGeometry2);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfGeometry2);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfBounce);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfContactNormal, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfDepth);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfFrictionCoefficients, 2);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfFrictionDirection, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfMinBounceSpeed);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfPosition, 3);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfSlipCoefficients, 2);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfSurfaceSpeed, 2);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfAppliedParameters, this.numAppliedParameters);
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfSoftnessConstantForceMix);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfSoftnessErrorCorrection);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseJointNode.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseJointNode.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setBounce(f);
                break;
            }
            case 6: {
                this.setDepth(f);
                break;
            }
            case 11: {
                this.setBounceSpeed(f);
                break;
            }
            case 15: {
                this.setSoftnessConstantForceMix(f);
                break;
            }
            case 16: {
                this.setSoftnessErrorCorrection(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 5: {
                this.setContactNormal(fArray);
                break;
            }
            case 7: {
                this.setFrictionCoefficients(fArray);
                break;
            }
            case 8: {
                this.setFrictionDirection(fArray);
                break;
            }
            case 12: {
                this.setPosition(fArray);
                break;
            }
            case 13: {
                this.setSlipCoefficients(fArray);
                break;
            }
            case 14: {
                this.setSurfaceSpeed(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 1: {
                this.setAppliedParameters(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 2: {
                this.setBody1(vRMLNodeType);
                break;
            }
            case 3: {
                this.setBody2(vRMLNodeType);
                break;
            }
            case 9: {
                this.setGeometry1(vRMLNodeType);
                break;
            }
            case 10: {
                this.setGeometry2(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    void setContact(BulkContact bulkContact, int n, IntHashMap intHashMap, IntHashMap intHashMap2) {
        this.odeContact = bulkContact;
        this.contactIndex = n;
        this.vfBounce = this.odeContact.getBounce(this.contactIndex);
        this.vfDepth = this.odeContact.getDepth(this.contactIndex);
        this.vfMinBounceSpeed = this.odeContact.getBounceVel(this.contactIndex);
        this.vfSoftnessErrorCorrection = this.odeContact.getSoftErp(this.contactIndex);
        this.vfSoftnessConstantForceMix = this.odeContact.getSoftCfm(this.contactIndex);
        this.odeContact.getNormal(this.vfContactNormal, this.contactIndex);
        this.odeContact.getPosition(this.vfPosition, this.contactIndex);
        this.odeContact.getFdir1(this.vfFrictionDirection, this.contactIndex);
        this.vfFrictionCoefficients[0] = this.odeContact.getMu(this.contactIndex);
        this.vfFrictionCoefficients[1] = this.odeContact.getMu2(this.contactIndex);
        this.vfSlipCoefficients[0] = this.odeContact.getSlip1(this.contactIndex);
        this.vfSlipCoefficients[1] = this.odeContact.getSlip2(this.contactIndex);
        this.vfSurfaceSpeed[0] = this.odeContact.getMotion1(this.contactIndex);
        this.vfSurfaceSpeed[1] = this.odeContact.getMotion2(this.contactIndex);
        int n2 = this.odeContact.getBodyID1(this.contactIndex);
        this.vfBody1 = (VRMLRigidBodyNodeType)intHashMap.get(n2);
        this.pBody1 = null;
        n2 = this.odeContact.getBodyID2(this.contactIndex);
        this.vfBody2 = (VRMLRigidBodyNodeType)intHashMap.get(n2);
        this.pBody2 = null;
        int n3 = this.odeContact.getGeomID1(this.contactIndex);
        this.vfGeometry1 = (VRMLNBodyCollidableNodeType)intHashMap2.get(n3);
        this.pGeometry1 = null;
        n3 = this.odeContact.getGeomID2(this.contactIndex);
        this.vfGeometry2 = (VRMLNBodyCollidableNodeType)intHashMap2.get(n3);
        this.pGeometry2 = null;
    }

    int getContactIndex() {
        return this.contactIndex;
    }

    BulkContact getContacts() {
        return this.odeContact;
    }

    private void setSoftnessErrorCorrection(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_ERP_MSG + f);
        }
        this.vfSoftnessErrorCorrection = f;
        if (!this.inSetup) {
            this.odeContact.setSoftErp(f, this.contactIndex);
            this.hasChanged[16] = true;
            this.fireFieldChanged(16);
        }
    }

    private void setSoftnessConstantForceMix(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_CFM_MSG + f);
        }
        this.vfSoftnessConstantForceMix = f;
        if (!this.inSetup) {
            this.odeContact.setSoftCfm(f, this.contactIndex);
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    private void setBounce(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_BOUNCE_MSG + f);
        }
        this.vfBounce = f;
        if (!this.inSetup) {
            this.odeContact.setBounce(f, this.contactIndex);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setBounceSpeed(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_BOUNCE_SPEED_MSG + f);
        }
        this.vfMinBounceSpeed = f;
        if (!this.inSetup) {
            this.odeContact.setBounceVel(f, this.contactIndex);
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    private void setDepth(float f) {
        this.vfDepth = f;
        if (!this.inSetup) {
            this.odeContact.setDepth(f, this.contactIndex);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setContactNormal(float[] fArray) {
        this.vfContactNormal[0] = fArray[0];
        this.vfContactNormal[1] = fArray[1];
        this.vfContactNormal[2] = fArray[2];
        if (!this.inSetup) {
            this.odeContact.setNormal(fArray, this.contactIndex);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setFrictionCoefficients(float[] fArray) {
        this.vfFrictionCoefficients[0] = fArray[0];
        this.vfFrictionCoefficients[1] = fArray[1];
        if (!this.inSetup) {
            this.odeContact.setMu(fArray[0], this.contactIndex);
            this.odeContact.setMu2(fArray[1], this.contactIndex);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setFrictionDirection(float[] fArray) {
        this.vfFrictionDirection[0] = fArray[0];
        this.vfFrictionDirection[1] = fArray[1];
        this.vfFrictionDirection[2] = fArray[2];
        if (!this.inSetup) {
            this.odeContact.setFdir1(fArray, this.contactIndex);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setPosition(float[] fArray) {
        this.vfPosition[0] = fArray[0];
        this.vfPosition[1] = fArray[1];
        this.vfPosition[2] = fArray[2];
        if (!this.inSetup) {
            this.odeContact.setPosition(fArray, this.contactIndex);
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    private void setSlipCoefficients(float[] fArray) {
        this.vfSlipCoefficients[0] = fArray[0];
        this.vfSlipCoefficients[1] = fArray[1];
        if (!this.inSetup) {
            this.odeContact.setSlip1(fArray[0], this.contactIndex);
            this.odeContact.setSlip2(fArray[1], this.contactIndex);
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    private void setSurfaceSpeed(float[] fArray) {
        this.vfSurfaceSpeed[0] = fArray[0];
        this.vfSurfaceSpeed[1] = fArray[1];
        if (!this.inSetup) {
            this.odeContact.setMotion1(fArray[0], this.contactIndex);
            this.odeContact.setMotion2(fArray[1], this.contactIndex);
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    private void setAppliedParameters(String[] stringArray, int n) {
        if (this.vfAppliedParameters.length < n) {
            this.vfAppliedParameters = new String[n];
        }
        this.surfaceModeFlags = OdeConstants.dContactApprox1;
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)parameterIdMap.get(stringArray[i]);
            if (n2 != null) {
                this.surfaceModeFlags |= n2.intValue();
            }
            this.vfAppliedParameters[i] = stringArray[i];
        }
        this.numAppliedParameters = n;
        if (!this.inSetup) {
            this.odeContact.setMode(this.surfaceModeFlags, this.contactIndex);
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    private void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        VRMLRigidBodyNodeType vRMLRigidBodyNodeType = null;
        VRMLNodeType vRMLNodeType3 = this.pBody1 != null ? this.pBody1 : this.vfBody1;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pBody1 = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLRigidBodyNodeType)) {
                throw new InvalidFieldValueException(BODY_PROTO_MSG);
            }
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLRigidBodyNodeType) {
            this.pBody1 = null;
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
        } else if (vRMLNodeType != null) {
            throw new InvalidFieldValueException(BODY_NODE_MSG);
        }
        this.vfBody1 = vRMLRigidBodyNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType3 != null) {
            this.updateRefs(vRMLNodeType3, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType3 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType3);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            if (this.vfBody1 != null) {
                vRMLNodeType2 = this.vfBody1.getODEBody();
                int n = vRMLNodeType2.getNativeAddr();
                this.odeContact.setBodyID1(n, this.contactIndex);
            } else {
                this.odeContact.setBodyID1(0, this.contactIndex);
            }
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        VRMLRigidBodyNodeType vRMLRigidBodyNodeType = null;
        VRMLNodeType vRMLNodeType3 = this.pBody2 != null ? this.pBody2 : this.vfBody2;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pBody2 = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLRigidBodyNodeType)) {
                throw new InvalidFieldValueException(BODY_PROTO_MSG);
            }
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLRigidBodyNodeType) {
            this.pBody2 = null;
            vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
        } else if (vRMLNodeType != null) {
            throw new InvalidFieldValueException(BODY_NODE_MSG);
        }
        this.vfBody2 = vRMLRigidBodyNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType3 != null) {
            this.updateRefs(vRMLNodeType3, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType3 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType3);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            if (this.vfBody2 != null) {
                vRMLNodeType2 = this.vfBody2.getODEBody();
                int n = vRMLNodeType2.getNativeAddr();
                this.odeContact.setBodyID2(n, this.contactIndex);
            } else {
                this.odeContact.setBodyID2(0, this.contactIndex);
            }
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setGeometry1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType = null;
        VRMLNodeType vRMLNodeType3 = this.pGeometry1 != null ? this.pGeometry1 : this.vfGeometry1;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pGeometry1 = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLNBodyCollidableNodeType)) {
                throw new InvalidFieldValueException(GEOMETRY_PROTO_MSG);
            }
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLNBodyCollidableNodeType) {
            this.pGeometry1 = null;
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType;
        } else if (vRMLNodeType != null) {
            throw new InvalidFieldValueException(GEOMETRY_NODE_MSG);
        }
        this.vfGeometry1 = vRMLNBodyCollidableNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType3 != null) {
            this.updateRefs(vRMLNodeType3, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType3 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType3);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            if (this.vfGeometry1 != null) {
                vRMLNodeType2 = this.vfGeometry1.getODEGeometry();
                int n = vRMLNodeType2.getNativeAddr();
                this.odeContact.setGeomID1(n, this.contactIndex);
            } else {
                this.odeContact.setGeomID1(0, this.contactIndex);
            }
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setGeometry2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType = null;
        VRMLNodeType vRMLNodeType3 = this.pGeometry2 != null ? this.pGeometry2 : this.vfGeometry2;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pGeometry2 = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLNBodyCollidableNodeType)) {
                throw new InvalidFieldValueException(GEOMETRY_PROTO_MSG);
            }
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLNBodyCollidableNodeType) {
            this.pGeometry2 = null;
            vRMLNBodyCollidableNodeType = (VRMLNBodyCollidableNodeType)vRMLNodeType;
        } else if (vRMLNodeType != null) {
            throw new InvalidFieldValueException(GEOMETRY_NODE_MSG);
        }
        this.vfGeometry2 = vRMLNBodyCollidableNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType3 != null) {
            this.updateRefs(vRMLNodeType3, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType3 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType3);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            if (this.vfGeometry2 != null) {
                vRMLNodeType2 = this.vfGeometry2.getODEGeometry();
                int n = vRMLNodeType2.getNativeAddr();
                this.odeContact.setGeomID2(n, this.contactIndex);
            } else {
                this.odeContact.setGeomID2(0, this.contactIndex);
            }
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    static {
        BaseContact.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseContact.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFString", "appliedParameters");
        BaseContact.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseContact.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseContact.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "depth");
        BaseContact.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFNode", "geometry1");
        BaseContact.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFNode", "geometry2");
        BaseContact.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "bounce");
        BaseContact.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "contactNormal");
        BaseContact.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFVec2f", "frictionCoefficients");
        BaseContact.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "frictionDirection");
        BaseContact.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFFloat", "minBounceSpeed");
        BaseContact.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFVec3f", "position");
        BaseContact.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFVec2f", "slipCoefficients");
        BaseContact.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFVec2f", "surfaceSpeed");
        BaseContact.fieldDecl[16] = new VRMLFieldDeclaration(3, "SFFloat", "softnessErrorCorrection");
        BaseContact.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFFloat", "softnessConstantForceMix");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(3);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        n = new Integer(9);
        fieldMap.put("geometry1", n);
        fieldMap.put("set_geometry1", n);
        fieldMap.put("geometry1_changed", n);
        n = new Integer(10);
        fieldMap.put("geometry2", n);
        fieldMap.put("set_geometry2", n);
        fieldMap.put("geometry2_changed", n);
        n = new Integer(4);
        fieldMap.put("bounce", n);
        fieldMap.put("set_bounce", n);
        fieldMap.put("bounce_changed", n);
        n = new Integer(11);
        fieldMap.put("minBounceSpeed", n);
        fieldMap.put("set_minBounceSpeed", n);
        fieldMap.put("minBounceSpeed_changed", n);
        n = new Integer(5);
        fieldMap.put("contactNormal", n);
        fieldMap.put("set_contactNormal", n);
        fieldMap.put("contactNormal_changed", n);
        n = new Integer(7);
        fieldMap.put("frictionCoefficients", n);
        fieldMap.put("set_frictionCoefficients", n);
        fieldMap.put("frictionCoefficients_changed", n);
        n = new Integer(8);
        fieldMap.put("frictionDirection", n);
        fieldMap.put("set_frictionDirection", n);
        fieldMap.put("frictionDirection_changed", n);
        n = new Integer(13);
        fieldMap.put("slipCoefficients", n);
        fieldMap.put("set_slipCoefficients", n);
        fieldMap.put("slipCoefficients_changed", n);
        n = new Integer(14);
        fieldMap.put("surfaceSpeed", n);
        fieldMap.put("set_surfaceSpeed", n);
        fieldMap.put("surfaceSpeed_changed", n);
        n = new Integer(1);
        fieldMap.put("appliedParameters", n);
        fieldMap.put("set_appliedParameters", n);
        fieldMap.put("appliedParameters_changed", n);
        n = new Integer(6);
        fieldMap.put("depth", n);
        fieldMap.put("set_depth", n);
        fieldMap.put("depth_changed", n);
        n = new Integer(12);
        fieldMap.put("position", n);
        fieldMap.put("set_position", n);
        fieldMap.put("position_changed", n);
        n = new Integer(15);
        fieldMap.put("softnessConstantForceMix", n);
        fieldMap.put("set_softnessConstantForceMix", n);
        fieldMap.put("softnessConstantForceMix_changed", n);
        n = new Integer(16);
        fieldMap.put("softnessErrorCorrection", n);
        fieldMap.put("set_softnessErrorCorrection", n);
        fieldMap.put("softnessErrorCorrection_changed", n);
        parameterIdMap = new HashMap();
        parameterIdMap.put("BOUNCE", new Integer(OdeConstants.dContactBounce));
        parameterIdMap.put("USER_FRICTION", new Integer(OdeConstants.dContactFDir1));
        parameterIdMap.put("FRICTION_COEFFICIENT-2", new Integer(OdeConstants.dContactMu2));
        parameterIdMap.put("ERROR_REDUCTION", new Integer(OdeConstants.dContactSoftERP));
        parameterIdMap.put("CONSTANT_FORCE", new Integer(OdeConstants.dContactSoftCFM));
        parameterIdMap.put("SPEED-1", new Integer(OdeConstants.dContactMotion1));
        parameterIdMap.put("SPEED-2", new Integer(OdeConstants.dContactMotion2));
        parameterIdMap.put("SLIP-1", new Integer(OdeConstants.dContactSlip1));
        parameterIdMap.put("SLIP-2", new Integer(OdeConstants.dContactSlip2));
    }
}

