/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geom3d;

import java.util.HashMap;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseIndexedGeometryNode;

public abstract class BaseIndexedFaceSet
extends BaseIndexedGeometryNode {
    protected static final int FIELD_CREASEANGLE = 19;
    protected static final int FIELD_CONVEX = 20;
    private static final int NUM_FIELDS = 21;
    private static final int LAST_INDEXEDFACESET_INDEX = 20;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected boolean vfConvex;
    protected float vfCreaseAngle;
    protected GeometryData geomData;

    protected BaseIndexedFaceSet() {
        super("IndexedFaceSet");
        this.hasChanged = new boolean[21];
        this.vfConvex = true;
        this.vfCreaseAngle = 0.0f;
    }

    protected BaseIndexedFaceSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
        int n = vRMLNodeType.getFieldIndex("convex");
        VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
        this.vfConvex = vRMLFieldData.booleanValue;
        n = vRMLNodeType.getFieldIndex("creaseAngle");
        vRMLFieldData = vRMLNodeType.getFieldValue(n);
        this.vfCreaseAngle = vRMLFieldData.floatValue;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        switch (n) {
            case 20: {
                vRMLFieldData.booleanValue = this.vfConvex;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 19: {
                vRMLFieldData.floatValue = this.vfCreaseAngle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 20) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (vRMLNodeType == this.vfCoord) {
            this.changeFlags |= 1;
        } else if (vRMLNodeType == this.vfColor) {
            this.changeFlags |= 8;
        } else if (vRMLNodeType == this.vfNormal) {
            this.changeFlags |= 2;
        } else if (vRMLNodeType == this.vfTexCoord) {
            this.changeFlags |= 4;
        } else {
            System.out.println("BaseIndexedFaceSet: Unknown field fieldChanged");
        }
        this.stateManager.addEndOfThisFrameListener(this);
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                if (vRMLNodeType.getPrimaryType() != 9) {
                    throw new InvalidFieldValueException("Proto does not describe a Color object");
                }
                this.localColors = true;
                this.fireLocalColorsChanged(true);
                this.changeFlags |= 8;
                break;
            }
            case 1: {
                if (vRMLNodeType.getPrimaryType() != 11) {
                    throw new InvalidFieldValueException("Proto does not describe a Coord object");
                }
                this.changeFlags |= 1;
                break;
            }
            case 3: {
                if (vRMLNodeType.getPrimaryType() != 34) {
                    throw new InvalidFieldValueException("Proto does not describe a Normal object");
                }
                this.changeFlags |= 2;
                break;
            }
            case 4: {
                if (vRMLNodeType.getPrimaryType() != 48) {
                    throw new InvalidFieldValueException("Proto does not describe a TexCoord object");
                }
                this.changeFlags |= 4;
                break;
            }
            default: {
                System.out.println("BaseIndexedFaceSet: Unknown field for notifyExternProtoLoaded");
            }
        }
        this.stateManager.addEndOfThisFrameListener(this);
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 20: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Convex", this);
                }
                this.vfConvex = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 19: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("creaseAngle", this);
                }
                if (f < 0.0f) {
                    throw new InvalidFieldValueException("CreaseAngle must be [0,inf)");
                }
                this.vfCreaseAngle = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        boolean bl = false;
        switch (n) {
            case 1: {
                if (vRMLNodeType == null) {
                    this.pCoord = null;
                    if (this.vfCoord != null) {
                        this.vfCoord.removeComponentListener(this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pCoord = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pCoord.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                        this.pCoord = null;
                        throw new InvalidFieldValueException("Proto does not describe a Coord object");
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                    throw new InvalidFieldValueException("Node does not describe a Coord object");
                }
                this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
                if (this.vfCoord != null) {
                    this.vfCoord.addComponentListener(this);
                }
                this.changeFlags |= 1;
                bl = true;
                break;
            }
            case 3: {
                if (vRMLNodeType == null) {
                    this.pNormal = null;
                    if (this.vfNormal != null) {
                        this.vfNormal.removeComponentListener(this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pNormal = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pNormal.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLNormalNodeType)) {
                        this.pNormal = null;
                        throw new InvalidFieldValueException("Proto does not describe a Normal object");
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLNormalNodeType)) {
                    System.out.println("node: " + vRMLNodeType2);
                    throw new InvalidFieldValueException("Node does not describe a Normal object");
                }
                this.vfNormal = (VRMLNormalNodeType)vRMLNodeType2;
                if (this.vfNormal != null) {
                    this.vfNormal.addComponentListener(this);
                }
                this.changeFlags |= 2;
                bl = true;
                break;
            }
            case 2: {
                if (vRMLNodeType == null) {
                    this.pColor = null;
                    if (this.vfColor != null) {
                        this.vfColor.removeComponentListener(this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pColor = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pColor.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                        this.pColor = null;
                        throw new InvalidFieldValueException("Proto does not describe a Color object");
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                    throw new InvalidFieldValueException("Node does not describe a Color object");
                }
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor != null) {
                    this.vfColor.addComponentListener(this);
                    if (!this.localColors) {
                        this.fireLocalColorsChanged(true);
                    }
                    this.localColors = true;
                } else {
                    if (this.localColors) {
                        this.fireLocalColorsChanged(false);
                    }
                    this.localColors = false;
                }
                this.changeFlags |= 8;
                bl = true;
                break;
            }
            case 4: {
                if (vRMLNodeType == null) {
                    this.pTexCoord = null;
                    if (this.vfTexCoord != null) {
                        this.vfTexCoord.removeComponentListener(this);
                    }
                } else if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pTexCoord = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pTexCoord.getImplementationNode();
                    if (!(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                        this.pTexCoord = null;
                        throw new InvalidFieldValueException("Proto does not describe a TexCoord object");
                    }
                } else if (!(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                    throw new InvalidFieldValueException("Node does not describe a TexCoord object");
                }
                this.vfTexCoord = (VRMLTextureCoordinateNodeType)vRMLNodeType2;
                if (this.vfTexCoord != null) {
                    this.vfTexCoord.addComponentListener(this);
                }
                this.changeFlags |= 4;
                bl = true;
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        if (!this.inSetup && bl) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[21];
        fieldMap = new HashMap(63);
        BaseIndexedFaceSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseIndexedFaceSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseIndexedFaceSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseIndexedFaceSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseIndexedFaceSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseIndexedFaceSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseIndexedFaceSet.fieldDecl[20] = new VRMLFieldDeclaration(2, "SFBool", "convex");
        BaseIndexedFaceSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseIndexedFaceSet.fieldDecl[19] = new VRMLFieldDeclaration(2, "SFFloat", "creaseAngle");
        BaseIndexedFaceSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseIndexedFaceSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseIndexedFaceSet.fieldDecl[18] = new VRMLFieldDeclaration(1, "MFInt32", "set_normalIndex");
        BaseIndexedFaceSet.fieldDecl[14] = new VRMLFieldDeclaration(1, "MFInt32", "set_coordIndex");
        BaseIndexedFaceSet.fieldDecl[12] = new VRMLFieldDeclaration(1, "MFInt32", "set_colorIndex");
        BaseIndexedFaceSet.fieldDecl[16] = new VRMLFieldDeclaration(1, "MFInt32", "set_texCoordIndex");
        BaseIndexedFaceSet.fieldDecl[17] = new VRMLFieldDeclaration(2, "MFInt32", "normalIndex");
        BaseIndexedFaceSet.fieldDecl[13] = new VRMLFieldDeclaration(2, "MFInt32", "coordIndex");
        BaseIndexedFaceSet.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFInt32", "colorIndex");
        BaseIndexedFaceSet.fieldDecl[15] = new VRMLFieldDeclaration(2, "MFInt32", "texCoordIndex");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("convex", new Integer(20));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("creaseAngle", new Integer(19));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
        fieldMap.put("normalIndex", new Integer(17));
        fieldMap.put("set_normalIndex", new Integer(18));
        fieldMap.put("coordIndex", new Integer(13));
        fieldMap.put("set_coordIndex", new Integer(14));
        fieldMap.put("colorIndex", new Integer(11));
        fieldMap.put("set_colorIndex", new Integer(12));
        fieldMap.put("texCoordIndex", new Integer(15));
        fieldMap.put("set_texCoordIndex", new Integer(16));
    }
}

