
BEGIN {
  unless ($ENV{AUTHOR_TESTING}) {
    require Test::More;
    Test::More::plan(skip_all => 'these tests are for testing by the author');
  }
}

use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::EOL 0.18

use Test::More 0.88;
use Test::EOL;

my @files = (
    'bin/parcimonie',
    'bin/parcimonie-applet',
    'bin/parcimonie-torified-gpg',
    'lib/App/Parcimonie.pm',
    'lib/App/Parcimonie/Applet.pm',
    'lib/App/Parcimonie/DBus/Object.pm',
    'lib/App/Parcimonie/Daemon.pm',
    'lib/App/Parcimonie/GnuPG/Interface.pm',
    'lib/App/Parcimonie/Role/HasCodeset.pm',
    'lib/App/Parcimonie/Role/HasEncoding.pm',
    't/00-load_all.t',
    't/05-init-keyring.t',
    't/30-pickRandomItems.t',
    't/31-gpgPublicKeys.t',
    't/32-keyserver_defined_on_command_line.t',
    't/33-checkGpgHasDefinedKeyserver.t',
    't/90-tryRecvKey.t.disabled',
    't/91-gpgRecvKeys.t',
    't/author-critic.t',
    't/author-eol.t',
    't/author-no-tabs.t',
    't/author-pod-syntax.t',
    't/data/gnupg_homedir/gpg.conf',
    't/data/gnupg_homedir_without_defined_keyserver/gpg.conf',
    't/data/gnupg_homedir_without_gpgconf/placeholder',
    't/data/pubkeys/intrigeri.asc',
    't/data/pubkeys/rms.asc'
);

eol_unix_ok($_, { trailing_whitespace => 1 }) foreach @files;
done_testing;
