/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef PATCHAGEPORT_H
#define PATCHAGEPORT_H

#include <string>
#include <list>
#include <alsa/asoundlib.h>
#include "canvas/Port.h"

using namespace PatchBay;
using std::string; using std::list;

enum PortType { JACK, ALSA };


/** A Port on a PatchageModule
 *
 * \ingroup OmGtk
 */
class PatchagePort : public PatchBay::Port
{
public:
	PatchagePort(PatchBay::Module* module, PortType type, const string& name, bool is_input, int color)
	: Port(module, name, is_input, color),
	  m_type(type)
	{
		m_alsa_addr.client = '\0';
		m_alsa_addr.port = '\0';
	}

	virtual ~PatchagePort() {}

	// only used for alsa ports.  yeah, ew.  whatever.
	void                  alsa_addr(const snd_seq_addr_t addr) { m_alsa_addr = addr; }
	const snd_seq_addr_t* alsa_addr() const                    { return &m_alsa_addr; }

	PortType type() { return m_type; }

private:
	snd_seq_addr_t m_alsa_addr;
	PortType             m_type;
};


#endif // PATCHAGEPORT_H
