#ifndef __PAXCTL_H
#define __PAXCTL_H

#include <elf.h>

#define PAXCTL_VERSION "0.2"

struct pax_state;

struct elf_ops {
  void * (* const map_phdr)(const int, const struct pax_state * const);
  void (* const modify_phdr)(unsigned char * const, const struct pax_state * const);
  union {
    Elf32_Off _32;
    Elf64_Off _64;
  } phoff;
  union {
    Elf32_Half _32;
    Elf64_Half _64;
  } phentsize;
  union {
    Elf32_Half _32;
    Elf64_Half _64;
  } phnum;
};

struct pax_state {
  char ** argv;
  unsigned int flags_on;
  unsigned int flags_off;
  unsigned int files;
  unsigned int quiet:1;
  unsigned int shortonly:1;
  unsigned int view:1;
  struct elf_ops * ops;
};

#ifndef PT_PAX_FLAGS

#define PT_PAX_FLAGS	0x65041580

#define PF_PAGEEXEC	(1 << 4)	/* Enable  PAGEEXEC */
#define PF_NOPAGEEXEC	(1 << 5)	/* Disable PAGEEXEC */
#define PF_SEGMEXEC	(1 << 6)	/* Enable  SEGMEXEC */
#define PF_NOSEGMEXEC	(1 << 7)	/* Disable SEGMEXEC */
#define PF_MPROTECT	(1 << 8)	/* Enable  MPROTECT */
#define PF_NOMPROTECT	(1 << 9)	/* Disable MPROTECT */
#define PF_RANDEXEC	(1 << 10)	/* Enable  RANDEXEC */
#define PF_NORANDEXEC	(1 << 11)	/* Disable RANDEXEC */
#define PF_EMUTRAMP	(1 << 12)	/* Enable  EMUTRAMP */
#define PF_NOEMUTRAMP	(1 << 13)	/* Disable EMUTRAMP */
#define PF_RANDMMAP	(1 << 14)	/* Enable  RANDMMAP */
#define PF_NORANDMMAP	(1 << 15)	/* Disable RANDMMAP */

#endif

#define PF_PAX_MASK	0xFFF0U

#endif
