//SCAD

module line_segment_r(length, width, thickness, x, y, a, bd, c1, c2) {
	translate([x,y,0]) rotate ([0,0,a]) union() {
		if (bd) {cube ([length, width,thickness],true);}
		if (c2) {translate([length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
		if (c1) { translate([-length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
	}
}

module line_segment(length, width, thickness, x, y, a) {
	translate([x,y,0]) rotate ([0,0,a]) {
		cube ([length, width,thickness],true);
	}
}

// START_OF_LAYER: plated-drill
layer_pdrill_list=[
];


// END_OF_LAYER layer_pdrill

// START_OF_LAYER: topsilk
module layer_topsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(2.540000,0.254000,0.037500,1.270000,-3.810000,90.000000,1,1,1);
	line_segment_r(10.160000,0.254000,0.037500,6.350000,-5.080000,0.000000,1,1,1);
	line_segment_r(2.540000,0.254000,0.037500,11.430000,-3.810000,-90.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,3.175000,-2.540000,180.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,9.525000,-2.540000,180.000000,1,1,1);
	line_segment_r(0.110793,0.254000,0.037500,5.082417,2.484656,92.500130,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.092063,2.374389,97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.111284,2.265383,102.499977,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.139932,2.158467,107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.177790,2.054455,112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.224568,1.954137,117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.279912,1.858279,122.499947,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.343400,1.767609,127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.414549,1.682817,132.499451,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.492817,1.604548,137.500168,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.577609,1.533400,142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.668279,1.469913,147.500046,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.764137,1.414569,152.499878,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.864455,1.367790,157.499954,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.968468,1.329932,162.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.075384,1.301284,167.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.184390,1.282063,172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.294656,1.272416,177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.405344,1.272416,-177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.515611,1.282063,-172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.624617,1.301284,-167.500031,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.731533,1.329932,-162.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.835546,1.367790,-157.499756,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.935863,1.414569,-152.499878,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.031721,1.469913,-147.500046,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.122391,1.533400,-142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.207182,1.604548,-137.499817,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.285450,1.682817,-132.499832,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.356599,1.767609,-127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.420087,1.858279,-122.499947,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.475431,1.954137,-117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.522211,2.054455,-112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.560068,2.158467,-107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.588716,2.265383,-102.499977,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.607936,2.374389,-97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.617583,2.484656,-92.500130,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,2.540000,-1.714500,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.603500,-2.222500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,2.794000,-2.286000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.984500,-2.222500,-135.000000,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,3.048000,-1.714500,90.000000,1,1,1);
	line_segment_r(0.287368,0.177800,0.037500,3.454401,-1.371600,-135.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,3.556001,-1.778000,90.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,3.543301,-2.286000,180.000000,1,1,1);
}
}


// END_OF_LAYER layer_topsilk

// START_OF_LAYER: bottomsilk
module layer_bottomsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(2.540000,0.254000,0.037500,1.270000,-8.890000,-90.000000,1,1,1);
	line_segment_r(10.160000,0.254000,0.037500,6.350000,-7.620000,0.000000,1,1,1);
	line_segment_r(2.540000,0.254000,0.037500,11.430000,-8.890000,90.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,3.175000,-10.160000,180.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,9.525000,-10.160000,180.000000,1,1,1);
	line_segment_r(0.110793,0.254000,0.037500,7.617583,10.215344,-87.499870,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.607936,10.325610,-82.500191,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.588716,10.434616,-77.500023,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.560068,10.541533,-72.500175,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.522211,10.645546,-67.499756,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.475431,10.745862,-62.499874,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.420087,10.841721,-57.500053,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.356599,10.932391,-52.499798,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.285451,11.017183,-47.500546,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.207183,11.095451,-42.499454,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.122391,11.166600,-37.500202,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.031721,11.230088,-32.499947,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.935863,11.285432,-27.500126,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.835546,11.332210,-22.500246,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.731533,11.370068,-17.499821,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.624617,11.398716,-12.499976,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.515611,11.417936,-7.499811,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.405344,11.427584,-2.500133,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.294656,11.427584,2.500133,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.184389,11.417936,7.499743,1,0,1);
	line_segment_r(0.110792,0.254000,0.037500,6.075383,11.398716,12.500089,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.968467,11.370068,17.499821,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.864454,11.332210,22.500246,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.764137,11.285432,27.500126,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.668279,11.230088,32.499947,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.577609,11.166600,37.500202,1,0,1);
	line_segment_r(0.110792,0.254000,0.037500,5.492817,11.095451,42.499805,1,0,1);
	line_segment_r(0.110795,0.254000,0.037500,5.414549,11.017183,47.499783,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.343400,10.932391,52.500210,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.279912,10.841721,57.500053,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.224568,10.745863,62.499638,1,0,1);
	line_segment_r(0.110795,0.254000,0.037500,5.177790,10.645546,67.500153,1,0,1);
	line_segment_r(0.110792,0.254000,0.037500,5.139932,10.541533,72.499870,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.111284,10.434617,77.500137,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.092063,10.325610,82.500191,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.082417,10.215344,87.499870,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,2.540000,-10.985500,-90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.603500,-10.477500,-135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,2.794000,-10.414000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.984500,-10.477500,135.000000,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,3.048000,-10.985500,-90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,3.416301,-11.366500,135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,3.670301,-11.430000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,3.924301,-11.366500,-135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,3.987801,-11.176000,-90.000000,1,1,1);
	line_segment_r(0.898026,0.177800,0.037500,3.670301,-10.731500,135.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,3.670301,-10.414000,180.000000,1,1,1);
}
}


// END_OF_LAYER layer_bottomsilk

module board_outline () {
	polygon([[0,0],[0,-12.700000],[12.700000,-12.700000],[12.700000,0]],
[[0,1,2,3]]);
}

module all_holes() {
	plating=0.017500;
	union () {
		for (i = layer_pdrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0]+2*plating, h=1.770000, center=true, $fn=30);
		}
		for (i = layer_udrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0], h=1.770000, center=true, $fn=30);
		}
	}
}

module board_body() {
	translate ([0, 0, -0.800000]) linear_extrude(height=1.600000) board_outline();}

/***************************************************/
/*                                                 */
/* Components                                      */
/*                                                 */
/***************************************************/
module all_components() {
}

/***************************************************/
/*                                                 */
/* Final board assembly                            */
/* Here is the complete board built from           */
/* pre-generated modules                           */
/*                                                 */
/***************************************************/
		color ([1, 1, 1])
			layer_topsilk_body(0.818750);

		color ([1, 1, 1])
			layer_bottomsilk_body(-0.818750);

		color ([0.44, 0.44, 0])
			difference() {
				board_body();
				all_holes();
			}

		all_components();
// END_OF_BOARD
