//SCAD

module line_segment_r(length, width, thickness, x, y, a, bd, c1, c2) {
	translate([x,y,0]) rotate ([0,0,a]) union() {
		if (bd) {cube ([length, width,thickness],true);}
		if (c2) {translate([length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
		if (c1) { translate([-length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
	}
}

module line_segment(length, width, thickness, x, y, a) {
	translate([x,y,0]) rotate ([0,0,a]) {
		cube ([length, width,thickness],true);
	}
}

// START_OF_LAYER: plated-drill
layer_pdrill_list=[
];


// END_OF_LAYER layer_pdrill

// START_OF_LAYER: topsilk
module layer_topsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(5.080000,0.254000,0.037500,1.270000,-5.715000,90.000000,1,1,1);
	line_segment_r(10.160000,0.254000,0.037500,6.350000,-8.255000,0.000000,1,1,1);
	line_segment_r(5.080000,0.254000,0.037500,11.430000,-5.715000,-90.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,3.175000,-3.175000,180.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,9.525000,-3.175000,180.000000,1,1,1);
	line_segment_r(0.110793,0.254000,0.037500,5.082417,3.119656,92.500130,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.092063,3.009389,97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.111284,2.900383,102.499977,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.139932,2.793467,107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.177790,2.689455,112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.224568,2.589138,117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.279912,2.493279,122.499947,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.343400,2.402609,127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.414549,2.317817,132.499451,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.492817,2.239548,137.500168,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.577609,2.168400,142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.668279,2.104913,147.500046,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.764137,2.049568,152.499878,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.864455,2.002789,157.499954,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.968468,1.964932,162.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.075384,1.936284,167.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.184390,1.917063,172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.294656,1.907416,177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.405344,1.907416,-177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.515611,1.917063,-172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.624617,1.936284,-167.500031,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.731533,1.964932,-162.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.835546,2.002789,-157.499756,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.935863,2.049568,-152.499878,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.031721,2.104913,-147.500046,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.122391,2.168400,-142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.207182,2.239548,-137.499817,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.285450,2.317817,-132.499832,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.356599,2.402609,-127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.420087,2.493279,-122.499947,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.475431,2.589138,-117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.522211,2.689455,-112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,7.560068,2.793467,-107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.588716,2.900383,-102.499977,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.607936,3.009389,-97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,7.617583,3.119656,-92.500130,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,2.540000,-2.349500,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.603500,-2.857500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,2.794000,-2.921000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.984500,-2.857500,-135.000000,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,3.048000,-2.349500,90.000000,1,1,1);
	line_segment_r(0.287368,0.177800,0.037500,3.454401,-2.006600,-135.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,3.556001,-2.413000,90.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,3.543301,-2.921000,180.000000,1,1,1);
}
}


// END_OF_LAYER layer_topsilk

// START_OF_LAYER: bottomsilk
module layer_bottomsilk_body (offset) {
translate ([0, 0, offset]) union () {
}
}


// END_OF_LAYER layer_bottomsilk

module board_outline () {
	polygon([[0,0],[0,-12.700000],[12.700000,-12.700000],[12.700000,0]],
[[0,1,2,3]]);
}

module all_holes() {
	plating=0.017500;
	union () {
		for (i = layer_pdrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0]+2*plating, h=1.770000, center=true, $fn=30);
		}
		for (i = layer_udrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0], h=1.770000, center=true, $fn=30);
		}
	}
}

module board_body() {
	translate ([0, 0, -0.800000]) linear_extrude(height=1.600000) board_outline();}

/***************************************************/
/*                                                 */
/* Components                                      */
/*                                                 */
/***************************************************/
module all_components() {
}

/***************************************************/
/*                                                 */
/* Final board assembly                            */
/* Here is the complete board built from           */
/* pre-generated modules                           */
/*                                                 */
/***************************************************/
		color ([1, 1, 1])
			layer_topsilk_body(0.818750);

		color ([1, 1, 1])
			layer_bottomsilk_body(-0.818750);

		color ([0.44, 0.44, 0])
			difference() {
				board_body();
				all_holes();
			}

		all_components();
// END_OF_BOARD
