/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     NUMBER = 258,
     CHAR_CONST = 259,
     FLOAT = 260,
     STRING = 261,
     T_PCB = 262,
     T_LAYER = 263,
     T_VIA = 264,
     T_RAT = 265,
     T_LINE = 266,
     T_ARC = 267,
     T_RECTANGLE = 268,
     T_TEXT = 269,
     T_ELEMENTLINE = 270,
     T_ELEMENT = 271,
     T_PIN = 272,
     T_PAD = 273,
     T_GRID = 274,
     T_FLAGS = 275,
     T_SYMBOL = 276,
     T_SYMBOLLINE = 277,
     T_CURSOR = 278,
     T_ELEMENTARC = 279,
     T_MARK = 280,
     T_GROUPS = 281,
     T_STYLES = 282,
     T_POLYGON = 283,
     T_NETLIST = 284,
     T_NET = 285,
     T_CONN = 286,
     T_THERMAL = 287,
     T_DRC = 288
   };
#endif
#define NUMBER 258
#define CHAR_CONST 259
#define FLOAT 260
#define STRING 261
#define T_PCB 262
#define T_LAYER 263
#define T_VIA 264
#define T_RAT 265
#define T_LINE 266
#define T_ARC 267
#define T_RECTANGLE 268
#define T_TEXT 269
#define T_ELEMENTLINE 270
#define T_ELEMENT 271
#define T_PIN 272
#define T_PAD 273
#define T_GRID 274
#define T_FLAGS 275
#define T_SYMBOL 276
#define T_SYMBOLLINE 277
#define T_CURSOR 278
#define T_ELEMENTARC 279
#define T_MARK 280
#define T_GROUPS 281
#define T_STYLES 282
#define T_POLYGON 283
#define T_NETLIST 284
#define T_NET 285
#define T_CONN 286
#define T_THERMAL 287
#define T_DRC 288




/* Copy the first part of user declarations.  */
#line 3 "parse_y.y"

/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */

/* grammar to parse ASCII input of PCB description
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define GRIDFIT(x,g) (int)(0.5 + (int)(((x)+(g)/2.)/(g))*(g))
#include "global.h"
#include "create.h"
#include "data.h"
#include "error.h"
#include "mymem.h"
#include "misc.h"
#include "parse_l.h"
#include "remove.h"
#include "strflags.h"

#ifdef HAVE_LIBDMALLOC
# include <dmalloc.h> /* see http://dmalloc.com */
#endif

RCSID("$Id: parse_y.y,v 1.16 2005/03/21 02:46:23 djdelorie Exp $");

static	LayerTypePtr	Layer;
static	PolygonTypePtr	Polygon;
static	SymbolTypePtr	Symbol;
static	int		pin_num;
static	LibraryMenuTypePtr	Menu;
static	Boolean			LayerFlag[MAX_LAYER + 2];

extern	char			*yytext;		/* defined by LEX */
extern	PCBTypePtr		yyPCB;
extern	DataTypePtr		yyData;
extern	ElementTypePtr	yyElement;
extern	FontTypePtr		yyFont;
extern	int				yylineno;		/* linenumber */
extern	char			*yyfilename;	/* in this file */

int yyerror(char *s);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 74 "parse_y.y"
typedef union YYSTYPE {
	int		number;
	float		floating;
	char		*string;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 217 "parse_y.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 229 "parse_y.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  9
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   606

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  38
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  94
/* YYNRULES -- Number of rules. */
#define YYNRULES  175
/* YYNRULES -- Number of states. */
#define YYNSTATES  574

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   288

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      34,    35,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    36,     2,    37,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    12,    25,    26,
      29,    31,    32,    33,    36,    41,    48,    55,    57,    59,
      61,    63,    70,    78,    86,    94,   101,   108,   115,   116,
     117,   122,   124,   126,   127,   134,   135,   143,   148,   149,
     154,   155,   160,   165,   166,   168,   169,   171,   174,   176,
     178,   180,   181,   184,   186,   188,   190,   192,   194,   196,
     208,   220,   231,   241,   250,   261,   272,   273,   283,   285,
     286,   288,   291,   293,   295,   297,   299,   301,   303,   312,
     314,   316,   318,   319,   328,   339,   350,   360,   373,   386,
     398,   407,   417,   427,   429,   432,   437,   442,   443,   445,
     447,   449,   451,   453,   454,   467,   468,   484,   485,   502,
     503,   522,   523,   542,   544,   547,   549,   551,   553,   555,
     557,   566,   575,   586,   597,   603,   609,   611,   614,   616,
     618,   620,   622,   631,   640,   651,   662,   675,   688,   699,
     709,   718,   732,   746,   758,   769,   771,   773,   775,   778,
     779,   789,   790,   800,   802,   804,   806,   809,   811,   813,
     814,   823,   832,   834,   835,   842,   844,   845,   847,   850,
     851,   861,   863,   864,   866,   869
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
      39,     0,    -1,    40,    -1,    42,    -1,    45,    -1,     1,
      -1,    -1,    41,    47,    48,    53,    54,    55,    58,    59,
      60,    44,    61,   123,    -1,    -1,    43,    61,    -1,    45,
      -1,    -1,    -1,    46,   114,    -1,     7,    34,     6,    35,
      -1,     7,    34,     6,     3,     3,    35,    -1,     7,    36,
       6,     3,     3,    37,    -1,    49,    -1,    50,    -1,    51,
      -1,    52,    -1,    19,    34,     3,     3,     3,    35,    -1,
      19,    34,     3,     3,     3,     3,    35,    -1,    19,    34,
       5,     3,     3,     3,    35,    -1,    19,    36,     5,     3,
       3,     3,    37,    -1,    23,    34,     3,     3,     3,    35,
      -1,    23,    36,     3,     3,     3,    37,    -1,    23,    36,
       3,     3,     5,    37,    -1,    -1,    -1,    32,    36,     5,
      37,    -1,    56,    -1,    57,    -1,    -1,    33,    36,     3,
       3,     3,    37,    -1,    -1,    33,    36,     3,     3,     3,
       3,    37,    -1,    20,    34,     3,    35,    -1,    -1,    26,
      34,     6,    35,    -1,    -1,    27,    34,     6,    35,    -1,
      27,    36,     6,    37,    -1,    -1,    62,    -1,    -1,    63,
      -1,    62,    63,    -1,    65,    -1,    71,    -1,    72,    -1,
      -1,    64,    89,    -1,     1,    -1,    66,    -1,    67,    -1,
      68,    -1,    69,    -1,    70,    -1,     9,    36,     3,     3,
       3,     3,     3,     3,     6,   113,    37,    -1,     9,    34,
       3,     3,     3,     3,     3,     3,     6,     3,    35,    -1,
       9,    34,     3,     3,     3,     3,     3,     6,     3,    35,
      -1,     9,    34,     3,     3,     3,     3,     6,     3,    35,
      -1,     9,    34,     3,     3,     3,     6,     3,    35,    -1,
      10,    36,     3,     3,     3,     3,     3,     3,   113,    37,
      -1,    10,    34,     3,     3,     3,     3,     3,     3,     3,
      35,    -1,    -1,     8,    34,     3,     6,    35,    34,    73,
      74,    35,    -1,    75,    -1,    -1,    76,    -1,    75,    76,
      -1,    78,    -1,    79,    -1,    80,    -1,    81,    -1,    82,
      -1,    83,    -1,    13,    34,     3,     3,     3,     3,     3,
      35,    -1,    86,    -1,    85,    -1,    84,    -1,    -1,    28,
      34,   113,    35,    34,    77,    87,    35,    -1,    11,    36,
       3,     3,     3,     3,     3,     3,   113,    37,    -1,    11,
      34,     3,     3,     3,     3,     3,     3,     3,    35,    -1,
      11,    34,     3,     3,     3,     3,     3,     3,    35,    -1,
      12,    36,     3,     3,     3,     3,     3,     3,     3,     3,
     113,    37,    -1,    12,    34,     3,     3,     3,     3,     3,
       3,     3,     3,     3,    35,    -1,    12,    34,     3,     3,
       3,     3,     3,     3,     3,     3,    35,    -1,    14,    34,
       3,     3,     3,     6,     3,    35,    -1,    14,    34,     3,
       3,     3,     3,     6,     3,    35,    -1,    14,    36,     3,
       3,     3,     3,     6,   113,    37,    -1,    88,    -1,    87,
      88,    -1,    34,     3,     3,    35,    -1,    36,     3,     3,
      37,    -1,    -1,    90,    -1,    92,    -1,    94,    -1,    96,
      -1,    98,    -1,    -1,    16,    34,     6,     6,     3,     3,
       3,    35,    34,    91,   100,    35,    -1,    -1,    16,    34,
       3,     6,     6,     3,     3,     3,     3,     3,    35,    34,
      93,   100,    35,    -1,    -1,    16,    34,     3,     6,     6,
       6,     3,     3,     3,     3,     3,    35,    34,    95,   100,
      35,    -1,    -1,    16,    34,     3,     6,     6,     6,     3,
       3,     3,     3,     3,     3,     3,    35,    34,    97,   102,
      35,    -1,    -1,    16,    36,   113,     6,     6,     6,     3,
       3,     3,     3,     3,     3,   113,    37,    34,    99,   102,
      35,    -1,   101,    -1,   100,   101,    -1,   106,    -1,   107,
      -1,   108,    -1,   111,    -1,   112,    -1,    15,    36,     3,
       3,     3,     3,     3,    37,    -1,    15,    34,     3,     3,
       3,     3,     3,    35,    -1,    24,    36,     3,     3,     3,
       3,     3,     3,     3,    37,    -1,    24,    34,     3,     3,
       3,     3,     3,     3,     3,    35,    -1,    25,    36,     3,
       3,    37,    -1,    25,    34,     3,     3,    35,    -1,   103,
      -1,   102,   103,    -1,   105,    -1,   104,    -1,   110,    -1,
     109,    -1,    15,    36,     3,     3,     3,     3,     3,    37,
      -1,    15,    34,     3,     3,     3,     3,     3,    35,    -1,
      24,    36,     3,     3,     3,     3,     3,     3,     3,    37,
      -1,    24,    34,     3,     3,     3,     3,     3,     3,     3,
      35,    -1,    17,    36,     3,     3,     3,     3,     3,     3,
       6,     6,   113,    37,    -1,    17,    34,     3,     3,     3,
       3,     3,     3,     6,     6,     3,    35,    -1,    17,    34,
       3,     3,     3,     3,     6,     6,     3,    35,    -1,    17,
      34,     3,     3,     3,     3,     6,     3,    35,    -1,    17,
      34,     3,     3,     3,     6,     3,    35,    -1,    18,    36,
       3,     3,     3,     3,     3,     3,     3,     6,     6,   113,
      37,    -1,    18,    34,     3,     3,     3,     3,     3,     3,
       3,     6,     6,     3,    35,    -1,    18,    34,     3,     3,
       3,     3,     3,     6,     6,     3,    35,    -1,    18,    34,
       3,     3,     3,     3,     3,     6,     3,    35,    -1,     3,
      -1,     6,    -1,   115,    -1,   114,   115,    -1,    -1,    21,
      36,   118,     3,    37,    34,   116,   119,    35,    -1,    -1,
      21,    34,   118,     3,    35,    34,   117,   119,    35,    -1,
       3,    -1,     4,    -1,   120,    -1,   119,   120,    -1,   121,
      -1,   122,    -1,    -1,    22,    34,     3,     3,     3,     3,
       3,    35,    -1,    22,    36,     3,     3,     3,     3,     3,
      37,    -1,   124,    -1,    -1,    29,    34,    35,    34,   125,
      35,    -1,   126,    -1,    -1,   127,    -1,   126,   127,    -1,
      -1,    30,    34,     6,     6,    35,    34,   128,   129,    35,
      -1,   130,    -1,    -1,   131,    -1,   130,   131,    -1,    31,
      34,     6,    35,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,    94,    94,    95,    96,    97,   101,   101,   131,   131,
     149,   150,   155,   155,   176,   182,   188,   197,   198,   199,
     200,   203,   211,   224,   236,   249,   255,   261,   267,   270,
     272,   279,   280,   283,   285,   293,   295,   305,   309,   313,
     321,   324,   332,   340,   344,   345,   349,   350,   354,   355,
     356,   358,   358,   365,   369,   370,   371,   372,   373,   378,
     388,   399,   409,   419,   435,   440,   450,   449,   471,   472,
     476,   477,   481,   482,   483,   484,   485,   486,   488,   493,
     494,   495,   498,   497,   519,   527,   535,   546,   554,   562,
     571,   581,   597,   613,   614,   619,   623,   627,   631,   632,
     633,   634,   635,   643,   642,   661,   660,   679,   678,   699,
     697,   720,   718,   736,   737,   741,   742,   743,   744,   745,
     747,   752,   757,   762,   767,   772,   780,   781,   785,   786,
     787,   788,   790,   796,   803,   808,   818,   830,   842,   854,
     870,   890,   904,   917,   928,   940,   941,   945,   946,   951,
     950,   968,   967,   987,   988,   992,   993,   997,   998,   999,
    1004,  1011,  1017,  1018,  1022,  1027,  1028,  1032,  1033,  1039,
    1038,  1048,  1049,  1053,  1054,  1058
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NUMBER", "CHAR_CONST", "FLOAT", "STRING", 
  "T_PCB", "T_LAYER", "T_VIA", "T_RAT", "T_LINE", "T_ARC", "T_RECTANGLE", 
  "T_TEXT", "T_ELEMENTLINE", "T_ELEMENT", "T_PIN", "T_PAD", "T_GRID", 
  "T_FLAGS", "T_SYMBOL", "T_SYMBOLLINE", "T_CURSOR", "T_ELEMENTARC", 
  "T_MARK", "T_GROUPS", "T_STYLES", "T_POLYGON", "T_NETLIST", "T_NET", 
  "T_CONN", "T_THERMAL", "T_DRC", "'('", "')'", "'['", "']'", "$accept", 
  "parse", "parsepcb", "@1", "parsedata", "@2", "pcbfont", "parsefont", 
  "@3", "pcbname", "pcbgrid", "pcbgridold", "pcbgridnew", "pcb2grid", 
  "pcbhigrid", "pcbcursor", "pcbthermal", "pcbdrc", "pcbdrc1", "pcbdrc2", 
  "pcbflags", "pcbgroups", "pcbstyles", "pcbdata", "pcbdefinitions", 
  "pcbdefinition", "@4", "via", "via_hi_format", "via_2.0_format", 
  "via_1.7_format", "via_newformat", "via_oldformat", "rats", "layer", 
  "@5", "layerdata", "layerdefinitions", "layerdefinition", "@6", 
  "line_hi_format", "line_1.7_format", "line_oldformat", "arc_hi_format", 
  "arc_1.7_format", "arc_oldformat", "text_oldformat", "text_newformat", 
  "text_hi_format", "polygonpoints", "polygonpoint", "element", 
  "element_oldformat", "@7", "element_1.3.4_format", "@8", 
  "element_newformat", "@9", "element_1.7_format", "@10", 
  "element_hi_format", "@11", "elementdefinitions", "elementdefinition", 
  "relementdefs", "relementdef", "pin_hi_format", "pin_1.7_format", 
  "pin_1.6.3_format", "pin_newformat", "pin_oldformat", "pad_hi_format", 
  "pad_1.7_format", "pad_newformat", "pad", "flags", "symbols", "symbol", 
  "@12", "@13", "symbolid", "symboldata", "symboldefinitions", 
  "symboldefinition", "hiressymbol", "pcbnetlist", "pcbnetdef", "nets", 
  "netdefs", "net", "@14", "connections", "conndefs", "conn", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    40,    41,    91,    93
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    38,    39,    39,    39,    39,    41,    40,    43,    42,
      44,    44,    46,    45,    47,    47,    47,    48,    48,    48,
      48,    49,    50,    51,    52,    53,    53,    53,    53,    54,
      54,    55,    55,    56,    56,    57,    57,    58,    58,    59,
      59,    60,    60,    60,    61,    61,    62,    62,    63,    63,
      63,    64,    63,    63,    65,    65,    65,    65,    65,    66,
      67,    68,    69,    70,    71,    71,    73,    72,    74,    74,
      75,    75,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    77,    76,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    87,    88,    88,    88,    89,    89,
      89,    89,    89,    91,    90,    93,    92,    95,    94,    97,
      96,    99,    98,   100,   100,   101,   101,   101,   101,   101,
     101,   101,   101,   101,   101,   101,   102,   102,   103,   103,
     103,   103,   103,   103,   103,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   113,   114,   114,   116,
     115,   117,   115,   118,   118,   119,   119,   120,   120,   120,
     121,   122,   123,   123,   124,   125,   125,   126,   126,   128,
     127,   129,   129,   130,   130,   131
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     0,    12,     0,     2,
       1,     0,     0,     2,     4,     6,     6,     1,     1,     1,
       1,     6,     7,     7,     7,     6,     6,     6,     0,     0,
       4,     1,     1,     0,     6,     0,     7,     4,     0,     4,
       0,     4,     4,     0,     1,     0,     1,     2,     1,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     1,    11,
      11,    10,     9,     8,    10,    10,     0,     9,     1,     0,
       1,     2,     1,     1,     1,     1,     1,     1,     8,     1,
       1,     1,     0,     8,    10,    10,     9,    12,    12,    11,
       8,     9,     9,     1,     2,     4,     4,     0,     1,     1,
       1,     1,     1,     0,    12,     0,    15,     0,    16,     0,
      18,     0,    18,     1,     2,     1,     1,     1,     1,     1,
       8,     8,    10,    10,     5,     5,     1,     2,     1,     1,
       1,     1,     8,     8,    10,    10,    12,    12,    10,     9,
       8,    13,    13,    11,    10,     1,     1,     1,     2,     0,
       9,     0,     9,     1,     1,     1,     2,     1,     1,     0,
       8,     8,     1,     0,     6,     1,     0,     1,     2,     0,
       9,     1,     0,     1,     2,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     5,     0,     2,     0,     3,     0,     4,     0,     1,
       0,     0,    53,     0,     0,     0,     9,     0,    46,     0,
      48,    54,    55,    56,    57,    58,    49,    50,     0,    13,
     147,     0,     0,     0,    28,    17,    18,    19,    20,     0,
       0,     0,     0,     0,    47,     0,    52,    98,    99,   100,
     101,   102,     0,     0,   148,     0,     0,     0,     0,     0,
      29,     0,     0,     0,     0,     0,     0,     0,   153,   154,
       0,     0,     0,    14,     0,     0,     0,     0,     0,     0,
       0,    33,     0,     0,     0,     0,     0,     0,     0,   145,
     146,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    38,    31,    32,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    15,    16,     0,     0,
       0,     0,     0,     0,     0,     0,    40,    66,     0,     0,
       0,     0,     0,     0,     0,     0,   151,   149,     0,    21,
       0,     0,     0,     0,     0,    30,     0,     0,     0,    43,
      69,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   159,   159,    22,    23,    24,    25,    26,    27,     0,
       0,     0,     0,    11,     0,     0,     0,     0,     0,     0,
      68,    70,    72,    73,    74,    75,    76,    77,    81,    80,
      79,     0,     0,     0,    63,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   157,   158,     0,     0,    37,
       0,     0,     0,     0,    10,     0,     0,     0,     0,     0,
       0,     0,     0,    67,    71,     0,     0,    62,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   152,   156,   150,
       0,    34,    39,     0,     0,   163,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    61,     0,    65,    64,     0,
       0,   103,     0,     0,     0,    36,    41,    42,     0,     7,
     162,     0,     0,     0,     0,     0,     0,     0,     0,    60,
      59,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    82,     0,     0,     0,     0,
       0,     0,     0,     0,   113,   115,   116,   117,   118,   119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    97,   105,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   104,   114,     0,     0,     0,   166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    93,     0,     0,   107,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   165,   167,
       0,     0,     0,     0,    78,     0,    90,     0,     0,     0,
      83,    94,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   160,   161,     0,   164,   168,     0,
      86,     0,     0,     0,    91,    92,     0,     0,   106,   109,
       0,     0,     0,     0,     0,     0,     0,   125,   124,   111,
       0,    85,    84,     0,     0,    95,    96,     0,   108,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    89,
       0,     0,     0,     0,     0,     0,   126,   129,   128,   131,
     130,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      88,    87,     0,     0,     0,     0,     0,     0,     0,     0,
     110,   127,   121,   120,     0,     0,   140,     0,     0,     0,
     112,   169,     0,     0,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   138,   144,     0,   123,   122,
       0,     0,   171,   173,     0,     0,     0,     0,     0,     0,
       0,     0,   143,     0,   170,   174,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   175,   133,   132,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   135,   134,     0,     0,     0,     0,   137,   136,
       0,     0,   142,   141
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     2,     3,     4,     5,     6,   213,     7,     8,    11,
      34,    35,    36,    37,    38,    60,    81,   103,   104,   105,
     126,   149,   173,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,   150,   179,   180,   181,   322,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   350,
     351,    46,    47,   283,    48,   352,    49,   384,    50,   427,
      51,   436,   303,   304,   445,   446,   447,   448,   305,   306,
     307,   449,   450,   308,   309,    91,    29,    30,   162,   161,
      70,   203,   204,   205,   206,   269,   270,   367,   368,   369,
     496,   511,   512,   513
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -426
static const short yypact[] =
{
      43,  -426,    10,  -426,     8,  -426,    87,  -426,    24,  -426,
      -4,    39,  -426,    42,   101,   102,  -426,    13,  -426,    70,
    -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,   107,    24,
    -426,    86,    92,   108,    59,  -426,  -426,  -426,  -426,   118,
     137,   156,   169,   174,  -426,   111,  -426,  -426,  -426,  -426,
    -426,  -426,   184,   184,  -426,     0,   180,   143,   105,   115,
      73,   147,   182,   186,   187,   188,    51,    67,  -426,  -426,
     189,   190,   191,  -426,   192,   193,   194,   195,   196,   197,
     165,   170,   167,   201,   202,   203,   204,   205,   206,  -426,
    -426,   207,   173,   172,   175,   177,   212,   213,   214,   215,
     216,   217,   185,   200,  -426,  -426,   198,    96,   220,   221,
     222,   223,   225,   224,   199,   208,  -426,  -426,     2,   228,
     231,   232,   149,   209,   233,   210,   211,  -426,   106,   235,
     236,   237,   238,   113,   240,   239,  -426,  -426,   218,  -426,
     219,   226,   227,   229,   230,  -426,   244,   245,   234,   242,
      49,   117,   246,   241,   247,   248,   249,   252,   253,   254,
     255,   243,   243,  -426,  -426,  -426,  -426,  -426,  -426,   256,
     250,   258,   121,   251,   122,   126,   257,   127,   259,   260,
      49,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,
    -426,   264,   268,   261,  -426,   267,   271,    67,   272,   274,
     262,   275,   130,   -18,  -426,  -426,  -426,   -11,    -1,  -426,
     263,   273,   276,    18,  -426,   277,   278,   280,   281,   283,
     284,   285,    67,  -426,  -426,   286,   265,  -426,    67,   266,
     269,   287,   289,   270,   291,   296,   299,  -426,  -426,  -426,
     279,  -426,  -426,   282,   288,   290,   300,   302,   304,   305,
     306,   307,   308,   292,   293,  -426,   294,  -426,  -426,   309,
     310,  -426,   311,   312,   315,  -426,  -426,  -426,   295,  -426,
    -426,   317,   318,   319,   320,   321,   323,   327,   298,  -426,
    -426,   301,   330,    89,   331,   332,   334,   303,   336,   337,
     338,   339,   340,   119,   341,  -426,   313,     3,   131,   314,
     316,   134,   135,    31,  -426,  -426,  -426,  -426,  -426,  -426,
     342,   343,   346,   322,   348,   349,   350,   351,   352,   353,
     354,   355,   139,  -426,   357,   324,   360,   361,   362,   363,
     364,   365,   366,   368,  -426,  -426,    67,   369,   370,   344,
     372,   373,   374,   375,   345,   376,   347,    67,   378,   380,
      98,  -426,    89,   356,  -426,   381,   382,   383,   384,   385,
     386,   387,   389,   358,   359,   367,   371,   377,   344,  -426,
       4,    67,   390,   393,  -426,   379,  -426,   388,   394,   395,
    -426,  -426,    50,   392,    89,   396,   397,   398,   399,   400,
     403,   401,   391,   404,  -426,  -426,   402,  -426,  -426,   405,
    -426,   406,   407,   408,  -426,  -426,   409,   410,  -426,  -426,
      54,   412,   413,   123,   414,   415,   416,  -426,  -426,  -426,
     417,  -426,  -426,     5,    67,  -426,  -426,   100,  -426,   418,
     419,   421,   426,   427,   428,   429,   100,   411,   420,  -426,
     422,   142,   145,   146,   150,    66,  -426,  -426,  -426,  -426,
    -426,   423,   424,   124,   425,   431,   430,   432,    76,   433,
    -426,  -426,   436,   438,   439,   442,   445,   446,   447,   448,
    -426,  -426,  -426,  -426,   434,   449,  -426,   125,   450,   451,
    -426,  -426,   453,   454,   459,   460,   461,   462,   463,   465,
    -426,   435,   437,   468,   440,   441,   443,   470,   473,   474,
     476,   477,   478,   479,   480,  -426,  -426,   452,  -426,  -426,
     455,   456,   443,  -426,   481,   482,   483,   485,   487,   489,
     490,   491,  -426,   492,  -426,  -426,   493,   494,   496,   497,
     498,   499,   500,   501,   471,   472,   458,   502,   505,   506,
     507,   508,   509,  -426,  -426,  -426,   510,   511,   512,   515,
     516,   517,   518,   519,   520,   521,   486,   495,   525,    67,
     523,   524,  -426,  -426,   488,   503,   528,    67,  -426,  -426,
     504,   513,  -426,  -426
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -426,  -426,  -426,  -426,  -426,  -426,  -426,    53,  -426,  -426,
    -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,
    -426,  -426,  -426,    47,  -426,   526,  -426,  -426,  -426,  -426,
    -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,    81,  -426,
    -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,
      57,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,  -426,
    -426,  -426,  -343,  -302,   -27,  -425,  -426,  -426,  -426,  -426,
    -426,  -426,  -426,  -426,  -426,  -197,  -426,   484,  -426,  -426,
     469,   444,  -191,  -426,  -426,  -426,  -426,  -426,  -426,    45,
    -426,  -426,  -426,   -92
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -52
static const short yytable[] =
{
     230,   335,   240,    72,   202,   138,   324,   399,   438,   382,
       9,   202,   238,   -44,    12,    10,   238,   237,   -45,    12,
     471,    13,    14,    15,   239,   253,    13,    14,    15,   -51,
      31,   256,    32,   471,   -51,    73,   241,   139,   325,   400,
     439,   410,   -44,    -8,     1,    28,   298,   -45,   299,   300,
      -6,    -8,    -8,    -8,    87,   301,   302,    88,    33,    -8,
     174,   175,   176,   177,   -12,   298,   334,   299,   300,   298,
      89,   299,   300,    90,   301,   302,    39,   178,   301,   302,
     335,   441,    59,   442,   443,   408,    45,   -45,    12,   428,
     444,   441,    55,   442,   443,    13,    14,    15,    56,   128,
     444,   470,   129,   -51,   298,    80,   299,   300,   335,   151,
      77,   480,   152,   301,   302,   441,   157,   442,   443,   158,
     191,    61,   319,   192,   444,   320,   431,   474,   492,   432,
     475,   493,   348,   380,   349,    40,    42,    41,    43,   363,
      62,    52,    57,    53,    58,    66,    75,    67,    76,    78,
     377,    79,   143,    82,   144,   211,   215,   212,   216,    63,
     217,   220,   218,   221,   235,   326,   236,   327,   330,   332,
     331,   333,    64,   348,   401,   349,   462,    65,   463,   464,
     466,   465,   467,    74,   468,    83,   469,    68,    69,    84,
      85,    86,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   106,   102,   107,   108,   109,   110,   114,   115,
     116,   111,   112,   113,   117,   118,   119,   120,   121,   122,
     125,   124,   123,   130,   131,   132,   214,   440,   134,   133,
     135,   140,   127,   136,   141,   142,   146,   148,   153,   154,
     155,   156,   137,   159,   147,   160,   145,   169,   170,   193,
     195,   196,   197,   163,   164,   198,   199,   200,   201,   208,
     245,   224,   166,   165,   210,   202,   167,   168,   171,   172,
     225,   226,   -12,   228,   229,   231,   194,   232,   234,   243,
     246,   247,   244,   248,   249,   209,   250,   251,   252,   254,
     259,   219,   260,   222,   262,   223,   227,   233,   242,   263,
     255,   257,   264,   271,   261,   272,   258,   273,   274,   275,
     276,   277,   281,   282,   284,   285,   265,   266,   286,   268,
     288,   289,   290,   291,   292,   267,   293,   278,   279,   287,
     294,   280,   295,   297,   310,   311,   296,   312,   313,   314,
     315,   316,   317,   318,   321,   336,   337,   323,   328,   338,
     329,   340,   341,   342,   343,   344,   339,   346,   354,   345,
     353,   347,   565,   355,   356,   357,   358,   359,   360,   361,
     571,   362,   364,   365,   366,   370,   371,   372,   373,   375,
     374,   378,   376,   379,   385,   386,   387,   388,   389,   390,
     391,   383,   392,   402,   394,   393,   403,   406,   407,   411,
     412,   413,   414,   415,   395,   396,   416,   381,   420,   458,
     423,   424,   397,   398,   404,   429,   430,   433,   434,   435,
     525,   451,   452,   437,     0,   405,   409,   453,   418,   454,
     455,   456,   457,   478,     0,   479,   417,   477,   419,   482,
     421,   483,   484,   422,   425,   485,   459,   426,   486,   487,
     488,   489,   491,   494,   495,   460,   497,   498,   472,   461,
     476,   473,   499,   500,   501,   502,   503,   481,   504,   490,
     505,   507,   506,   514,   510,   508,   515,   516,   509,   517,
     518,   519,   520,   521,   526,   527,   528,   522,   529,   523,
     530,   524,   531,   532,   533,   545,   535,   536,   534,   537,
     538,   539,   540,   541,   542,   546,   543,   544,   547,   548,
     549,   550,   551,    54,     0,   554,   552,   553,   555,   556,
     557,   562,    71,   568,   558,   559,   560,   561,   564,   566,
     567,   570,   563,     0,     0,     0,     0,     0,     0,   572,
     569,     0,     0,    44,     0,     0,     0,     0,     0,     0,
     573,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   207
};

static const short yycheck[] =
{
     197,   303,     3,     3,    22,     3,     3,     3,     3,   352,
       0,    22,   203,     0,     1,     7,   207,    35,     0,     1,
     445,     8,     9,    10,    35,   222,     8,     9,    10,    16,
      34,   228,    36,   458,    16,    35,    37,    35,    35,    35,
      35,   384,    29,     0,     1,    21,    15,    29,    17,    18,
       7,     8,     9,    10,     3,    24,    25,     6,    19,    16,
      11,    12,    13,    14,    21,    15,    35,    17,    18,    15,
       3,    17,    18,     6,    24,    25,    34,    28,    24,    25,
     382,    15,    23,    17,    18,    35,    16,     0,     1,    35,
      24,    15,     6,    17,    18,     8,     9,    10,     6,     3,
      24,    35,     6,    16,    15,    32,    17,    18,   410,     3,
       5,    35,     6,    24,    25,    15,     3,    17,    18,     6,
       3,     3,     3,     6,    24,     6,     3,     3,     3,     6,
       6,     6,    34,    35,    36,    34,    34,    36,    36,   336,
       3,    34,    34,    36,    36,    34,     3,    36,     5,    34,
     347,    36,     3,     6,     5,    34,    34,    36,    36,     3,
      34,    34,    36,    36,    34,    34,    36,    36,    34,    34,
      36,    36,     3,    34,   371,    36,    34,     3,    36,    34,
      34,    36,    36,     3,    34,     3,    36,     3,     4,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,    36,    35,    33,     3,     3,     3,     3,    35,    37,
      35,     6,     6,     6,    37,     3,     3,     3,     3,     3,
      20,    36,     5,     3,     3,     3,   173,   424,     3,     6,
       6,     3,    34,    34,     3,     3,     3,    26,     3,     3,
       3,     3,    34,     3,    34,     6,    37,     3,     3,     3,
       3,     3,     3,    35,    35,     3,     3,     3,     3,     3,
     213,   180,    35,    37,     6,    22,    37,    37,    34,    27,
       6,     3,    21,     6,     3,     3,    35,     3,     3,     6,
       3,     3,     6,     3,     3,    35,     3,     3,     3,     3,
       3,    34,     3,    34,     3,    35,    35,    35,    35,     3,
      35,    35,     3,     3,    34,     3,    37,     3,     3,     3,
       3,     3,     3,     3,     3,     3,    37,    35,     3,    29,
       3,     3,     3,     3,     3,    37,     3,    35,    35,    34,
       3,    37,    34,     3,     3,     3,    35,     3,    35,     3,
       3,     3,     3,     3,     3,     3,     3,    34,    34,     3,
      34,     3,     3,     3,     3,     3,    34,     3,    34,     6,
       3,     6,   559,     3,     3,     3,     3,     3,     3,     3,
     567,     3,     3,     3,    30,     3,     3,     3,     3,     3,
      35,     3,    35,     3,     3,     3,     3,     3,     3,     3,
       3,    35,     3,     3,    35,    37,     3,     3,     3,     3,
       3,     3,     3,     3,    37,    34,     3,   350,     6,   436,
       3,     3,    35,   368,    35,     3,     3,     3,     3,     3,
     512,     3,     3,     6,    -1,    37,    34,     6,    37,     3,
       3,     3,     3,     3,    -1,     3,    35,     6,    34,     3,
      35,     3,     3,    37,    35,     3,    35,    37,     3,     3,
       3,     3,     3,     3,     3,    35,     3,     3,    35,    37,
      35,    37,     3,     3,     3,     3,     3,    34,     3,    35,
      35,     3,    35,     3,    31,    35,     3,     3,    37,     3,
       3,     3,     3,     3,     3,     3,     3,    35,     3,    34,
       3,    35,     3,     3,     3,    37,     3,     3,     6,     3,
       3,     3,     3,     3,     3,     3,    35,    35,     3,     3,
       3,     3,     3,    29,    -1,     3,     6,     6,     3,     3,
       3,    35,    53,    35,     6,     6,     6,     6,     3,     6,
       6,     3,    37,    -1,    -1,    -1,    -1,    -1,    -1,    35,
      37,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   162
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    39,    40,    41,    42,    43,    45,    46,     0,
       7,    47,     1,     8,     9,    10,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    21,   114,
     115,    34,    36,    19,    48,    49,    50,    51,    52,    34,
      34,    36,    34,    36,    63,    16,    89,    90,    92,    94,
      96,    98,    34,    36,   115,     6,     6,    34,    36,    23,
      53,     3,     3,     3,     3,     3,    34,    36,     3,     4,
     118,   118,     3,    35,     3,     3,     5,     5,    34,    36,
      32,    54,     6,     3,     3,     3,     3,     3,     6,     3,
       6,   113,     3,     3,     3,     3,     3,     3,     3,     3,
       3,    36,    33,    55,    56,    57,    35,     3,     3,     3,
       3,     6,     6,     6,    35,    37,    35,    37,     3,     3,
       3,     3,     3,     5,    36,    20,    58,    34,     3,     6,
       3,     3,     3,     6,     3,     6,    34,    34,     3,    35,
       3,     3,     3,     3,     5,    37,     3,    34,    26,    59,
      73,     3,     6,     3,     3,     3,     3,     3,     6,     3,
       6,   117,   116,    35,    35,    37,    35,    37,    37,     3,
       3,    34,    27,    60,    11,    12,    13,    14,    28,    74,
      75,    76,    78,    79,    80,    81,    82,    83,    84,    85,
      86,     3,     6,     3,    35,     3,     3,     3,     3,     3,
       3,     3,    22,   119,   120,   121,   122,   119,     3,    35,
       6,    34,    36,    44,    45,    34,    36,    34,    36,    34,
      34,    36,    34,    35,    76,     6,     3,    35,     6,     3,
     113,     3,     3,    35,     3,    34,    36,    35,   120,    35,
       3,    37,    35,     6,     6,    61,     3,     3,     3,     3,
       3,     3,     3,   113,     3,    35,   113,    35,    37,     3,
       3,    34,     3,     3,     3,    37,    35,    37,    29,   123,
     124,     3,     3,     3,     3,     3,     3,     3,    35,    35,
      37,     3,     3,    91,     3,     3,     3,    34,     3,     3,
       3,     3,     3,     3,     3,    34,    35,     3,    15,    17,
      18,    24,    25,   100,   101,   106,   107,   108,   111,   112,
       3,     3,     3,    35,     3,     3,     3,     3,     3,     3,
       6,     3,    77,    34,     3,    35,    34,    36,    34,    34,
      34,    36,    34,    36,    35,   101,     3,     3,     3,    34,
       3,     3,     3,     3,     3,     6,     3,     6,    34,    36,
      87,    88,    93,     3,    34,     3,     3,     3,     3,     3,
       3,     3,     3,   113,     3,     3,    30,   125,   126,   127,
       3,     3,     3,     3,    35,     3,    35,   113,     3,     3,
      35,    88,   100,    35,    95,     3,     3,     3,     3,     3,
       3,     3,     3,    37,    35,    37,    34,    35,   127,     3,
      35,   113,     3,     3,    35,    37,     3,     3,    35,    34,
     100,     3,     3,     3,     3,     3,     3,    35,    37,    34,
       6,    35,    37,     3,     3,    35,    37,    97,    35,     3,
       3,     3,     6,     3,     3,     3,    99,     6,     3,    35,
     113,    15,    17,    18,    24,   102,   103,   104,   105,   109,
     110,     3,     3,     6,     3,     3,     3,     3,   102,    35,
      35,    37,    34,    36,    34,    36,    34,    36,    34,    36,
      35,   103,    35,    37,     3,     6,    35,     6,     3,     3,
      35,    34,     3,     3,     3,     3,     3,     3,     3,     3,
      35,     3,     3,     6,     3,     3,   128,     3,     3,     3,
       3,     3,     3,     3,     3,    35,    35,     3,    35,    37,
      31,   129,   130,   131,     3,     3,     3,     3,     3,     3,
       3,     3,    35,    34,    35,   131,     3,     3,     3,     3,
       3,     3,     3,     3,     6,     3,     3,     3,     3,     3,
       3,     3,     3,    35,    35,    37,     3,     3,     3,     3,
       3,     3,     6,     6,     3,     3,     3,     3,     6,     6,
       6,     6,    35,    37,     3,   113,     6,     6,    35,    37,
       3,   113,    35,    37
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 97 "parse_y.y"
    { YYABORT; }
    break;

  case 6:
#line 101 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyPCB)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyFont = &yyPCB->Font;
				yyData = yyPCB->Data;
			}
    break;

  case 8:
#line 131 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyData || !yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
			}
    break;

  case 12:
#line 155 "parse_y.y"
    {
					/* mark all symbols invalid */
				int	i;

				if (!yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				yyFont->Valid = False;
				for (i = 0; i <= MAX_FONTPOSITION; i++)
					yyFont->Symbol[i].Valid = False;
			}
    break;

  case 13:
#line 169 "parse_y.y"
    {
				yyFont->Valid = True;
		  		SetFontInfo(yyFont);
			}
    break;

  case 14:
#line 177 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-1].string;
				yyPCB->MaxWidth = MAX_COORD;
				yyPCB->MaxHeight = MAX_COORD;
			}
    break;

  case 15:
#line 183 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number*100;
				yyPCB->MaxHeight = yyvsp[-1].number*100;
			}
    break;

  case 16:
#line 189 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number;
				yyPCB->MaxHeight = yyvsp[-1].number;
			}
    break;

  case 21:
#line 204 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-3].number*100;
				yyPCB->GridOffsetX = yyvsp[-2].number*100;
				yyPCB->GridOffsetY = yyvsp[-1].number*100;
			}
    break;

  case 22:
#line 212 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].number*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 23:
#line 225 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 24:
#line 237 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating;
				yyPCB->GridOffsetX = yyvsp[-3].number;
				yyPCB->GridOffsetY = yyvsp[-2].number;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 25:
#line 250 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number*100;
				yyPCB->CursorY = yyvsp[-2].number*100;
				yyPCB->Zoom = yyvsp[-1].number*2;
			}
    break;

  case 26:
#line 256 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].number;
			}
    break;

  case 27:
#line 262 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].floating;
			}
    break;

  case 30:
#line 273 "parse_y.y"
    {
				yyPCB->ThermScale = yyvsp[-1].floating;
			}
    break;

  case 34:
#line 286 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-3].number;
				yyPCB->Shrink = yyvsp[-2].number;
				yyPCB->minWid = yyvsp[-1].number;
			}
    break;

  case 36:
#line 296 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-4].number;
				yyPCB->Shrink = yyvsp[-3].number;
				yyPCB->minWid = yyvsp[-2].number;
				yyPCB->minSlk = yyvsp[-1].number;
			}
    break;

  case 37:
#line 306 "parse_y.y"
    {
				yyPCB->Flags = yyvsp[-1].number & PCB_FLAGS;
			}
    break;

  case 39:
#line 314 "parse_y.y"
    {
				if (ParseGroupString(yyvsp[-1].string, &yyPCB->LayerGroups))
				{
					Message("illegal layer-group string\n");
					YYABORT;
				}
			}
    break;

  case 41:
#line 325 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 100))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 42:
#line 333 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 1))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 51:
#line 358 "parse_y.y"
    {
					/* clear pointer to force memory allocation by 
					 * the appropriate subroutine
					 */
				yyElement = NULL;
			}
    break;

  case 53:
#line 365 "parse_y.y"
    { YYABORT; }
    break;

  case 59:
#line 379 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 60:
#line 389 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 61:
#line 400 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, (yyvsp[-5].number + yyvsp[-4].number)*100, yyvsp[-3].number*100, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 62:
#line 410 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100,  yyvsp[-3].number*100, yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 63:
#line 420 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				CreateNewVia(yyData, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS) | VIAFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 64:
#line 436 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, (yyvsp[-1].number & OBJ_FLAGS) | RATFLAG);
			}
    break;

  case 65:
#line 441 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, (yyvsp[-1].number & OBJ_FLAGS) | RATFLAG);
			}
    break;

  case 66:
#line 450 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_LAYER + 2)
				{
					yyerror("Layernumber out of range");
					YYABORT;
				}
				if (LayerFlag[yyvsp[-3].number-1])
				{
					yyerror("Layernumber used twice");
					YYABORT;
				}
				Layer = &yyData->Layer[yyvsp[-3].number-1];

					/* memory for name is alread allocated */
				Layer->Name = yyvsp[-2].string;
				LayerFlag[yyvsp[-3].number-1] = True;
			}
    break;

  case 78:
#line 489 "parse_y.y"
    {
				CreateNewPolygonFromRectangle(Layer,
					yyvsp[-5].number*100, yyvsp[-4].number*100, (yyvsp[-5].number+yyvsp[-3].number)*100, (yyvsp[-4].number+yyvsp[-2].number)*100, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 82:
#line 498 "parse_y.y"
    {
				Polygon = CreateNewPolygon(Layer, yyvsp[-2].number & OBJ_FLAGS);
			}
    break;

  case 83:
#line 502 "parse_y.y"
    {
					/* ignore junk */
				if (Polygon->PointN >= 3)
					SetPolygonBoundingBox(Polygon);
				else
				{
					Message("WARNING parsing file '%s'\n"
						"    line:        %i\n"
						"    description: 'ignored polygon (< 3 points)'\n",
						yyfilename, yylineno);
					DestroyObject(PCB->Data, POLYGON_TYPE, Layer, Polygon, Polygon);
				}
			}
    break;

  case 84:
#line 520 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 85:
#line 528 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 86:
#line 536 "parse_y.y"
    {
				/* elliminate old-style rat-lines */
			if ((yyvsp[-1].number & RATFLAG) == 0)
				CreateNewLineOnLayer(Layer, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100,
					200*GROUNDPLANEFRAME, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 87:
#line 547 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 88:
#line 555 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number*100, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 89:
#line 563 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-3].number, yyvsp[-2].number,
					yyvsp[-4].number*100, 200*GROUNDPLANEFRAME, yyvsp[-1].number & OBJ_FLAGS);
			}
    break;

  case 90:
#line 572 "parse_y.y"
    {
					/* use a default scale of 100% */
				CreateNewText(Layer,yyFont,yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, 100, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 91:
#line 582 "parse_y.y"
    {
				if (yyvsp[-1].number & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[MAX_LAYER +
						((yyvsp[-1].number & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay ,yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 92:
#line 598 "parse_y.y"
    {
				if (yyvsp[-1].number & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[MAX_LAYER +
						((yyvsp[-1].number & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay ,yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].number & OBJ_FLAGS);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 95:
#line 620 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 96:
#line 624 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 103:
#line 643 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, 0x0000,
					yyvsp[-6].string, yyvsp[-5].string, NULL, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number, 100, 0x0000, False);
				SaveFree(yyvsp[-6].string);
				SaveFree(yyvsp[-5].string);
				pin_num = 1;
			}
    break;

  case 104:
#line 651 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 105:
#line 661 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-9].number,
					yyvsp[-8].string, yyvsp[-7].string, NULL, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, False);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 106:
#line 669 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 107:
#line 679 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-10].number,
					yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, False);
				SaveFree(yyvsp[-9].string);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 108:
#line 688 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 109:
#line 699 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-12].number,
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number)*100, (yyvsp[-7].number+yyvsp[-5].number)*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, False);
				yyElement->MarkX = yyvsp[-8].number*100;
				yyElement->MarkY = yyvsp[-7].number*100;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 110:
#line 709 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 111:
#line 720 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-12].number,
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number), (yyvsp[-7].number+yyvsp[-5].number), yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, False);
				yyElement->MarkX = yyvsp[-8].number;
				yyElement->MarkY = yyvsp[-7].number;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 112:
#line 730 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 120:
#line 748 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 121:
#line 753 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 122:
#line 758 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 123:
#line 763 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 124:
#line 768 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number;
				yyElement->MarkY = yyvsp[-1].number;
			}
    break;

  case 125:
#line 773 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number*100;
				yyElement->MarkY = yyvsp[-1].number*100;
			}
    break;

  case 132:
#line 791 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number + yyElement->MarkX,
					yyvsp[-4].number + yyElement->MarkY, yyvsp[-3].number + yyElement->MarkX,
					yyvsp[-2].number + yyElement->MarkY, yyvsp[-1].number);
			}
    break;

  case 133:
#line 797 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100 + yyElement->MarkX,
					yyvsp[-4].number*100 + yyElement->MarkY, yyvsp[-3].number*100 + yyElement->MarkX,
					yyvsp[-2].number*100 + yyElement->MarkY, yyvsp[-1].number*100);
			}
    break;

  case 134:
#line 804 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number + yyElement->MarkX,
					yyvsp[-6].number + yyElement->MarkY, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 135:
#line 809 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100 + yyElement->MarkX,
					yyvsp[-6].number*100 + yyElement->MarkY, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 136:
#line 819 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number + yyElement->MarkX,
					yyvsp[-8].number + yyElement->MarkY, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].string,
					yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 137:
#line 831 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number*100 + yyElement->MarkX,
					yyvsp[-8].number*100 + yyElement->MarkY, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].string,
					yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 138:
#line 843 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-5].number + 2*MASKFRAME)*100, yyvsp[-4].number*100, yyvsp[-3].string, yyvsp[-2].string,
					(yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 139:
#line 855 "parse_y.y"
    {
				char	p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].number*100, yyvsp[-2].string, p_number,
					(yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 140:
#line 871 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);
				char		p_number[8];

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, p_number,
					(yyvsp[-1].number & OBJ_FLAGS) | PINFLAG);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 141:
#line 891 "parse_y.y"
    {
				CreateNewPad(yyElement, yyvsp[-10].number + yyElement->MarkX,
					yyvsp[-9].number + yyElement->MarkY,
					yyvsp[-8].number + yyElement->MarkX,
					yyvsp[-7].number + yyElement->MarkY, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number,
					yyvsp[-3].string, yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 142:
#line 905 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-10].number*100 + yyElement->MarkX,
					yyvsp[-9].number*100 + yyElement->MarkY, yyvsp[-8].number*100 + yyElement->MarkX,
					yyvsp[-7].number*100 + yyElement->MarkY, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					yyvsp[-3].string, yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 143:
#line 918 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-8].number*100,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].string,yyvsp[-2].string, (yyvsp[-1].number & OBJ_FLAGS));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 144:
#line 929 "parse_y.y"
    {
				char		p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPad(yyElement,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100,yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, yyvsp[-2].string,p_number,
					(yyvsp[-1].number & OBJ_FLAGS));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 145:
#line 940 "parse_y.y"
    { yyval.number = yyvsp[0].number; }
    break;

  case 146:
#line 941 "parse_y.y"
    { yyval.number = string_to_flags (yyvsp[0].string, yyerror); }
    break;

  case 149:
#line 951 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number;
			}
    break;

  case 151:
#line 968 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number*100;
			}
    break;

  case 160:
#line 1005 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 161:
#line 1012 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 169:
#line 1039 "parse_y.y"
    {
				Menu = CreateNewNet(&yyPCB->NetlistLib, yyvsp[-3].string, yyvsp[-2].string);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 175:
#line 1059 "parse_y.y"
    {
				CreateNewConnection(Menu, yyvsp[-1].string);
				SaveFree(yyvsp[-1].string);
			}
    break;


    }

/* Line 991 of yacc.c.  */
#line 2420 "parse_y.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  MacOS 10.2.3's buggy "smart preprocessor"
     insists on the trailing semicolon.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__));
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1064 "parse_y.y"


/* ---------------------------------------------------------------------------
 * error routine called by parser library
 */
int yyerror(s)
char *s;
{
	Message("ERROR parsing file '%s'\n"
		"    line:        %i\n"
		"    description: '%s'\n",
		yyfilename, yylineno, s);
	return(0);
}

int yywrap()
{
  return 1;
}

