/******************************************************************************
* Copyright (c) 2018, Kyle Mann (kyle@hobu.co)
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following
* conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in
*       the documentation and/or other materials provided
*       with the distribution.
*     * Neither the name of Hobu, Inc. or Flaxen Geo Consulting nor the
*       names of its contributors may be used to endorse or promote
*       products derived from this software without specific prior
*       written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
* COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
* OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
* AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
* OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
* OF SUCH DAMAGE.
****************************************************************************/
#pragma once

#include <stdexcept>

#include <json/json.h>

namespace lepcc
{
    struct Point3D;
    struct RGB_t;
}

namespace pdal
{
namespace EsriUtil
{

class json_parse_error : public std::runtime_error
{
public:
    json_parse_error(const std::string txt) : std::runtime_error(txt)
    {}
};

class decompression_error : public std::runtime_error
{
public:
    decompression_error(const std::string txt) : std::runtime_error(txt)
    {}
};

/*Return value of data in json format*/
inline Json::Value parse(const std::string& data)
{
    Json::Value json;
    Json::Reader reader;
    if (data.size())
    {
        if (!reader.parse(data, json, false))
        {
            const std::string jsonError(reader.getFormattedErrorMessages());
            if (!jsonError.empty())
                throw json_parse_error("Error during parsing: " +
                        jsonError);
        }
    }
    return json;
}

std::vector<lepcc::Point3D> decompressXYZ(std::vector<char>* compData);
std::vector<lepcc::RGB_t> decompressRGB(std::vector<char>* compData);
std::vector<uint16_t> decompressIntensity(std::vector<char>* compData);

} // namespace EsriUtil
} // namespace pdal
