/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

/********************************************************************/
/*Code in Format.cpp and Format.h adapted from:			    */
/*								    */
/*Stroustrup, Bjarne. The C++ Programming Language: Special Edition.*/
/*    Addison-Wesley, 1997.					    */
/********************************************************************/

#include "Format.h"

  Format& Format::scientific() {fmt=ios::scientific; return *this;}
  Format& Format::fixed() {fmt=ios::fixed; return *this;}
  Format& Format::general() {fmt=0; return *this;}

  Format& Format::precision(int p) {prc=p; return *this;}

  Format& Format::width(int w) {wdt = w; return *this;} //applies to all types

Bound_format Format::operator()(double d) const {
  return Bound_format(*this, d);
}

/* Write floating-point number to file, but only to the specified number
   of decimal places (3 places past the decimal for Cartesian coordinates
   in our case).
*/
void
write_file(ofstream& f_out,
			 const Bound_format& bf){
  f_out.precision(bf.f.prc);
  f_out.setf(bf.f.fmt, ios::floatfield);
  f_out << bf.val;
}
