/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

/* Sidegroup (chi) dihedral angle computation functions */

#include "Pdb_dhl1.h"
#include "Pdb_dhl2.h"

/* In each function:
   int "chicnt" holds the number of chi dihedral angles.
   The x,y,z positions of each of the 4 atoms defining a
   dihedral angle are extracted from the Pdb_line array
   and used to compute the angle.
*/

void chi_ala(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
  *chicnt = 1;
  x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
  z[0] = memfile[m[" N   "]].get_z();

  x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
  z[1] = memfile[m[" CA  "]].get_z();

  x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
  z[2] = memfile[m[" CB  "]].get_z();
  
  x[3] = memfile[m[" HB  "]].get_x(); y[3] = memfile[m[" HB  "]].get_y();
  z[3] = memfile[m[" HB  "]].get_z();

  chi[0] = dihedral_angle(x,y,z);

}

void chi_gly(int* chicnt){
  *chicnt = 0;

}

void chi_val(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
 *chicnt = 3;
    x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
    z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" CG1 "]].get_x(); y[3] = memfile[m[" CG1 "]].get_y();
    z[3] = memfile[m[" CG1 "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG1 "]].get_x(); y[2] = memfile[m[" CG1 "]].get_y();
    z[2] = memfile[m[" CG1 "]].get_z();

    x[3] = memfile[m[" HG1 "]].get_x(); y[3] = memfile[m[" HG1 "]].get_y();
    z[3] = memfile[m[" HG1 "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG2 "]].get_x(); y[2] = memfile[m[" CG2 "]].get_y();
    z[2] = memfile[m[" CG2 "]].get_z();

    x[3] = memfile[m[" HG2 "]].get_x(); y[3] = memfile[m[" HG2 "]].get_y();
    z[3] = memfile[m[" HG2 "]].get_z();

    chi[2] = dihedral_angle(x,y,z);

}

void chi_trp(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
 *chicnt = 2;
    x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
    z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" CG  "]].get_x(); y[3] = memfile[m[" CG  "]].get_y();
    z[3] = memfile[m[" CG  "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG  "]].get_x(); y[2] = memfile[m[" CG  "]].get_y();
    z[2] = memfile[m[" CG  "]].get_z();

    x[3] = memfile[m[" CD1 "]].get_x(); y[3] = memfile[m[" CD1 "]].get_y();
    z[3] = memfile[m[" CD1 "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

}

void chi_ser(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
 *chicnt = 2;
    x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
    z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" OG  "]].get_x(); y[3] = memfile[m[" OG  "]].get_y();
    z[3] = memfile[m[" OG  "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" OG  "]].get_x(); y[3] = memfile[m[" OG  "]].get_y();
    z[3] = memfile[m[" OG  "]].get_z();

    x[0] = memfile[m[" HG  "]].get_x(); y[0] = memfile[m[" HG  "]].get_y();
    z[0] = memfile[m[" HG  "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

}

void chi_thr(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
  *chicnt = 3;
  x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
  z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" OG1 "]].get_x(); y[3] = memfile[m[" OG1 "]].get_y();
    z[3] = memfile[m[" OG1 "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" OG1 "]].get_x(); y[2] = memfile[m[" OG1 "]].get_y();
    z[2] = memfile[m[" OG1 "]].get_z();

    x[3] = memfile[m[" HG1 "]].get_x(); y[3] = memfile[m[" HG1 "]].get_y();
    z[3] = memfile[m[" HG1 "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG2 "]].get_x(); y[2] = memfile[m[" CG2 "]].get_y();
    z[2] = memfile[m[" CG2 "]].get_z();

    x[3] = memfile[m[" HG2 "]].get_x(); y[3] = memfile[m[" HG2 "]].get_y();
    z[3] = memfile[m[" HG2 "]].get_z();

    chi[2] = dihedral_angle(x,y,z);

}

void chi_lys(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){

 *chicnt = 5;
    x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
    z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" CG  "]].get_x(); y[3] = memfile[m[" CG  "]].get_y();
    z[3] = memfile[m[" CG  "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG  "]].get_x(); y[2] = memfile[m[" CG  "]].get_y();
    z[2] = memfile[m[" CG  "]].get_z();

    x[3] = memfile[m[" CD  "]].get_x(); y[3] = memfile[m[" CD  "]].get_y();
    z[3] = memfile[m[" CD  "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CB  "]].get_x(); y[0] = memfile[m[" CB  "]].get_y();
    z[0] = memfile[m[" CB  "]].get_z();

    x[1] = memfile[m[" CG  "]].get_x(); y[1] = memfile[m[" CG  "]].get_y();
    z[1] = memfile[m[" CG  "]].get_z();

    x[2] = memfile[m[" CD  "]].get_x(); y[2] = memfile[m[" CD  "]].get_y();
    z[2] = memfile[m[" CD  "]].get_z();

    x[3] = memfile[m[" CE  "]].get_x(); y[3] = memfile[m[" CE  "]].get_y();
    z[3] = memfile[m[" CE  "]].get_z();

    chi[2] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CG  "]].get_x(); y[0] = memfile[m[" CG  "]].get_y();
    z[0] = memfile[m[" CG  "]].get_z();

    x[1] = memfile[m[" CD  "]].get_x(); y[1] = memfile[m[" CD  "]].get_y();
    z[1] = memfile[m[" CD  "]].get_z();

    x[2] = memfile[m[" CE  "]].get_x(); y[2] = memfile[m[" CE  "]].get_y();
    z[2] = memfile[m[" CE  "]].get_z();

    x[3] = memfile[m[" NZ  "]].get_x(); y[3] = memfile[m[" NZ  "]].get_y();
    z[3] = memfile[m[" NZ  "]].get_z();

    chi[3] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CD  "]].get_x(); y[0] = memfile[m[" CD  "]].get_y();
    z[0] = memfile[m[" CD  "]].get_z();

    x[1] = memfile[m[" CE  "]].get_x(); y[1] = memfile[m[" CE  "]].get_y();
    z[1] = memfile[m[" CE  "]].get_z();

    x[2] = memfile[m[" NZ  "]].get_x(); y[2] = memfile[m[" NZ  "]].get_y();
    z[2] = memfile[m[" NZ  "]].get_z();

    x[3] = memfile[m[" HZ  "]].get_x(); y[3] = memfile[m[" HZ  "]].get_y();
    z[3] = memfile[m[" HZ  "]].get_z();

    chi[4] = dihedral_angle(x,y,z);

}

void chi_leu(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
 *chicnt = 4;
    x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
    z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" CG  "]].get_x(); y[3] = memfile[m[" CG  "]].get_y();
    z[3] = memfile[m[" CG  "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG  "]].get_x(); y[2] = memfile[m[" CG  "]].get_y();
    z[2] = memfile[m[" CG  "]].get_z();

    x[3] = memfile[m[" CD1 "]].get_x(); y[3] = memfile[m[" CD1 "]].get_y();
    z[3] = memfile[m[" CD1 "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CB  "]].get_x(); y[0] = memfile[m[" CB  "]].get_y();
    z[0] = memfile[m[" CB  "]].get_z();

    x[1] = memfile[m[" CG  "]].get_x(); y[1] = memfile[m[" CG  "]].get_y();
    z[1] = memfile[m[" CG  "]].get_z();

    x[2] = memfile[m[" CD1 "]].get_x(); y[2] = memfile[m[" CD1 "]].get_y();
    z[2] = memfile[m[" CD1 "]].get_z();

    x[3] = memfile[m[" HD1 "]].get_x(); y[3] = memfile[m[" HD1 "]].get_y();
    z[3] = memfile[m[" HD1 "]].get_z();

    chi[2] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CB  "]].get_x(); y[0] = memfile[m[" CB  "]].get_y();
    z[0] = memfile[m[" CB  "]].get_z();

    x[1] = memfile[m[" CG  "]].get_x(); y[1] = memfile[m[" CG  "]].get_y();
    z[1] = memfile[m[" CG  "]].get_z();

    x[2] = memfile[m[" CD2 "]].get_x(); y[2] = memfile[m[" CD2 "]].get_y();
    z[2] = memfile[m[" CD2 "]].get_z();

    x[3] = memfile[m[" HD2 "]].get_x(); y[3] = memfile[m[" HD2 "]].get_y();
    z[3] = memfile[m[" HD2 "]].get_z();

    chi[3] = dihedral_angle(x,y,z);

}

void chi_ile(Pdb_line* memfile,
	     map<string, int>& m,
	     double* chi,
	     int* chicnt,
	     double* x, double* y, double* z){
*chicnt = 4;
    x[0] = memfile[m[" N   "]].get_x(); y[0] = memfile[m[" N   "]].get_y();
    z[0] = memfile[m[" N   "]].get_z();

    x[1] = memfile[m[" CA  "]].get_x(); y[1] = memfile[m[" CA  "]].get_y();
    z[1] = memfile[m[" CA  "]].get_z();

    x[2] = memfile[m[" CB  "]].get_x(); y[2] = memfile[m[" CB  "]].get_y();
    z[2] = memfile[m[" CB  "]].get_z();

    x[3] = memfile[m[" CG1 "]].get_x(); y[3] = memfile[m[" CG1 "]].get_y();
    z[3] = memfile[m[" CG1 "]].get_z();

    chi[0] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG1 "]].get_x(); y[2] = memfile[m[" CG1 "]].get_y();
    z[2] = memfile[m[" CG1 "]].get_z();

    x[3] = memfile[m[" CD1 "]].get_x(); y[3] = memfile[m[" CD1 "]].get_y();
    z[3] = memfile[m[" CD1 "]].get_z();

    chi[1] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CA  "]].get_x(); y[0] = memfile[m[" CA  "]].get_y();
    z[0] = memfile[m[" CA  "]].get_z();

    x[1] = memfile[m[" CB  "]].get_x(); y[1] = memfile[m[" CB  "]].get_y();
    z[1] = memfile[m[" CB  "]].get_z();

    x[2] = memfile[m[" CG2 "]].get_x(); y[2] = memfile[m[" CG2 "]].get_y();
    z[2] = memfile[m[" CG2 "]].get_z();

    x[3] = memfile[m[" HG2 "]].get_x(); y[3] = memfile[m[" HG2 "]].get_y();
    z[3] = memfile[m[" HG2 "]].get_z();

    chi[2] = dihedral_angle(x,y,z);

    x[0] = memfile[m[" CB  "]].get_x(); y[0] = memfile[m[" CB  "]].get_y();
    z[0] = memfile[m[" CB  "]].get_z();

    x[1] = memfile[m[" CG1 "]].get_x(); y[1] = memfile[m[" CG1 "]].get_y();
    z[1] = memfile[m[" CG1 "]].get_z();

    x[2] = memfile[m[" CD1 "]].get_x(); y[2] = memfile[m[" CD1 "]].get_y();
    z[2] = memfile[m[" CD1 "]].get_z();

    x[3] = memfile[m[" HD1 "]].get_x(); y[3] = memfile[m[" HD1 "]].get_y();
    z[3] = memfile[m[" HD1 "]].get_z();

    chi[3] = dihedral_angle(x,y,z);

}
