# (c) 2002-2003 Mathieu Roy <yeupou@gnu.org>
# xhtml.pl: this file is part of package_db_view
#
#   XHTML (and HTML) rendering
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  take a look at http://savannah.nongnu.org/projects/pdbv
#  send comments at <pdbv-dev@nongnu.org>
#
#  $Id: xhtml.pl,v 1.18 2003/06/20 22:50:50 yeupou Exp $

print "The purpose of this file is not being executed alone";
exit;

sub PdbvXhtmlInit {
    $working_dir_css = "$working_dir/style.css" unless $working_dir_css;
    $output = "xhtml" unless $output;
    $output_ext = ".html" unless $output_ext;  
}

# To save memory, we do print instead of storing data in vars (as pdbv.bash)
#
# It means that these commands must be used with an opened handle
# specified as arg1.

sub PdbvXhtmlPrintHeader {
    # arg1 = $handle
    # arg2 = title
    # arg3 = no <body>
    # arg4 = css relative path
    my $handle = STDOUT;
    my $title = "pdbv";
    my $body = "<body>";
    my $csspath;
    $handle = $_[0] if $_[0];
    $title = $_[1] if $_[1];
    $body = "" if $_[2];
    $csspath = $_[3] if $_[3];

    print $handle "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">
<html>
<head>
  <title>".$title."</title>
  <meta name=\"Generator\" content=\"".$sname." ".$sver."\" />
  <link rel=\"stylesheet\" type=\"text/css\" href=\"".$csspath."style.css\" />
</head>
".$body."\n";
}

sub PdbvXhtmlPrintFooter {
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];
    my $date = strftime "%c", localtime;

    print $handle "<p class=\"footer\"><a href=\"".$surl."\">".$sname."-".$sver."</a> ".$date."</p>
</body>
</html>\n";
}


sub PdbvXhtmlPrintListingFrame {
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];

    PdbvXhtmlPrintHeader($handle);
    print $handle "<p>";
    print $handle gettext("Sort by");
    print $handle " <a href=\"list".$output_ext."\" target=\"list\">".gettext("Package")."</a>";
    if ($listing eq "group" || $listing eq "all") {
	print $handle " | <a href=\"list_bygroup".$output_ext."\" target=\"list\">".gettext("Section")."</a>";
    }
    if ($listing eq "date" || $listing eq "all") {
	print $handle " | <a href=\"list_bydate".$output_ext."\" target=\"list\">".gettext("Date")."</a>";
    }
    print $handle "</p>";
    PdbvXhtmlPrintFooter($handle);
}

sub PdbvXhtmlPrintListFrame {
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];
    my $pkg_number = 0;
    
    PdbvXhtmlPrintHeader($handle, gettext("Package List"));
    foreach my $pack (PdbvPackagesSorted()) {
	$pkg_number++;
	print $handle $pkg_number.". <a href=\"package/".$pack.$output_ext."\" target=\"package\">".$pack."</a><br />\n";
    }
    PdbvXhtmlPrintFooter($handle);
}

sub PdbvXhtmlPrintListBycriterionFrame {
    my $handle = $_[0] if $_[0];
    my $criterion = $_[1] if $_[1];
    die "Internal error: criterion not set, exiting" unless $criterion;
    my $pkg_number = 0;

    PdbvXhtmlPrintHeader($handle, gettext("Package List"));
    PdbvXhtmlPrintFooter($handle);
}

sub PdbvXhtmlPrintItemFrame {
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];
    my $ret;
    my $pack = $_[1];

    PdbvXhtmlPrintHeader($handle, $pack, 0, "../");
    print $handle "<h2 class=\"title\">";
    print $handle gettext("Details for ");
    PdbvXhtmlPrintPackagePointer($handle, $pack);
    print $handle "</h2><br />";

    my @raw = split /^/, PdbvInfo($pack);

    # At this moment, we're forced to add packaging-system specific stuff.
    # It should be theorically in dpkg.pl and rpm.pl. 
    # We still can change that, if someday it creates trouble.
    # Right now, it saves time by doing s// only if needed by package.

    # Note that all the <i> will be removed when we'll add CSS2 support.

    if ($pdbv_type eq 'dpkg') {
	foreach my $line (@raw) {
    	    # Replace < > by html equivs
	    # (must be done first)
	    $line =~ s/\<(.*)\>/\&lt\;\1\&gt\;/;

	    # $sbst are defined in translationstrings module.
	    
	    $line =~ s/^Bugs:/\<font class="itemtitle"\>$sbst_bugs\<\/font\>/;
	    $line =~ s/^Conffiles:/\<br \/\>\<font class="itemtitle"\>$sbst_conffiles\<\/font\>/;
	    $line =~ s/^Config-Version:/\<font class="itemtitle"\>$sbst_configversion\<\/font\>/;
	    $line =~ s/^Conflicts:/\<font class="itemtitle"\>$sbst_conflicts\<\/font\>/;
	    $line =~ s/^Depends:/\<font class="itemtitle"\>$sbst_depends\<\/font\>/;
	    $line =~ s/^Description:/\<br \/\>\<font class="itemtitle"\>$sbst_description\<\/font\>\<br \/\>/;
	    $line =~ s/^Enhances:/\<font class="itemtitle"\>$sbst_enhances\<\/font\>/;
	    $line =~ s/^Essential:/\<font class="itemtitle"\>$sbst_essential\<\/font\>/;
	    $line =~ s/^Installed-Size:/\<font class="itemtitle"\>$sbst_installedsize\<\/font\>/;
	    $line =~ s/^Maintainer:/\<font class="itemtitle"\>$sbst_maintainer\<\/font\>/;
	    $line =~ s/^Origin:/\<font class="itemtitle"\>$sbst_origin\<\/font\>/;
	    $line =~ s/^Package:/\<font class="itemtitle"\>$sbst_package\<\/font\>/;
	    $line =~ s/^Priority:/\<font class="itemtitle"\>$sbst_priority\<\/font\>/;
	    $line =~ s/^Provides:/\<font class="itemtitle"\>$sbst_provides\<\/font\>/;
	    $line =~ s/^Recommends:/\<font class="itemtitle"\>$sbst_recommends\<\/font\>/;
	    $line =~ s/^Replaces:/\<font class="itemtitle"\>$sbst_replaces\<\/font\>/;
	    $line =~ s/^Section:/\<font class="itemtitle"\>$sbst_section\<\/font\>/;
	    $line =~ s/^Source:/\<font class="itemtitle"\>$sbst_source\<\/font\>/;
	    $line =~ s/^Status:/\<font class="itemtitle"\>$sbst_status\<\/font\>/;
	    $line =~ s/^Suggests:/\<font class="itemtitle"\>$sbst_suggest\<\/font\>/;
	    $line =~ s/^Version:/\<font class="itemtitle"\>$sbst_version\<\/font\>/;
	   
	    $line =~ s/^ \.$/ /; # " ." begins paragraph in dpkg desc.

	    # Finally non dpkg specific
	    # line break by xhtml equivs       
	    $line =~ s/$/<br \/>/; 
	    unless ($light) {
		# build links
		my $ltrs = '\w';
		my $gunk = '/#~:.?+=&%@!\-}';
		my $punc = '.:?\-';
		$line =~ s{\b( (http|ftp|https) : [${ltrs}${gunk}${punc}] +?) (?= [$punc]* [^${ltrs}${gunk}${punc}] | $ )}{<a href="$1">$1</a>}igox;
                # build mailtos
		$line =~ s{(([a-z0-9_]|\-|\.)+@([^[:space:]&><]*)([[:alnum:]-]))}{<a href=\"mailto:$1\">$1</a>}igox;
	    }
	    
	    print $handle $line;
	}
    } elsif ($pdbv_type eq 'rpm') {
	# As we control raw info for RPM, no need
	# to s// for translation strings here.
	foreach my $line (@raw) {
	    # The following must be the same as the "non-dpkg specific"
	    # seen before.

	    # replace < > by html equivs 
	    $line =~ s/\<(.*)\>/\&lt\;\1\&gt\;/;
	    # line break by xhtml equivs       
	    $line =~ s/$/<br \/>/;
	    unless ($light) {
		# build links
		my $ltrs = '\w';
		my $gunk = '/#~:.?+=&%@!\-}';
		my $punc = '.:?\-';
		$line =~ s{\b( (http|ftp|https) : [${ltrs}${gunk}${punc}] +?)(?= [$punc]* [^${ltrs}${gunk}${punc}] | $ )}{<a href="$1">$1</a>}igox;
                # build mailtos
		$line =~ s{(([a-z0-9_]|\-|\.)+@([^[:space:]&><]*)([[:alnum:]-]))}{<a href=\"mailto:$1\">$1</a>}igox;
	    }
	    
	    print $handle $line;
	}
	print $handle "<font class=\"itemtitle\">";
	print $handle gettext("Requires:");
	print $handle "</font><br />";
	my @raw = split /^/, PdbvRequires($pack);
	foreach my $line (@raw) {
	    $line =~ s/$/<br \/>/;
	    print $handle $line;
	}
	print $handle "<font class=\"itemtitle\">";
	print $handle gettext("Priority:");
	print $handle "</font><br />";
	my @raw = split /^/, PdbvProvides($pack);
	foreach my $line (@raw) {
	    $line =~ s/$/<br \/>/;
	    print $handle $line;
	}
    } else {
	die gettext("$sname: Internal error: unable to understand what is the database type");
    }
    print $handle "<font class=\"itemtitle\">";
    print $handle gettext("Files:");
    print $handle "</font><br />";
    my @raw = split /^/, PdbvList($pack);
    foreach my $line (@raw) {
	$line =~ s/$/<br \/>/;
	print $handle $line;
    }
    print $handle $ret;
    PdbvXhtmlPrintFooter($handle);
}

sub PdbvXhtmlPrintInfoFrame {    
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];

    PdbvXhtmlPrintHeader($handle, gettext("Infos"));
    PdbvSysinfoPrintDistro($handle);
    print $handle "<br />";
    PdbvSysinfoPrintUnameKernel($handle);
    print $handle "<br />";
    PdbvSysinfoPrintUnameCpu($handle);
    print $handle "<br />";
    PdbvSysinfoPrintFree($handle);
    print $handle "<br /><br />";
    print $handle sprintf(gettext("This is the output of %s version %s, running on %s. "), "<a href=\"$surl\">$sname</a>", $sver, hostname());
    print $handle sprintf(gettext("It was generated in %s."), PdbvExecutionTime());
    print $handle "<p>";
    print $handle gettext("Pdbv is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.");
    print $handle "</p><p>";
    print $handle gettext("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.")."<a href=\"http://www.gnu.org/licenses/gpl.html\">".gettext("See the GNU General Public License for more details.")."</a>";
    print $handle "</p>";
    PdbvXhtmlPrintFooter($handle);
}

sub PdbvXhtmlPrintIndexFrame {    
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];

    PdbvXhtmlPrintHeader($handle, "$pdbv_type\@".hostname(), 1);
    print $handle "<frameset framespacing=\"0\" border=\"false\" frameborder=\"0\" cols=\"35%,65%\">";
    if ($listing ne 'basic') {
	print $handle "      <frameset framespacing=\"0\" border=\"false\" frameborder=\"0\" rows=\"10%,90%\">"; 
	print $handle "          <frame name=\"listing\" src=\"listing.html\" scrolling=\"auto\" />";
	print $handle "          <frame name=\"list\" src=\"list.html\" scrolling=\"auto\" />";
	print $handle "      </frameset>";
    } else {
	print $handle "   <frame name=\"list\" src=\"list.html\" scrolling=\"auto\" />";
    }
    print $handle "  <frame name=\"package\" src=\"info.html\" scrolling=\"auto\" />";
    print $handle "</frameset>";
    print $handle "<body>";
    PdbvXhtmlPrintFooter($handle);
}

sub PdbvXhtmlPrintPackagePointer {    
    my $handle = STDOUT;
    $handle = $_[0] if $_[0];

    print $handle "<a href=\"".$package_info_baseurl."".PdbvBasename($_[1])."\">".PdbvBasename($_[1])."</a>";
}

sub PdbvXhtmlAddRequiredFiles {
    # Htaccess and css files must be there
    # It could be done in core.pl, but it really depends on the xhtml.

    # Set a pointer to .htaccess, normally empty by default
    unless (-e $working_dir."/.htaccess") {
	symlink($confdir."/htaccess", $working_dir."/.htaccess");
	print "$confdir/htaccess -> $working_dir/.htaccess\n" if $debug;
    }

    # Make sure the appropriate css is there
    unless (readlink($working_dir_css) eq $css) {
	symlink($css, $working_dir_css);
	print "$css -> $working_dir_css\n" if $debug;
    }    
}

# end
