/* 
 * This file is part of the PDF Split And Merge source code
 * Created on 29/ago/2014
 * Copyright 2013-2014 by Andrea Vacondio (andrea.vacondio@gmail.com).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.pdfsam.ui.dashboard.preference;

import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.pdfsam.support.KeyStringValueItem.keyValue;

import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.loadui.testfx.GuiTest;
import org.loadui.testfx.categories.TestFX;
import org.pdfsam.context.StringUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.support.KeyStringValueItem;

import javafx.scene.Parent;

/**
 * @author Andrea Vacondio
 *
 */
@Category(TestFX.class)
public class PreferenceComboBoxTest extends GuiTest {

    private UserContext userContext = mock(UserContext.class);

    @Override
    protected Parent getRootNode() {
        PreferenceComboBox<KeyStringValueItem<String>> victim = new PreferenceComboBox<>(StringUserPreference.LOCALE,
                userContext);
        victim.setId("victim");
        victim.getItems().addAll(keyValue("key1", "value1"), keyValue("key2", "value2"), keyValue("key3", "value3"));
        return victim;
    }

    @Test
    public void preferenceSetOnClick() {
        click("#victim").click("value2");
        verify(userContext).setStringPreference(eq(StringUserPreference.LOCALE), eq("key2"));
    }

}
