/***********************************************************************
 *
 * Copyright (C) 2010-2011 Innocent De Marchi <tangram.peces@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***********************************************************************/
#ifndef FRMPRINCIPAL_H
#define FRMPRINCIPAL_H

#include <QtGui>
#include <QTranslator>

#include "frmprincipal.h"
#include "tauler.h"
#include "rellotge.h"

class frmPrincipal : public QMainWindow
{
    Q_OBJECT

public:
    frmPrincipal();
    QFrame *jocFram;

    QTreeWidget *arbreModalitatsJocTreeWidget;
    //Llista amb el contingut de l'arxiu data.sol
    QList<QString> dadesArxiuData;

    QTreeWidget *arbreBuscaSolucioTreeWidget;
    //Tab
    QTabWidget *tabArbres;

    Tauler *taulerJoc;

    QUndoStack* movimentsUndoStack;

    Rellotge *rellotgeLabel;

    void llegeixArxiuData();
    void carregaArbreModalitatsJoc( );

   // int jocResolt;

    QStringList solucionaJocActual_movimentsEliminats;
    QStringList solucionaJocActual_movimentsJaRealitzats;
    QStringList solucionaJocActual_movimentsPosiblesActuals;
    QStringList solucioJocActual_configuracionsEliminades;
    QStringList solucioJocActual_configuracionsEliminadesPerDesar;
    QString solucioJocActual_configuracioInicial;
    QString solucionaJocActual_darrerMoviment;

    QStringList solucionsTrobades;

    QAction *iniciSolucioAction;

    int retrocedeixMoviment;


    void desaSolucions();
    //Desa la solució actual continguda a movimentsUndoStack
    void desaSolucions1();

    //Mostra les solucions del joc actual
    void veureSolucionsSlot();

    void comprovaArxiuSolucions();

    QString missatgeNumeroMoviments();

    //Visualitzador de solucions
    QTreeWidget *arbreSolucionsTreeWidget;
    //16/12/10  Eliminat
    //QDockWidget *solucionsDockWidget;

    //Mostra un missatge passat pel tauler del joc
    void mostraMissatge(int codi);


private slots:

    void closeEvent(QCloseEvent* event);

    //Gestiona la selecció de la modalitat de joc
    //void seleccioModalitatJoc(QTreeWidgetItem*, int);
    void seleccioModalitatJoc();

    QString movimentACoordenades(QString inici,QString final);
    QString coordenadesAMoviment(QString coordenades);

    void veureRecordsPersonals();
    void eliminaRecordsPersonals();

    void canviaIdioma(QAction *action);

    void creditsProgramaSlot();

    void ajudaSlot();

    void solucionaJocActual_Inicia();
    void solucionaJocActual_CarregaMovimentsInicialsArbre();
    void solucionaJocActual_comencaRecerca();
    void solucionaJocActual_eliminaMovimentsPosteriors();
    void solucionaJocActual_eliminaConfiguracionsPosteriors(QString config);
    //Aquesta funció no es fa servir
   // void solucionaJocActual_eliminaConfiguracions();

    void solucionaJocRapid();

    //Aquesta funció no es fa servir
   // void escriuArxiuSolucio();
    void desaConfiguracionsEliminades(int tipus=0);
    void carregaConfiguracionsEliminades();
    void eliminaArxiuConfgEliminades();

    void carregaSolucions();

    //Carrega al movimentsUndoStack la solució actual
    void carregaSolucio(QTreeWidgetItem*, int);

    void iniciSolucioSlot(int pmoviment=0);

    //Deixa el joc en pausa
    void pausaJocSlot();

    //Suggereix el següent moviment a l'usuari
    void sugereixMovimentSlot();

  //Ha passat a públic
  //  void iniciSolucioSlot();


private:

    void creaAcccions();
    void creaMenus();
    void creaIdiomaMenu();
    void creaBarraTasques();
    void tradueixGUI();

    QString nomArxiuJoc(int tipus);
    void comprovaDirectoriHome();

    void comprovaRegistre();



   //Accions del programa
    QAction *surtAction; //tanca el programa

    QAction *veureRecordsPersonalsAction;
    QAction *eliminaRecordsPersonalsAction;

    QAction *reiniciaJocActual;

    QAction *pausaAction;
    QAction *sugereixMovimentAction;

    QAction *undoAction;
    QAction *redoAction;

    QAction *ajudaAction;
    QAction *colaboraPrograma;
    QAction *creditsPrograma;

    QAction *solucionaJocActual;
    QAction *solucionaJocActualRapid;

   //Eliminada 16/12/10 Ara les solucions
  // es veuen directament en el Tab de les
  // modalitats de joc
   // QAction *veureSolucions;

    QTranslator *frm_qt_translator;
    QTranslator *frm_Translator;


    QMenu *aplicacioMenu;
    QMenu *movimentsMenu;
    QMenu *idiomaMenu;
       QActionGroup *idiomaActionGroup;

    QMenu *ajudaMenu;



    QToolBar *aplicacioToolBar;
    QToolBar *veureSolucionsToolBar;
    //rellotge per generar els nombre aleatoris
    QTime rellotgeQTime;

    protected:

      void resizeEvent ( QResizeEvent * event );


};

#endif // FRMPRINCIPAL_H
