#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#define MAXBUF 1024

int main(int argc, char **argv)
{
	int sk;
	struct sockaddr_in client, server;
	struct hostent *hp;
	char buf[MAXBUF];
	int n;

	if (argc < 3) {
		printf("Usage: %s server_ip server_port [my_ip]\n", argv[0]);
		exit(0);
	}

	if ((sk = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
		printf("Problem creating socket\n");
		exit(1);
	}

	if (argc > 3) {	/* set local address */
		hp = gethostbyname(argv[3]);
		if (hp == NULL) {
			fprintf(stderr, "Bogus local address %s\n", argv[3]);
			exit(1);
		}
		memcpy(&client.sin_addr.s_addr, hp->h_addr, hp->h_length);
		client.sin_port = 0;
		if (bind(sk, (struct sockaddr *)&client, sizeof client) < 0) {
			fprintf(stderr, "bind failure\n");
			exit(1);
		}
	}

	server.sin_family = AF_INET;
	hp = gethostbyname(argv[1]);
	if (hp == NULL) {
		fprintf(stderr, "Bogus server address %s\n", argv[1]);
		exit(1);
	}

	memcpy(&server.sin_addr.s_addr, hp->h_addr, hp->h_length);

	server.sin_port = htons(atoi(argv[2]));

	while (fgets(buf, sizeof buf, stdin)) {
		n = sendto(sk, buf, strlen(buf), 0,
			(struct sockaddr *) &server, sizeof server);

		if (n < 0) {
			perror("Problem sending data");
		}
	}

	return 0;
}
