/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : avienv.c 
 * date    : 2000-06-20
 * modify  : 2001-12-13 by elcomski
 * 
 */   
/* ----------------------------------------------- */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <arpa/inet.h>

#include "avienv.h"



/*----------------------------------------- */
/* Constant definitions */
/*----------------------------------------- */
#define STR_MAX_LINE 1000


/*----------------------------------------- */
/* Variable definitions */
/*----------------------------------------- */
FILE *g_fn = NULL;
long int g_secpoint = 0; 
char *g_strlist[STR_MAX_LINE];
int g_icount = 0;
int g_modify_flag = 0;


/*----------------------------------------- */
/* Function definitions */
/*----------------------------------------- */
/*
 * Func : ef_read_env_file
 * Context :
 * 
*/  
int ef_read_env_file(char *strname)
{
	FILE *fn;
	size_t iret_t,ilen_t;
	char **lineptr;
	char *lineptr2;

	fn = fopen(strname,"r");
	if(fn == NULL) return -1;

	while(1){
		lineptr = &lineptr2;
		lineptr2 = NULL;
		iret_t = getline(lineptr, &ilen_t, fn);
		if(iret_t  < 0 || feof(fn)) break;

		g_strlist[g_icount] = *lineptr;	
		g_icount++;
	};
	fclose(fn);

	return 0;
}


/*
 * Func : ef_save_env_file
 * Context :
 * 
*/  
int ef_save_env_file(char *strname)
{
	FILE *fn;
	int i;

	if(g_modify_flag){
		fn = fopen(strname,"w+");
		if(fn == NULL) return -1;

		for(i=0;i<g_icount;i++){
			fputs(g_strlist[i],fn);
			free(g_strlist[i]);
		}		
		return fclose(fn);
	}
	return 0;
}


/*
 * Func : ef_free_env_file
 * Context :
 * 
*/  
int ef_free_env_file( void )
{
	int i;

	for(i=0;i<g_icount;i++){
		free(g_strlist[i]);
	}		
	return 0;
}



/*
 * Func : find_item
 * Context :
 * 	-3   error 
 * 	-2   no section no item 
 * 	-1   be section but no item 
 * 	0   all success
*/  
int find_item(char *section,char *item,char *strdata,int *ipoint)
{
    	int iret;
	char sbuf[256];
	int i,j;
	int ilen;

	sprintf(sbuf,"[%s]",section);
	ilen = strlen(sbuf);
	for(i=0;i<g_icount;i++){
	    iret = strncmp(sbuf,g_strlist[i],ilen);
	    if(iret == 0) break;
	}
		
	if(i >= g_icount) return -2;
	
	*ipoint = i;
	j = i + 1;
	while(j < g_icount){
	    	if(g_strlist[j][0] == '['){
		    *ipoint = j - 1;
		    return -1;
		}
	 	iret = sscanf(g_strlist[j],"%[^=]=%s",sbuf,strdata);
		if(iret == 1 || iret == 2){
			if((strcmp(sbuf,item) == 0)){
		    		*ipoint = j;
		    		return 0;
			}
		}
		j++;	
	};
	*ipoint = j - 1;
	return -1;	
    		
}


/*
 * Func : ef_get_string
 * Context :
 * 
*/  
int ef_get_string(char *section,char *item,char *strdata,char *strdef)
{
    	int iret;
	int ipoint;

	iret = find_item(section,item,strdata,&ipoint);
	if(iret < 0) memcpy(strdata,strdef,strlen(strdef)+1);
	return iret;
}


/*
 * Func : ef_set_string
 * Context :
 * 
*/  
int ef_set_string(char *section,char *item,char *strdata)
{
    	int iret,i;
	char *pstr,*pstr2;
	char strbuf[256];
	int ipoint,ilen;
	
	iret = find_item(section,item,strbuf,&ipoint);

	//check error	
	if(iret < -2) return iret;
	else if(iret == -2){
		sprintf(strbuf,"[%s]\n",section);
		ilen = strlen(strbuf);
		pstr = (char*)malloc(ilen+2);
		if(pstr == NULL) return -1;
		memcpy(pstr,strbuf,ilen+1);

		g_strlist[g_icount] = pstr;
		g_icount++;

		sprintf(strbuf,"%s=%s\n",item,strdata);
		ilen = strlen(strbuf);
		pstr = (char*)malloc(ilen+2);
		if(pstr == NULL) return -1;
		memcpy(pstr,strbuf,ilen+1);

		g_strlist[g_icount] = pstr;
		g_icount++;
	}else if(iret == -1){
		sprintf(strbuf,"%s=%s\n",item,strdata);
		ilen = strlen(strbuf);
		pstr = (char*)malloc(ilen+2);
		if(pstr == NULL) return -1;
		memcpy(pstr,strbuf,ilen+1);

		for(i=ipoint+1;i<g_icount+1;i++){
			pstr2 = g_strlist[i];
			g_strlist[i] = pstr;
			pstr = pstr2;
		}
		g_icount++;
	}else{
		free(g_strlist[ipoint]);
		sprintf(strbuf,"%s=%s\n",item,strdata);
		ilen = strlen(strbuf);
		pstr = (char*)malloc(ilen+2);
		if(pstr == NULL) return -1;
		memcpy(pstr,strbuf,ilen+1);
		g_strlist[ipoint] = pstr;    
	}

	g_modify_flag++;
	return 0;
    		
}


/*
 * Func : ef_get_if
 * Context :
 * 
*/  
int ef_get_int(char *section,char *item,int *ivalue,int idef)
{
    	int iret;
	char strdata[256];
	char sbuf[256];
	
	sprintf(sbuf,"%d",idef);
	iret = ef_get_string(section,item,strdata,sbuf);
	
	*ivalue = atoi(strdata);
	
	return iret;
	
}


/*
 * Func : ef_set_int
 * Context :
 * 
*/  
int ef_set_int(char *strsection,char *stritem,int idata)
{
    	int iret;
	char strdata[256];

	sprintf(strdata,"%d",idata);
	iret = ef_set_string(strsection,stritem,strdata);
	
	return iret;
    		
}


/*
 * Func : ef_get_double
 * Context :
 * 
*/  
int ef_get_double(char *section,char *item,double *ivalue,double idef)
{
	int iret;
	char strdata[256];
	char sbuf[256];

	sprintf(sbuf,"%d",(int)idef);
	iret = ef_get_string(section,item,strdata,sbuf);

	*ivalue = atof(strdata);

	return iret;
	
}


/*
 * Func : ef_set_double
 * Context :
 * 
*/  
int ef_set_double(char *strsection,char *stritem,double fdata)
{
    	int iret;
	char strdata[256];

	sprintf(strdata,"%f",fdata);
	iret = ef_set_string(strsection,stritem,strdata);
	
	return iret;
    		
}
