/*****************************************************************************/
/*                                                                           */
/* nim.h - this file contains application interface function                 */
/*            prototypes                                                     */
/*                                                                           */
/* 1998. 7. 15. H. D. Sung                                                   */
/*****************************************************************************/

#ifndef __NIM_DRV_H__
#define __NIM_DRV_H__

#if 0 /* both-support */
#if 0 /* if you want HDM_8513 , set to 1 */
#define HDM_8513_
#else
#define HDM_8513A_
#endif
#endif /* End of both-support */

#define ZIF_
#define DEBUG_

//#ifdef __cplusplus
//extern "C" {
//#endif

#ifndef EXPORT
#define EXPORT  
//#define DLLEXPORT __declspec(dllexport) 
#endif

#include "nim_drvd.h"

/* external function prototypes */
EXPORT boolean /*WINAPI*/ nim_initialize( achar *dev_name );
EXPORT BOOL  /*WINAPI*/ nim_start( achar *dev_name, tuning_t *param );
EXPORT boolean /*WINAPI*/ nim_stop( achar *dev_name );
EXPORT boolean /*WINAPI*/ nim_monitor( tuning_t *stTuning );
EXPORT boolean /*WINAPI*/ nim_control( byte command, byte mode, byte *param );
EXPORT boolean /*WINAPI*/ nim_get_lock_status( achar *dev_name, byte qpsk_addr, tuner_lock_t *enTlock, qpsk_lock_t *enQlock );
EXPORT boolean /*WINAPI*/ nim_get_register( achar *dev_name, word wOffset, byte *pbValReg, word wSize );
EXPORT double /*WINAPI*/ nim_get_quality( achar *dev_name, byte qpsk_addr, byte mode );
EXPORT void /*WINAPI*/ nim_set_values( byte qpsk_addr );
EXPORT boolean  nim_get_qpsk_lock_status( achar *dev_name, byte qpsk_addr, qpsk_lock_t *enQlock );


//#ifdef __cplusplus
//}
//#endif


#endif

/* EOF */
