/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski
 * file    : pentadrv.h 
 * date    : 2000-03-15
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#ifndef _PENTADRV_H_
#define _PENTADRV_H_


/*--------------------------------*/
/* Structure definitions */
/*--------------------------------*/
/*
 * This structure is private to each device. It is used to pass
 * packets in and out, so there is place for a packet
 */
struct pentanet_private {
	struct pci_dev *pci_dev;
	/* PCI address */
	void *mmio0_addr;
	void *mmio0_vaddr;
	void *mmio2_addr;
	void *mmio2_vaddr;
	int irq_line;
	spinlock_t lock;
	struct timer_list timer;

	struct net_device *route_dev;
	struct net_device_stats stats;

	int status;
	int interrupt_status;

	struct tq_struct short_task;
	int short_bh_count;
	int interrupt_count;
	int bh_count;
	unsigned int timer_count;

	unsigned char mac_addr[6];
	unsigned long old_data;

	int index;
};

#endif /* _PENTADRV_H_ */
