
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 1 "src/parser.y"

/*
 * Permafrost - Physical modelling framework
 *
 * Copyright (C) 2009, 2010  Stefano D'Angelo  <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "src/types.h"
#include "src/util.h"
#include "src/list.h"
#include "src/expr.h"
#include "src/parser.tab.h"
#include "src/scanner.h"
#include "src/parser.h"

void
yyerror(YYLTYPE *locp, yyscan_t scanner, const char *filename, char *str)
{
	fprintf(stderr, "%s:%d:%d: error: %s\n", filename, locp->first_line,
		locp->first_column, str);
}

/* Comparison functions */

static int
port_cmp_id(void *p, void *id)
{
	return strcmp(((struct port *)p)->id, (char *)id);
}

static int
conn_elem_cmp(void *e1, void *e2)
{
	struct conn_elem *elem1;
	struct conn_elem *elem2;
	int i;

	elem1 = (struct conn_elem *)e1;
	elem2 = (struct conn_elem *)e2;

	if (elem1->type > elem2->type)
		return 1;
	if (elem1->type < elem2->type)
		return -1;

	if (elem1->type == conn_elem_type_value)
		return 0;

	if ((elem1->c.id.component == NULL) && (elem2->c.id.component != NULL))
		return -1;
	if ((elem1->c.id.component != NULL) && (elem2->c.id.component == NULL))
		return 1;

	if (elem1->c.id.component != NULL)
	  {
		i = strcmp(elem1->c.id.component, elem2->c.id.component);
		if (i != 0)
			return i;
	  }

	return strcmp(elem1->c.id.port, elem2->c.id.port);
}

static int
connection_cmp(void *c1, void *c2)
{
	struct connection *conn1;
	struct connection *conn2;
	int i;

	conn1 = (struct connection *)c1;
	conn2 = (struct connection *)c2;

	i = conn_elem_cmp(&conn1->output, &conn2->output);

	return (i != 0) ? i : conn_elem_cmp(&conn1->input, &conn2->input);
}

static int
component_cmp_id(void *c, void *id)
{
	return strcmp(((struct component *)c)->id, (char *)id);
}

static int
stmt_cmp_output(void *s1, void *s2)
{
	struct stmt *stmt1;
	struct stmt *stmt2;
	int i;

	stmt1 = (struct stmt *)s1;
	stmt2 = (struct stmt *)s2;

	i = strcmp(stmt1->out.id.id, stmt2->out.id.id);
	if (i != 0)
		return i;

	return stmt1->out.id.out ? (stmt2->out.id.out ? 0 : 1)
				 : (stmt2->out.id.out ? -1 : 0);
}

static int
const_cmp_id(void *c, void *id)
{
	return strcmp(((struct const_v *)c)->id, (char *)id);
}

static int
ext_func_cmp_id(void *f, void *id)
{
	return strcmp(((struct ext_func *)f)->id, (char *)id);
}

static int
block_cmp_id(void *b, void *id)
{
	return strcmp(((struct block *)b)->id, (char *)id);
}

static int
system_cmp_id(void *s, void *id)
{
	return strcmp(((struct system *)s)->id, (char *)id);
}

static int
component_cmp_ports_id(void *c, void *p)
{
	struct component *comp;
	list_t ports;

	comp = (struct component *)c;
	ports = (list_t)p;

	if (list_find(ports, port_cmp_id, comp->id) != NULL)
		return 0;

	return 1;
}

/* Utility functions */

struct stmt_defines_port_output_context
  {
	const char	*filename;
	YYLTYPE		*locp;
	struct port	*port;
	char		 defined;
  };

static void
stmt_defines_port_output(void *data, void *context)
{
	struct stmt *stmt;
	struct stmt_defines_port_output_context *ctx;

	stmt = (struct stmt *)data;
	ctx = (struct stmt_defines_port_output_context *)context;

	if (ctx->defined)
		return;

	if (!strcmp(stmt->out.id.id, ctx->port->id))
	  {
		if (stmt->out.id.out && (ctx->port->type != port_type_w)
		    && (ctx->port->type != port_type_k))
		  {
			fprintf(stderr, "%s:%d:%d: error: port `%s' is not a "
				"physical port\n", ctx->filename,
				ctx->locp->first_line, ctx->locp->first_column,
				stmt->out.id.id);
			exit(EXIT_FAILURE);
		  }
		else if (!stmt->out.id.out
			 && (ctx->port->type != port_type_input)
		         && (ctx->port->type != port_type_output))
		  {
			fprintf(stderr, "%s:%d:%d: error: port `%s' is a "
				"physical port\n", ctx->filename,
				ctx->locp->first_line, ctx->locp->first_column,
				stmt->out.id.id);
			exit(EXIT_FAILURE);
		  }

		ctx->defined = 1;
	  }
}

struct port_output_defined_context
  {
	const char	*filename;
	YYLTYPE		*locp;
	list_t		 stmts;
  };

static void
port_output_defined(void *data, void *context)
{
	struct port *port;
	struct port_output_defined_context *ctx;
	struct stmt_defines_port_output_context s_ctx;

	port = (struct port *)data;
	ctx = (struct port_output_defined_context *)context;

	if (port->type == port_type_input)
		return;

	s_ctx.filename = ctx->filename;
	s_ctx.locp = ctx->locp;
	s_ctx.port = port;
	s_ctx.defined = 0;
	list_for_each(ctx->stmts, stmt_defines_port_output, &s_ctx);

	if (!s_ctx.defined)
	  {
		fprintf(stderr, "%s:%d:%d: error: the output of port `%s' was "
			"not defined\n", ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, port->id);
		exit(EXIT_FAILURE);
	  }
}

struct stmt_bind_context
  {
	const char	*filename;
	YYLTYPE		*locp;
	list_t		 ports;
  };

static void
stmt_bind(void *data, void *context)
{
	struct stmt *stmt;
	struct stmt_bind_context *ctx;
	struct port *port;
	struct expr_signal_id *id;
	struct ext_func *f;
	char *s;

	stmt = (struct stmt *)data;
	ctx = (struct stmt_bind_context *)context;

	port = list_find(ctx->ports, port_cmp_id, stmt->out.id.id);
	if (port == NULL)
	  {
		fprintf(stderr, "%s:%d:%d: error: unknown port `%s'\n",
			ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, stmt->out.id.id);
		exit(EXIT_FAILURE);
	  }

	if (stmt->out.id.out && (port->type != port_type_w)
	    && (port->type != port_type_k))
	  {
		fprintf(stderr, "%s:%d:%d: error: port `%s' is not a physical "
			"port\n", ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, stmt->out.id.id);
		exit(EXIT_FAILURE);
	  }
	else if (!stmt->out.id.out && (port->type != port_type_input)
		 && (port->type != port_type_output))
	  {
		fprintf(stderr, "%s:%d:%d: error: port `%s' is a physical "
			"port\n", ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, stmt->out.id.id);
		exit(EXIT_FAILURE);
	  }

	stmt->out.port = port;

	id = expr_bind_to_ports(stmt->expr, ctx->ports);
	if (id != NULL)
	  {
		if (id->in)
			fprintf(stderr, "%s:%d:%d: error: port `%s' is not a "
				"physical port\n", ctx->filename,
				ctx->locp->first_line, ctx->locp->first_column,
				id->id);
		else
			fprintf(stderr, "%s:%d:%d: error: port `%s' is a "
				"physical port\n", ctx->filename,
				ctx->locp->first_line, ctx->locp->first_column,
				id->id);
		exit(EXIT_FAILURE);
	  }

	expr_bind_consts(stmt->expr, parser_consts);

	id = expr_find_unbinded(stmt->expr);
	if (id != NULL)
	  {
		fprintf(stderr, "%s:%d:%d: error: unknown port `%s'\n",
			ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, id->id);
		exit(EXIT_FAILURE);
	  }

	s = expr_bind_ext_funcs(stmt->expr, parser_ext_funcs);
	if (s != NULL)
	  {
		fprintf(stderr, "%s:%d:%d: error: unknown function `%s'\n",
			ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, s);
		exit(EXIT_FAILURE);
	  }

	f = expr_check_ext_func_args(stmt->expr);
	if (f != NULL)
	  {
		fprintf(stderr, "%s:%d:%d: error: function `%s' takes %lu "
			"arguments\n", ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, f->id, f->n_args);
		exit(EXIT_FAILURE);
	  }
}

struct component_bind_type_context
  {
	const char	*filename;
	YYLTYPE		*locp;
  };

static void
component_bind_type(void *data, void *context)
{
	struct component *comp;
	struct component_bind_type_context *ctx;
	void *p;

	comp = (struct component *)data;
	ctx = (struct component_bind_type_context *)context;

	p = list_find(parser_blocks, block_cmp_id, comp->type.id);
	if (p != NULL)
	  {
		free(comp->type.id);
		comp->type.t.is_macro = 0;
		comp->type.t.p = p;
		return;
	  }

	p = list_find(parser_macros, system_cmp_id, comp->type.id);
	if (p != NULL)
	  {
		free(comp->type.id);
		comp->type.t.is_macro = 1;
		comp->type.t.p = p;
		return;
	  }

	fprintf(stderr, "%s:%d:%d: error: unknown component type `%s'\n",
		ctx->filename, ctx->locp->first_line, ctx->locp->first_column,
		comp->type.id);
	exit(EXIT_FAILURE);
}

static void
conn_elem_bind(struct conn_elem *elem, list_t components, list_t ports,
	       const char *filename, YYLTYPE *locp)
{
	struct component *comp;
	struct port *port;
	struct const_v *const_v;

	if (elem->type == conn_elem_type_value)
		return;

	if (elem->c.id.component != NULL)
	  {
		comp = list_find(components, component_cmp_id,
				 elem->c.id.component);
		if (comp == NULL)
		  {
			fprintf(stderr, "%s:%d:%d: error: unknown component "
				"`%s'\n", filename, locp->first_line,
				locp->first_column, elem->c.id.component);
			exit(EXIT_FAILURE);
		  }

		port = list_find(comp->type.t.is_macro
				 ? ((struct system *)comp->type.t.p)->ports
				 : ((struct block *)comp->type.t.p)->ports,
				 port_cmp_id, elem->c.id.port);
		if (port == NULL)
		  {
			fprintf(stderr, "%s:%d:%d: error: component `%s' does "
				"not have a port named `%s'\n", filename,
				locp->first_line, locp->first_column,
				elem->c.id.component, elem->c.id.port);
			exit(EXIT_FAILURE);
		  }

		free(elem->c.id.component);
		free(elem->c.id.port);
		elem->c.p.component = comp;
		elem->c.p.port = port;
	  }
	else
	  {
		port = list_find(ports, port_cmp_id, elem->c.id.port);
		if (port == NULL)
		  {
			const_v = list_find(parser_consts, const_cmp_id,
					    elem->c.id.port);
			if (const_v == NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: unknown port "
					"`%s'\n", filename, locp->first_line,
					locp->first_column, elem->c.id.port);
				exit(EXIT_FAILURE);
			  }

			free(elem->c.id.port);
			elem->c.value = const_v->value;
			elem->type = conn_elem_type_value;
			return;
		  }

		free(elem->c.id.port);
		elem->c.p.component = NULL;
		elem->c.p.port = port;
	  }

	if ((elem->type != conn_elem_type_port)
	    && (elem->c.p.port->type != port_type_w)
	    && (elem->c.p.port->type != port_type_k))
	  {
		fprintf(stderr, "%s:%d:%d: error: port `%s%s%s' is not a "
			"physical port\n", filename, locp->first_line,
			locp->first_column,
			(elem->c.p.component != NULL) ? elem->c.p.component->id
			: "", (elem->c.p.component != NULL) ? "." : "",
			elem->c.p.port->id);
		exit(EXIT_FAILURE);
	  }
}

struct connection_bind_context
  {
	const char	*filename;
	YYLTYPE		*locp;
	list_t		 ports;
	list_t		 components;
  };

#define CONN_ELEM_IS_W(elem) \
	(((elem).type == conn_elem_type_port) \
	 && ((elem).c.p.port->type == port_type_w))

#define CONN_ELEM_IS_K(elem) \
	(((elem).type == conn_elem_type_port) \
	 && ((elem).c.p.port->type == port_type_k))

#define CONN_ELEM_IS_PHYS(elem)	(CONN_ELEM_IS_W(elem) || CONN_ELEM_IS_K(elem))

static void
connection_bind(void *data, void *context)
{
	struct connection *conn;
	struct connection_bind_context *ctx;

	conn = (struct connection *)data;
	ctx = (struct connection_bind_context *)context;

	conn_elem_bind(&conn->output, ctx->components, ctx->ports,
		       ctx->filename, ctx->locp);

	if (((conn->output.c.p.component == NULL)
	     && (conn->output.c.p.port->type == port_type_input))
	    || ((conn->output.c.p.component != NULL)
	        && (conn->output.c.p.port->type == port_type_output)))
	  {
		fprintf(stderr, "%s:%d:%d: error: invalid connection\n",
			ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column);
		exit(EXIT_FAILURE);
	  }

	if (conn->input.type == conn_elem_type_value)
	  {
		if (CONN_ELEM_IS_PHYS(conn->output))
		  {
			fprintf(stderr, "%s:%d:%d: error: cannot assign a "
				"value to a physical port\n", ctx->filename,
				ctx->locp->first_line, ctx->locp->first_column);
			exit(EXIT_FAILURE);
		  }
		return;
	  }

	conn_elem_bind(&conn->input, ctx->components, ctx->ports, ctx->filename,
		       ctx->locp);

	if (conn->input.type == conn_elem_type_value)
	  {
		if (CONN_ELEM_IS_PHYS(conn->output))
		  {
			fprintf(stderr, "%s:%d:%d: error: cannot assign a "
				"value to a physical port\n", ctx->filename,
				ctx->locp->first_line, ctx->locp->first_column);
			exit(EXIT_FAILURE);
		  }
		return;
	  }

	if (((conn->input.c.p.component != NULL)
	     && (conn->input.c.p.port->type == port_type_input))
	    || ((conn->input.c.p.component == NULL)
	        && (conn->input.c.p.port->type == port_type_output))
	    || (CONN_ELEM_IS_W(conn->input) && !CONN_ELEM_IS_W(conn->output))
	    || (!CONN_ELEM_IS_W(conn->input) && CONN_ELEM_IS_W(conn->output))
	    || (CONN_ELEM_IS_K(conn->input) && !CONN_ELEM_IS_K(conn->output))
	    || (!CONN_ELEM_IS_K(conn->input) && CONN_ELEM_IS_K(conn->output)))
	  {
		fprintf(stderr, "%s:%d:%d: error: invalid connection\n",
			ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column);
		exit(EXIT_FAILURE);
	  }

	if (conn->input.c.p.port == conn->output.c.p.port)
	  {
		fprintf(stderr, "%s:%d:%d: error: self connection\n",
			ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column);
		exit(EXIT_FAILURE);
	  }
}

struct connection_defines_port_context
  {
	const char		*filename;
	YYLTYPE			*locp;
	struct component	*comp;
	struct port		*port;
	char			 defined;
  };

static void
connection_defines_port(void *data, void *context)
{
	struct connection *conn;
	struct connection_defines_port_context *ctx;
	char defined;

	conn = (struct connection *)data;
	ctx = (struct connection_defines_port_context *)context;

	defined = ((conn->output.c.p.port == ctx->port)
		   && (conn->output.c.p.component == ctx->comp));
	if (((ctx->port->type == port_type_w)
	     || (ctx->port->type == port_type_k))
	    && (conn->input.type == conn_elem_type_port))
		defined = defined
			  || ((conn->input.c.p.port == ctx->port)
			      && (conn->input.c.p.component == ctx->comp));

	if (!defined)
		return;

	if (ctx->defined)
	  {
		fprintf(stderr, "%s:%d:%d: error: port `%s%s%s' is connected "
			"more than once\n", ctx->filename,
			ctx->locp->first_line, ctx->locp->first_column,
			(ctx->comp != NULL) ? ctx->comp->id : "",
			(ctx->comp != NULL) ? "." : "", ctx->port->id);
		exit(EXIT_FAILURE);
	  }

	ctx->defined = 1;
}

struct output_port_defined_context
  {
	const char	*filename;
	YYLTYPE		*locp;
	list_t		 connections;
  };

static void
output_port_defined(void *data, void *context)
{
	struct port *port;
	struct output_port_defined_context *ctx;
	struct connection_defines_port_context c_ctx;

	port = (struct port *)data;
	ctx = (struct output_port_defined_context *)context;

	if (port->type == port_type_input)
		return;

	c_ctx.filename = ctx->filename;
	c_ctx.locp = ctx->locp;
	c_ctx.comp = NULL;
	c_ctx.port = port;
	c_ctx.defined = 0;
	list_for_each(ctx->connections, connection_defines_port, &c_ctx);

	if (!c_ctx.defined)
	  {
		fprintf(stderr, "%s:%d:%d: error: the output of port `%s' was "
			"not defined\n", ctx->filename, ctx->locp->first_line,
			ctx->locp->first_column, port->id);
		exit(EXIT_FAILURE);
	  }
}

struct component_single_conn_context
  {
	const char		*filename;
	YYLTYPE			*locp;
	struct component	*comp;
	list_t			 connections;
  };

static void
port_single_conn(void *data, void *context)
{
	struct port *port;
	struct component_single_conn_context *ctx;
	struct connection_defines_port_context c_ctx;

	port = (struct port *)data;
	ctx = (struct component_single_conn_context *)context;

	if (port->type == port_type_output)
		return;

	c_ctx.filename = ctx->filename;
	c_ctx.locp = ctx->locp;
	c_ctx.comp = ctx->comp;
	c_ctx.port = port;
	c_ctx.defined = 0;
	list_for_each(ctx->connections, connection_defines_port, &c_ctx);	
}

static void
component_single_conn(void *data, void *context)
{
	struct component *comp;
	struct component_single_conn_context *ctx;

	comp = (struct component *)data;
	ctx = (struct component_single_conn_context *)context;

	ctx->comp = comp;

	list_for_each(comp->type.t.is_macro
		      ? ((struct system *)comp->type.t.p)->ports
		      : ((struct block *)comp->type.t.p)->ports,
		      port_single_conn, ctx);
}

static void
system_bind(struct system *system, list_t ports, list_t components,
	    list_t connections, const char *filename, YYLTYPE *locp)
{
	struct component *comp;
	struct component_bind_type_context c_ctx;
	struct connection_bind_context cb_ctx;
	struct output_port_defined_context o_ctx;
	struct component_single_conn_context s_ctx;

	system->ports = ports;
	system->components = components;
	system->connections = connections;

	/* ports and components to have different ids */
	comp = list_find(components, component_cmp_ports_id, ports);
	if (comp != NULL)
	  {
		fprintf(stderr, "%s:%d:%d: error: id `%s' was already used for "
			"a port\n", filename, locp->first_line,
			locp->first_column, comp->id);
		exit(EXIT_FAILURE);
	  }

	/* bind component types */
	c_ctx.filename = filename;
	c_ctx.locp = locp;
	list_for_each(components, component_bind_type, &c_ctx);

	/* bind connections */
	cb_ctx.filename = filename;
	cb_ctx.locp = locp;
	cb_ctx.ports = ports;
	cb_ctx.components = components;
	list_for_each(connections, connection_bind, &cb_ctx);

	/* all external outputs/external physical ports defined (once) */
	o_ctx.filename = filename;
	o_ctx.locp = locp;
	o_ctx.connections = connections;
	list_for_each(ports, output_port_defined, &o_ctx);

	/* 1 connection per internal input/physical port */
	s_ctx.filename = filename;
	s_ctx.locp = locp;
	s_ctx.comp = NULL;
	s_ctx.connections = connections;
	list_for_each(components, component_single_conn, &s_ctx);
}



/* Line 189 of yacc.c  */
#line 789 "src/parser.tab.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IMPORT = 258,
     CONST = 259,
     EXT_FUNCTION = 260,
     BLOCK = 261,
     MACRO = 262,
     SYSTEM = 263,
     SYNC = 264,
     ASYNC = 265,
     INPUT = 266,
     OUTPUT = 267,
     W_PORT = 268,
     K_PORT = 269,
     IN = 270,
     OUT = 271,
     SAMPLE_RATE = 272,
     SEMICOLON = 273,
     LBRACE = 274,
     RBRACE = 275,
     DOT = 276,
     COMA = 277,
     EQUALS = 278,
     LPAR = 279,
     RPAR = 280,
     LSBRACKET = 281,
     RSBRACKET = 282,
     ID = 283,
     STRING = 284,
     INTEGER = 285,
     FLOAT = 286,
     MINUS = 287,
     PLUS = 288,
     SLASH = 289,
     ASTERISK = 290,
     POS = 291,
     NEG = 292
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 716 "src/parser.y"

	unsigned long		 l;
	double			 val;
	char			*str;
	list_t			 list;
	struct const_v		 const_v;
	struct ext_func		 ext_func;
	struct block		 block;
	struct system		 system;
	struct stmt		 stmt;
	expr_t			 expr;
	struct component	 component;
	struct connection	 connection;
	struct conn_elem	 conn_elem;
	struct port		 port;
	enum port_type		 port_type;
	enum port_sync		 port_sync;



/* Line 214 of yacc.c  */
#line 883 "src/parser.tab.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 908 "src/parser.tab.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   194

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  38
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  30
/* YYNRULES -- Number of rules.  */
#define YYNRULES  71
/* YYNRULES -- Number of states.  */
#define YYNSTATES  147

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   292

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     6,     7,    10,    14,    15,    18,    21,
      24,    27,    30,    36,    50,    56,    59,    61,    64,    69,
      76,    78,    80,    82,    86,    91,    98,   105,   114,   119,
     123,   127,   131,   135,   138,   141,   145,   147,   151,   157,
     161,   167,   171,   172,   175,   179,   181,   184,   189,   191,
     195,   199,   203,   209,   215,   217,   219,   222,   226,   228,
     231,   236,   238,   240,   242,   244,   246,   248,   250,   253,
     256,   258
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      39,     0,    -1,    40,    42,    -1,    -1,    40,    41,    -1,
       3,    28,    18,    -1,    -1,    42,    43,    -1,    42,    44,
      -1,    42,    45,    -1,    42,    51,    -1,    42,    53,    -1,
       4,    28,    23,    66,    18,    -1,     5,    28,    23,    28,
      22,    28,    22,    30,    22,    29,    22,    29,    18,    -1,
       6,    28,    19,    46,    20,    -1,    60,    47,    -1,    48,
      -1,    47,    48,    -1,    28,    23,    49,    18,    -1,    28,
      21,    16,    23,    49,    18,    -1,    67,    -1,    17,    -1,
      28,    -1,    28,    21,    15,    -1,    28,    26,    49,    27,
      -1,    28,    21,    15,    26,    49,    27,    -1,    28,    26,
      49,    22,    49,    27,    -1,    28,    21,    15,    26,    49,
      22,    49,    27,    -1,    28,    24,    50,    25,    -1,    49,
      33,    49,    -1,    49,    32,    49,    -1,    49,    35,    49,
      -1,    49,    34,    49,    -1,    33,    49,    -1,    32,    49,
      -1,    24,    49,    25,    -1,    49,    -1,    50,    22,    49,
      -1,     7,    28,    19,    52,    20,    -1,    60,    55,    57,
      -1,     8,    28,    19,    54,    20,    -1,    62,    55,    57,
      -1,    -1,    55,    56,    -1,    28,    28,    18,    -1,    58,
      -1,    57,    58,    -1,    59,    23,    59,    18,    -1,    28,
      -1,    28,    21,    15,    -1,    28,    21,    16,    -1,    28,
      21,    28,    -1,    28,    21,    28,    21,    15,    -1,    28,
      21,    28,    21,    16,    -1,    66,    -1,    61,    -1,    60,
      61,    -1,    65,    28,    18,    -1,    63,    -1,    62,    63,
      -1,    64,    65,    28,    18,    -1,     9,    -1,    10,    -1,
      11,    -1,    12,    -1,    13,    -1,    14,    -1,    67,    -1,
      33,    67,    -1,    32,    67,    -1,    30,    -1,    31,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   783,   783,   785,   786,   788,   791,   792,   805,   818,
     831,   844,   859,   866,   887,   894,   917,   922,   938,   944,
     952,   956,   960,   964,   968,   972,   976,   980,   984,   988,
     993,   998,  1003,  1008,  1021,  1034,  1040,  1045,  1052,  1059,
    1066,  1073,  1081,  1084,  1099,  1106,  1111,  1125,  1152,  1158,
    1164,  1170,  1176,  1182,  1188,  1195,  1200,  1215,  1223,  1228,
    1243,  1259,  1260,  1263,  1264,  1265,  1266,  1269,  1270,  1271,
    1274,  1275
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IMPORT", "CONST", "EXT_FUNCTION",
  "BLOCK", "MACRO", "SYSTEM", "SYNC", "ASYNC", "INPUT", "OUTPUT", "W_PORT",
  "K_PORT", "IN", "OUT", "SAMPLE_RATE", "SEMICOLON", "LBRACE", "RBRACE",
  "DOT", "COMA", "EQUALS", "LPAR", "RPAR", "LSBRACKET", "RSBRACKET", "ID",
  "STRING", "INTEGER", "FLOAT", "MINUS", "PLUS", "SLASH", "ASTERISK",
  "POS", "NEG", "$accept", "file", "imports", "import", "defs", "const",
  "ext_func", "block", "block_code", "stmts", "stmt", "expr", "expr_list",
  "macro", "macro_code", "system", "system_code", "components",
  "component", "connections", "connection", "conn_elem", "ports", "port",
  "sys_ports", "sys_port", "sys_port_sync", "port_type", "sign_value",
  "value", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    38,    39,    40,    40,    41,    42,    42,    42,    42,
      42,    42,    43,    44,    45,    46,    47,    47,    48,    48,
      49,    49,    49,    49,    49,    49,    49,    49,    49,    49,
      49,    49,    49,    49,    49,    49,    50,    50,    51,    52,
      53,    54,    55,    55,    56,    57,    57,    58,    59,    59,
      59,    59,    59,    59,    59,    60,    60,    61,    62,    62,
      63,    64,    64,    65,    65,    65,    65,    66,    66,    66,
      67,    67
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     0,     2,     3,     0,     2,     2,     2,
       2,     2,     5,    13,     5,     2,     1,     2,     4,     6,
       1,     1,     1,     3,     4,     6,     6,     8,     4,     3,
       3,     3,     3,     2,     2,     3,     1,     3,     5,     3,
       5,     3,     0,     2,     3,     1,     2,     4,     1,     3,
       3,     3,     5,     5,     1,     1,     2,     3,     1,     2,
       4,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       3,     0,     6,     1,     0,     4,     2,     0,     0,     0,
       0,     0,     0,     7,     8,     9,    10,    11,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    70,
      71,     0,     0,     0,    67,     0,    63,    64,    65,    66,
       0,     0,    55,     0,     0,    42,    61,    62,     0,    42,
      58,     0,    69,    68,    12,     0,    14,     0,    15,    16,
      56,     0,    38,     0,    40,     0,    59,     0,     0,     0,
       0,    17,    57,    48,    43,    39,    45,     0,    54,    41,
       0,     0,     0,    21,     0,    22,     0,     0,     0,    20,
       0,     0,    48,    46,     0,    60,     0,     0,     0,     0,
       0,     0,    34,    33,    18,     0,     0,     0,     0,    49,
      50,    51,    44,     0,     0,     0,    35,    23,    36,     0,
       0,    30,    29,    32,    31,     0,    47,     0,    19,     0,
       0,    28,     0,    24,    52,    53,     0,     0,    37,     0,
       0,     0,    25,    26,    13,     0,    27
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     1,     2,     5,     6,    13,    14,    15,    40,    58,
      59,    88,   119,    16,    44,    17,    48,    63,    74,    75,
      76,    77,    41,    42,    49,    50,    51,    43,    78,    89
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -84
static const yytype_int16 yypact[] =
{
     -84,     5,    12,   -84,    -7,   -84,   114,    13,    20,    28,
      32,    43,    73,   -84,   -84,   -84,   -84,   -84,   -84,    84,
      93,   104,   115,   116,    47,   108,    81,    81,    44,   -84,
     -84,    83,    83,   119,   -84,   118,   -84,   -84,   -84,   -84,
     121,    -2,   -84,   110,   122,    81,   -84,   -84,   123,    44,
     -84,    81,   -84,   -84,   -84,   111,   -84,    17,   120,   -84,
     -84,   126,   -84,    72,   -84,    72,   -84,   124,   125,   129,
      33,   -84,   -84,    31,   -84,    78,   -84,   127,   -84,    78,
     128,   130,   131,   -84,    33,    91,    33,    33,    -5,   -84,
      53,   133,   132,   -84,    78,   -84,   134,    33,    51,   140,
      33,    33,   -84,   -84,   -84,    33,    33,    33,    33,   -84,
     -84,   136,   -84,   141,   135,     1,   -84,   137,    92,   106,
      10,    95,    95,   -84,   -84,   117,   -84,   139,   -84,    33,
      33,   -84,    33,   -84,   -84,   -84,   138,    40,    92,    55,
     144,    33,   -84,   -84,   -84,    64,   -84
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -84,   -84,   -84,   -84,   -84,   -84,   -84,   -84,   -84,   -84,
     100,   -83,   -84,   -84,   -84,   -84,   -84,   142,   -84,   101,
     -73,    71,   143,   -25,   -84,   145,   -84,    98,   147,   -24
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint8 yytable[] =
{
      34,    98,    93,   102,   103,     3,    93,    52,    53,    36,
      37,    38,    39,   104,   115,     4,    60,   118,   120,   128,
      60,     7,   121,   122,   123,   124,    57,   105,   106,   107,
     108,    18,   132,   105,   106,   107,   108,   133,    69,    34,
      70,    34,   105,   106,   107,   108,   137,   138,    19,   139,
      83,    34,    90,    46,    47,    34,    20,    84,   145,    91,
      21,    85,   141,    29,    30,    86,    87,   142,   109,   110,
      34,    22,   105,   106,   107,   108,   116,    29,    30,    31,
      32,   111,   143,   105,   106,   107,   108,   105,   106,   107,
     108,   146,    36,    37,    38,    39,   105,   106,   107,   108,
      73,    23,    29,    30,    31,    32,    92,    24,    29,    30,
      31,    32,    99,    29,    30,   100,    25,   101,     8,     9,
      10,    11,    12,    26,   105,   106,   107,   108,   130,   107,
     108,   131,   134,   135,    27,    28,    35,    54,    61,    68,
      55,    56,    62,    64,    72,    82,    95,    81,    57,    67,
      94,   112,    80,    90,    97,   117,   114,   125,    71,   126,
      96,   136,   144,   129,   127,   113,    79,   140,     0,     0,
      45,    33,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    65,     0,     0,    66
};

static const yytype_int16 yycheck[] =
{
      24,    84,    75,    86,    87,     0,    79,    31,    32,    11,
      12,    13,    14,    18,    97,     3,    41,   100,   101,    18,
      45,    28,   105,   106,   107,   108,    28,    32,    33,    34,
      35,    18,    22,    32,    33,    34,    35,    27,    21,    63,
      23,    65,    32,    33,    34,    35,   129,   130,    28,   132,
      17,    75,    21,     9,    10,    79,    28,    24,   141,    28,
      28,    28,    22,    30,    31,    32,    33,    27,    15,    16,
      94,    28,    32,    33,    34,    35,    25,    30,    31,    32,
      33,    28,    27,    32,    33,    34,    35,    32,    33,    34,
      35,    27,    11,    12,    13,    14,    32,    33,    34,    35,
      28,    28,    30,    31,    32,    33,    28,    23,    30,    31,
      32,    33,    21,    30,    31,    24,    23,    26,     4,     5,
       6,     7,     8,    19,    32,    33,    34,    35,    22,    34,
      35,    25,    15,    16,    19,    19,    28,    18,    28,    28,
      22,    20,    20,    20,    18,    16,    18,    22,    28,    51,
      23,    18,    28,    21,    23,    15,    22,    21,    58,    18,
      30,    22,    18,    26,    29,    94,    65,    29,    -1,    -1,
      27,    24,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    -1,    49
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    39,    40,     0,     3,    41,    42,    28,     4,     5,
       6,     7,     8,    43,    44,    45,    51,    53,    18,    28,
      28,    28,    28,    28,    23,    23,    19,    19,    19,    30,
      31,    32,    33,    66,    67,    28,    11,    12,    13,    14,
      46,    60,    61,    65,    52,    60,     9,    10,    54,    62,
      63,    64,    67,    67,    18,    22,    20,    28,    47,    48,
      61,    28,    20,    55,    20,    55,    63,    65,    28,    21,
      23,    48,    18,    28,    56,    57,    58,    59,    66,    57,
      28,    22,    16,    17,    24,    28,    32,    33,    49,    67,
      21,    28,    28,    58,    23,    18,    30,    23,    49,    21,
      24,    26,    49,    49,    18,    32,    33,    34,    35,    15,
      16,    28,    18,    59,    22,    49,    25,    15,    49,    50,
      49,    49,    49,    49,    49,    21,    18,    29,    18,    26,
      22,    25,    22,    27,    15,    16,    22,    49,    49,    49,
      29,    22,    27,    27,    18,    49,    27
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (&yylloc, yyscanner, filename, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, yyscanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, yyscanner, filename); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner, const char *filename)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner, filename)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
    const char *filename;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  YYUSE (filename);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner, const char *filename)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner, filename)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    yyscan_t yyscanner;
    const char *filename;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, yyscanner, filename);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, yyscan_t yyscanner, const char *filename)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, yyscanner, filename)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    yyscan_t yyscanner;
    const char *filename;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , yyscanner, filename);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, yyscanner, filename); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner, const char *filename)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, yyscanner, filename)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    yyscan_t yyscanner;
    const char *filename;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (yyscanner);
  YYUSE (filename);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (yyscan_t yyscanner, const char *filename);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */





/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (yyscan_t yyscanner, const char *filename)
#else
int
yyparse (yyscanner, filename)
    yyscan_t yyscanner;
    const char *filename;
#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Location data for the lookahead symbol.  */
YYLTYPE yylloc;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.
       `yyls': related to locations.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[2];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;

#if YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 1;
#endif

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);

	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
	YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:

/* Line 1455 of yacc.c  */
#line 788 "src/parser.y"
    { parser_import((yyvsp[(2) - (3)].str)); ;}
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 793 "src/parser.y"
    {
			if (list_find(parser_consts, const_cmp_id, (yyvsp[(2) - (2)].const_v).id)
			    != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a constant "
					"with id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].const_v).id);
				exit(EXIT_FAILURE);
			  }
			list_append_copy(parser_consts, &(yyvsp[(2) - (2)].const_v), sizeof((yyvsp[(2) - (2)].const_v)));
		  ;}
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 806 "src/parser.y"
    {
			if (list_find(parser_ext_funcs, ext_func_cmp_id, (yyvsp[(2) - (2)].ext_func).id)
			    != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a function "
					"with id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].ext_func).id);
				exit(EXIT_FAILURE);
			  }
			list_append_copy(parser_ext_funcs, &(yyvsp[(2) - (2)].ext_func), sizeof((yyvsp[(2) - (2)].ext_func)));
		  ;}
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 819 "src/parser.y"
    {
			if (list_find(parser_blocks, block_cmp_id, (yyvsp[(2) - (2)].block).id)
			    != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a block with "
					"id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].block).id);
				exit(EXIT_FAILURE);
			  }
			list_append_copy(parser_blocks, &(yyvsp[(2) - (2)].block), sizeof((yyvsp[(2) - (2)].block)));
		  ;}
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 832 "src/parser.y"
    {
			if (list_find(parser_macros, system_cmp_id, (yyvsp[(2) - (2)].system).id)
			    != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a macro with "
					"id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].system).id);
				exit(EXIT_FAILURE);
			  }
			list_append_copy(parser_macros, &(yyvsp[(2) - (2)].system), sizeof((yyvsp[(2) - (2)].system)));
		  ;}
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 845 "src/parser.y"
    {
			if (list_find(parser_systems, system_cmp_id, (yyvsp[(2) - (2)].system).id)
			    != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a system "
					"with id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].system).id);
				exit(EXIT_FAILURE);
			  }
			list_append_copy(parser_systems, &(yyvsp[(2) - (2)].system), sizeof((yyvsp[(2) - (2)].system)));
		  ;}
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 860 "src/parser.y"
    {
			(yyval.const_v).id = (yyvsp[(2) - (5)].str);
			(yyval.const_v).value = (yyvsp[(4) - (5)].val);
		  ;}
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 868 "src/parser.y"
    {
			if ((yyvsp[(8) - (13)].l) == 0)
			  {
				fprintf(stderr, "%s:%d:%d: error: function "
					"`%s' must take at least one "
					"argument\n", filename, (yylsp[(2) - (13)]).first_line,
					(yylsp[(2) - (13)]).first_column, (yyvsp[(2) - (13)].str));
				exit(EXIT_FAILURE);
			  }

			(yyval.ext_func).id = (yyvsp[(2) - (13)].str);
			(yyval.ext_func).f_id = (yyvsp[(4) - (13)].str);
			(yyval.ext_func).d_id = (yyvsp[(6) - (13)].str);
			(yyval.ext_func).n_args = (yyvsp[(8) - (13)].l);
			(yyval.ext_func).include = (yyvsp[(10) - (13)].str);
			(yyval.ext_func).lib = (yyvsp[(12) - (13)].str);
		  ;}
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 888 "src/parser.y"
    {
			(yyval.block) = (yyvsp[(4) - (5)].block);
			(yyval.block).id = (yyvsp[(2) - (5)].str);
		  ;}
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 895 "src/parser.y"
    {
			struct port_output_defined_context p_ctx;
			struct stmt_bind_context s_ctx;

			/* all output ports defined */
			p_ctx.filename = filename;
			p_ctx.locp = &((yylsp[(1) - (2)]));
			p_ctx.stmts = (yyvsp[(2) - (2)].list);
			list_for_each((yyvsp[(1) - (2)].list), port_output_defined, &p_ctx);

			/* bind statements */
			s_ctx.filename = filename;
			s_ctx.locp = &((yylsp[(1) - (2)]));
			s_ctx.ports = (yyvsp[(1) - (2)].list);
			list_for_each((yyvsp[(2) - (2)].list), stmt_bind, &s_ctx);
			
			(yyval.block).id = NULL;
			(yyval.block).ports = (yyvsp[(1) - (2)].list);
			(yyval.block).stmts = (yyvsp[(2) - (2)].list);
		  ;}
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 918 "src/parser.y"
    {
			(yyval.list) = list_new();
			list_append_copy((yyval.list), &((yyvsp[(1) - (1)].stmt)), sizeof((yyvsp[(1) - (1)].stmt)));
		  ;}
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 923 "src/parser.y"
    {
			if (list_find((yyvsp[(1) - (2)].list), stmt_cmp_output, &(yyvsp[(2) - (2)].stmt)) != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: double "
					"statement for `%s%s'\n",
					filename, (yylsp[(1) - (2)]).first_line,
					(yylsp[(1) - (2)]).first_column, (yyvsp[(2) - (2)].stmt).out.id.id,
					(yyvsp[(2) - (2)].stmt).out.id.out ? ".out" : "");
				exit(EXIT_FAILURE);
			  }
			(yyval.list) = (yyvsp[(1) - (2)].list);
			list_append_copy((yyval.list), &((yyvsp[(2) - (2)].stmt)), sizeof((yyvsp[(2) - (2)].stmt)));
		  ;}
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 939 "src/parser.y"
    {
			(yyval.stmt).out.id.id = (yyvsp[(1) - (4)].str);
			(yyval.stmt).out.id.out = 0;
			(yyval.stmt).expr = (yyvsp[(3) - (4)].expr);
		  ;}
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 945 "src/parser.y"
    {
			(yyval.stmt).out.id.id = (yyvsp[(1) - (6)].str);
			(yyval.stmt).out.id.out = 1;
			(yyval.stmt).expr = (yyvsp[(5) - (6)].expr);
		  ;}
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 953 "src/parser.y"
    {
			(yyval.expr) = expr_new_value((yyvsp[(1) - (1)].val));
		  ;}
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 957 "src/parser.y"
    {
			(yyval.expr) = expr_new_sample_rate();
		  ;}
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 961 "src/parser.y"
    {
			(yyval.expr) = expr_new_signal((yyvsp[(1) - (1)].str), 0, NULL, NULL);
		  ;}
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 965 "src/parser.y"
    {
			(yyval.expr) = expr_new_signal((yyvsp[(1) - (3)].str), 1, NULL, NULL);
		  ;}
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 969 "src/parser.y"
    {
			(yyval.expr) = expr_new_signal((yyvsp[(1) - (4)].str), 0, (yyvsp[(3) - (4)].expr), NULL);
		  ;}
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 973 "src/parser.y"
    {
			(yyval.expr) = expr_new_signal((yyvsp[(1) - (6)].str), 1, (yyvsp[(5) - (6)].expr), NULL);
		  ;}
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 977 "src/parser.y"
    {
			(yyval.expr) = expr_new_signal((yyvsp[(1) - (6)].str), 0, (yyvsp[(3) - (6)].expr), (yyvsp[(5) - (6)].expr));
		  ;}
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 981 "src/parser.y"
    {
			(yyval.expr) = expr_new_signal((yyvsp[(1) - (8)].str), 1, (yyvsp[(5) - (8)].expr), (yyvsp[(7) - (8)].expr));
		  ;}
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 985 "src/parser.y"
    {
			(yyval.expr) = expr_new_call((yyvsp[(1) - (4)].str), (yyvsp[(3) - (4)].list));
		  ;}
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 989 "src/parser.y"
    {
			expr_push_add((yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr));
			(yyval.expr) = (yyvsp[(1) - (3)].expr);
		  ;}
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 994 "src/parser.y"
    {
			expr_push_sub((yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr));
			(yyval.expr) = (yyvsp[(1) - (3)].expr);
		  ;}
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 999 "src/parser.y"
    {
			expr_push_mul((yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr));
			(yyval.expr) = (yyvsp[(1) - (3)].expr);
		  ;}
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 1004 "src/parser.y"
    {
			expr_push_div((yyvsp[(1) - (3)].expr), (yyvsp[(3) - (3)].expr));
			(yyval.expr) = (yyvsp[(1) - (3)].expr);
		  ;}
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 1009 "src/parser.y"
    {
			if (expr_top_is_sign((yyvsp[(2) - (2)].expr)))
			  {
				fprintf(stderr, "%s:%d:%d: error: multiple "
					"sign operators in expression\n",
					filename, (yylsp[(1) - (2)]).first_line,
					(yylsp[(1) - (2)]).first_column);
				exit(EXIT_FAILURE);
			  }
			expr_push_plus((yyvsp[(2) - (2)].expr));
			(yyval.expr) = (yyvsp[(2) - (2)].expr);
		  ;}
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 1022 "src/parser.y"
    {
			if (expr_top_is_sign((yyvsp[(2) - (2)].expr)))
			  {
				fprintf(stderr, "%s:%d:%d: error: multiple "
					"sign operators in expression\n",
					filename, (yylsp[(1) - (2)]).first_line,
					(yylsp[(1) - (2)]).first_column);
				exit(EXIT_FAILURE);
			  }
			expr_push_minus((yyvsp[(2) - (2)].expr));
			(yyval.expr) = (yyvsp[(2) - (2)].expr);
		  ;}
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 1035 "src/parser.y"
    {
			(yyval.expr) = (yyvsp[(2) - (3)].expr);
		  ;}
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 1041 "src/parser.y"
    {
			(yyval.list) = list_new();
			list_append((yyval.list), (yyvsp[(1) - (1)].expr));
		  ;}
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 1046 "src/parser.y"
    {
			(yyval.list) = (yyvsp[(1) - (3)].list);
			list_append((yyval.list), (yyvsp[(3) - (3)].expr));
		  ;}
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 1053 "src/parser.y"
    {
			(yyval.system) = (yyvsp[(4) - (5)].system);
			(yyval.system).id = (yyvsp[(2) - (5)].str);
		  ;}
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 1060 "src/parser.y"
    {
			(yyval.system).id = NULL;
			system_bind(&(yyval.system), (yyvsp[(1) - (3)].list), (yyvsp[(2) - (3)].list), (yyvsp[(3) - (3)].list), filename, &((yylsp[(1) - (3)])));
		  ;}
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 1067 "src/parser.y"
    {
			(yyval.system) = (yyvsp[(4) - (5)].system);
			(yyval.system).id = (yyvsp[(2) - (5)].str);
		  ;}
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 1074 "src/parser.y"
    {
			(yyval.system).id = NULL;
			system_bind(&(yyval.system), (yyvsp[(1) - (3)].list), (yyvsp[(2) - (3)].list), (yyvsp[(3) - (3)].list), filename, &((yylsp[(1) - (3)])));
		  ;}
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 1081 "src/parser.y"
    {
			(yyval.list) = list_new();
		  ;}
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 1085 "src/parser.y"
    {
			if (list_find((yyvsp[(1) - (2)].list), component_cmp_id, (yyvsp[(2) - (2)].component).id) != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a component "
					"with id `%s' was already specified\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].component).id);
				exit(EXIT_FAILURE);
			  }
			(yyval.list) = (yyvsp[(1) - (2)].list);
			list_append_copy((yyval.list), &((yyvsp[(2) - (2)].component)), sizeof((yyvsp[(2) - (2)].component)));
		  ;}
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 1100 "src/parser.y"
    {
			(yyval.component).type.id = (yyvsp[(1) - (3)].str);
			(yyval.component).id = (yyvsp[(2) - (3)].str);
		  ;}
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 1107 "src/parser.y"
    {
			(yyval.list) = list_new();
			list_append_copy((yyval.list), &((yyvsp[(1) - (1)].connection)), sizeof((yyvsp[(1) - (1)].connection)));
		  ;}
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 1112 "src/parser.y"
    {
			if (list_find((yyvsp[(1) - (2)].list), connection_cmp, &(yyvsp[(2) - (2)].connection)) != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: connection "
					"already specified\n", filename,
					(yylsp[(2) - (2)]).first_line, (yylsp[(2) - (2)]).first_column);
				exit(EXIT_FAILURE);
			  }
			(yyval.list) = (yyvsp[(1) - (2)].list);
			list_append_copy((yyval.list), &((yyvsp[(2) - (2)].connection)), sizeof((yyvsp[(2) - (2)].connection)));
		  ;}
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 1126 "src/parser.y"
    {
			if ((((yyvsp[(1) - (4)].conn_elem).c.id.component == NULL)
			     && ((yyvsp[(1) - (4)].conn_elem).type == conn_elem_type_in))
			    || (((yyvsp[(1) - (4)].conn_elem).c.id.component != NULL)
				&& ((yyvsp[(1) - (4)].conn_elem).type == conn_elem_type_out))
			    || (((yyvsp[(3) - (4)].conn_elem).c.id.component == NULL)
			        && ((yyvsp[(3) - (4)].conn_elem).type == conn_elem_type_out))
			    || (((yyvsp[(3) - (4)].conn_elem).c.id.component != NULL)
				&& ((yyvsp[(3) - (4)].conn_elem).type == conn_elem_type_in))
			    || ((yyvsp[(1) - (4)].conn_elem).type == conn_elem_type_value)
			    || (((yyvsp[(3) - (4)].conn_elem).type == conn_elem_type_value)
			        && ((((yyvsp[(1) - (4)].conn_elem).c.id.component == NULL)
			             && ((yyvsp[(1) - (4)].conn_elem).type == conn_elem_type_in))
			            || (((yyvsp[(1) - (4)].conn_elem).c.id.component != NULL)
			                && ((yyvsp[(1) - (4)].conn_elem).type == conn_elem_type_out)))))
			  {
				fprintf(stderr, "%s:%d:%d: error: invalid "
					"connection\n", filename, (yylsp[(1) - (4)]).first_line,
					(yylsp[(1) - (4)]).first_column);
				exit(EXIT_FAILURE);
			  }
			(yyval.connection).output = (yyvsp[(1) - (4)].conn_elem);
			(yyval.connection).input = (yyvsp[(3) - (4)].conn_elem);
		  ;}
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 1153 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_port;
			(yyval.conn_elem).c.id.component = NULL;
			(yyval.conn_elem).c.id.port = (yyvsp[(1) - (1)].str);
		  ;}
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 1159 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_in;
			(yyval.conn_elem).c.id.component = NULL;
			(yyval.conn_elem).c.id.port = (yyvsp[(1) - (3)].str);
		  ;}
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 1165 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_out;
			(yyval.conn_elem).c.id.component = NULL;
			(yyval.conn_elem).c.id.port = (yyvsp[(1) - (3)].str);
		  ;}
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 1171 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_port;
			(yyval.conn_elem).c.id.component = (yyvsp[(1) - (3)].str);
			(yyval.conn_elem).c.id.port = (yyvsp[(3) - (3)].str);
		  ;}
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 1177 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_in;
			(yyval.conn_elem).c.id.component = (yyvsp[(1) - (5)].str);
			(yyval.conn_elem).c.id.port = (yyvsp[(3) - (5)].str);
		  ;}
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 1183 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_out;
			(yyval.conn_elem).c.id.component = (yyvsp[(1) - (5)].str);
			(yyval.conn_elem).c.id.port = (yyvsp[(3) - (5)].str);
		  ;}
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 1189 "src/parser.y"
    {
			(yyval.conn_elem).type = conn_elem_type_value;
			(yyval.conn_elem).c.value = (yyvsp[(1) - (1)].val);
		  ;}
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 1196 "src/parser.y"
    {
			(yyval.list) = list_new();
			list_append_copy((yyval.list), &((yyvsp[(1) - (1)].port)), sizeof((yyvsp[(1) - (1)].port)));
		  ;}
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 1201 "src/parser.y"
    {
			if (list_find((yyvsp[(1) - (2)].list), port_cmp_id, (yyvsp[(2) - (2)].port).id) != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a port with "
					"id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].port).id);
				exit(EXIT_FAILURE);
			  }
			(yyval.list) = (yyvsp[(1) - (2)].list);
			list_append_copy((yyval.list), &((yyvsp[(2) - (2)].port)), sizeof((yyvsp[(2) - (2)].port)));
		  ;}
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 1216 "src/parser.y"
    {
			(yyval.port).sync = port_sync_unknown;
			(yyval.port).type = (yyvsp[(1) - (3)].port_type);
			(yyval.port).id = (yyvsp[(2) - (3)].str);
		  ;}
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 1224 "src/parser.y"
    {
			(yyval.list) = list_new();
			list_append_copy((yyval.list), &((yyvsp[(1) - (1)].port)), sizeof((yyvsp[(1) - (1)].port)));
		  ;}
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 1229 "src/parser.y"
    {
			if (list_find((yyvsp[(1) - (2)].list), port_cmp_id, (yyvsp[(2) - (2)].port).id) != NULL)
			  {
				fprintf(stderr, "%s:%d:%d: error: a port with "
					"id `%s' was already defined\n",
					filename, (yylsp[(2) - (2)]).first_line,
					(yylsp[(2) - (2)]).first_column, (yyvsp[(2) - (2)].port).id);
				exit(EXIT_FAILURE);
			  }
			(yyval.list) = (yyvsp[(1) - (2)].list);
			list_append_copy((yyval.list), &((yyvsp[(2) - (2)].port)), sizeof((yyvsp[(2) - (2)].port)));
		  ;}
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 1244 "src/parser.y"
    {
			if (((yyvsp[(2) - (4)].port_type) == port_type_w) || ((yyvsp[(2) - (4)].port_type) == port_type_k))
			  {
				fprintf(stderr, "%s:%d:%d: error: systems "
					"cannot expose physical ports\n",
					filename, (yylsp[(2) - (4)]).first_line,
					(yylsp[(2) - (4)]).first_column);
				exit(EXIT_FAILURE);
			  }
			(yyval.port).sync = (yyvsp[(1) - (4)].port_sync);
			(yyval.port).type = (yyvsp[(2) - (4)].port_type);
			(yyval.port).id = (yyvsp[(3) - (4)].str);
		  ;}
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 1259 "src/parser.y"
    { (yyval.port_sync) = port_sync_sync;  ;}
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 1260 "src/parser.y"
    { (yyval.port_sync) = port_sync_async; ;}
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 1263 "src/parser.y"
    { (yyval.port_type) = port_type_input;  ;}
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 1264 "src/parser.y"
    { (yyval.port_type) = port_type_output; ;}
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 1265 "src/parser.y"
    { (yyval.port_type) = port_type_w;      ;}
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 1266 "src/parser.y"
    { (yyval.port_type) = port_type_k;      ;}
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 1269 "src/parser.y"
    { (yyval.val) = (yyvsp[(1) - (1)].val);  ;}
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 1270 "src/parser.y"
    { (yyval.val) = (yyvsp[(2) - (2)].val);  ;}
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 1271 "src/parser.y"
    { (yyval.val) = -(yyvsp[(2) - (2)].val); ;}
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 1274 "src/parser.y"
    { (yyval.val) = (double)(yyvsp[(1) - (1)].l); ;}
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 1275 "src/parser.y"
    { (yyval.val) = (yyvsp[(1) - (1)].val); ;}
    break;



/* Line 1455 of yacc.c  */
#line 3063 "src/parser.tab.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, yyscanner, filename, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (&yylloc, yyscanner, filename, yymsg);
	  }
	else
	  {
	    yyerror (&yylloc, yyscanner, filename, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, yyscanner, filename);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, yyscanner, filename);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, filename, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, &yylloc, yyscanner, filename);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, yyscanner, filename);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



