/* ts.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "petscts.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetfromoptions_ PTSSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetfromoptions_ ptssetfromoptions
#else
#define tssetfromoptions_ ptssetfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetfromoptions_ TSSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetfromoptions_ tssetfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsviewfromoptions_ PTSVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsviewfromoptions_ ptsviewfromoptions
#else
#define tsviewfromoptions_ ptsviewfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsviewfromoptions_ TSVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsviewfromoptions_ tsviewfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tscomputerhsjacobian_ PTSCOMPUTERHSJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tscomputerhsjacobian_ ptscomputerhsjacobian
#else
#define tscomputerhsjacobian_ ptscomputerhsjacobian_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tscomputerhsjacobian_ TSCOMPUTERHSJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tscomputerhsjacobian_ tscomputerhsjacobian
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgettimestepnumber_ PTSGETTIMESTEPNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgettimestepnumber_ ptsgettimestepnumber
#else
#define tsgettimestepnumber_ ptsgettimestepnumber_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgettimestepnumber_ TSGETTIMESTEPNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgettimestepnumber_ tsgettimestepnumber
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetinitialtimestep_ PTSSETINITIALTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetinitialtimestep_ ptssetinitialtimestep
#else
#define tssetinitialtimestep_ ptssetinitialtimestep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetinitialtimestep_ TSSETINITIALTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetinitialtimestep_ tssetinitialtimestep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssettimestep_ PTSSETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssettimestep_ ptssettimestep
#else
#define tssettimestep_ ptssettimestep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssettimestep_ TSSETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssettimestep_ tssettimestep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgettimestep_ PTSGETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgettimestep_ ptsgettimestep
#else
#define tsgettimestep_ ptsgettimestep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgettimestep_ TSGETTIMESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgettimestep_ tsgettimestep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetup_ PTSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetup_ ptssetup
#else
#define tssetup_ ptssetup_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetup_ TSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetup_ tssetup
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgetduration_ PTSGETDURATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgetduration_ ptsgetduration
#else
#define tsgetduration_ ptsgetduration_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgetduration_ TSGETDURATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgetduration_ tsgetduration
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetduration_ PTSSETDURATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetduration_ ptssetduration
#else
#define tssetduration_ ptssetduration_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetduration_ TSSETDURATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetduration_ tssetduration
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetsolution_ PTSSETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetsolution_ ptssetsolution
#else
#define tssetsolution_ ptssetsolution_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tssetsolution_ TSSETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tssetsolution_ tssetsolution
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultrhsbc_ PTSDEFAULTRHSBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultrhsbc_ ptsdefaultrhsbc
#else
#define tsdefaultrhsbc_ ptsdefaultrhsbc_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultrhsbc_ TSDEFAULTRHSBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultrhsbc_ tsdefaultrhsbc
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultsystemmatrixbc_ PTSDEFAULTSYSTEMMATRIXBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultsystemmatrixbc_ ptsdefaultsystemmatrixbc
#else
#define tsdefaultsystemmatrixbc_ ptsdefaultsystemmatrixbc_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultsystemmatrixbc_ TSDEFAULTSYSTEMMATRIXBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultsystemmatrixbc_ tsdefaultsystemmatrixbc
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultsolutionbc_ PTSDEFAULTSOLUTIONBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultsolutionbc_ ptsdefaultsolutionbc
#else
#define tsdefaultsolutionbc_ ptsdefaultsolutionbc_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultsolutionbc_ TSDEFAULTSOLUTIONBC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultsolutionbc_ tsdefaultsolutionbc
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultprestep_ PTSDEFAULTPRESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultprestep_ ptsdefaultprestep
#else
#define tsdefaultprestep_ ptsdefaultprestep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultprestep_ TSDEFAULTPRESTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultprestep_ tsdefaultprestep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultupdate_ PTSDEFAULTUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultupdate_ ptsdefaultupdate
#else
#define tsdefaultupdate_ ptsdefaultupdate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultupdate_ TSDEFAULTUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultupdate_ tsdefaultupdate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultpoststep_ PTSDEFAULTPOSTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultpoststep_ ptsdefaultpoststep
#else
#define tsdefaultpoststep_ ptsdefaultpoststep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsdefaultpoststep_ TSDEFAULTPOSTSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsdefaultpoststep_ tsdefaultpoststep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsstep_ PTSSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsstep_ ptsstep
#else
#define tsstep_ ptsstep_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsstep_ TSSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsstep_ tsstep
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgettime_ PTSGETTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgettime_ ptsgettime
#else
#define tsgettime_ ptsgettime_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define tsgettime_ TSGETTIME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define tsgettime_ tsgettime
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL tssetfromoptions_(TS ts, int *ierr ){
*ierr = TSSetFromOptions(
	(TS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL tsviewfromoptions_(TS ts, char title[], int *ierr ){
*ierr = TSViewFromOptions(
	(TS)PetscToPointer( (ts) ),title);
}
void PETSC_STDCALL tscomputerhsjacobian_(TS ts,PetscReal *t,Vec X,Mat *A,Mat *B,MatStructure *flg, int *ierr ){
*ierr = TSComputeRHSJacobian(
	(TS)PetscToPointer( (ts) ),*t,
	(Vec)PetscToPointer( (X) ),A,B,
	(MatStructure* )PetscToPointer( (flg) ));
}
void PETSC_STDCALL tsgettimestepnumber_(TS ts,int* iter, int *ierr ){
*ierr = TSGetTimeStepNumber(
	(TS)PetscToPointer( (ts) ),iter);
}
void PETSC_STDCALL tssetinitialtimestep_(TS ts,PetscReal *initial_time,PetscReal *time_step, int *ierr ){
*ierr = TSSetInitialTimeStep(
	(TS)PetscToPointer( (ts) ),*initial_time,*time_step);
}
void PETSC_STDCALL tssettimestep_(TS ts,PetscReal *time_step, int *ierr ){
*ierr = TSSetTimeStep(
	(TS)PetscToPointer( (ts) ),*time_step);
}
void PETSC_STDCALL tsgettimestep_(TS ts,PetscReal* dt, int *ierr ){
*ierr = TSGetTimeStep(
	(TS)PetscToPointer( (ts) ),dt);
}
void PETSC_STDCALL tssetup_(TS ts, int *ierr ){
*ierr = TSSetUp(
	(TS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL tsgetduration_(TS ts,int *maxsteps,PetscReal *maxtime, int *ierr ){
*ierr = TSGetDuration(
	(TS)PetscToPointer( (ts) ),maxsteps,maxtime);
}
void PETSC_STDCALL tssetduration_(TS ts,int *maxsteps,PetscReal *maxtime, int *ierr ){
*ierr = TSSetDuration(
	(TS)PetscToPointer( (ts) ),*maxsteps,*maxtime);
}
void PETSC_STDCALL tssetsolution_(TS ts,Vec x, int *ierr ){
*ierr = TSSetSolution(
	(TS)PetscToPointer( (ts) ),
	(Vec)PetscToPointer( (x) ));
}
void PETSC_STDCALL tsdefaultrhsbc_(TS ts,Vec rhs,void*ctx, int *ierr ){
*ierr = TSDefaultRhsBC(
	(TS)PetscToPointer( (ts) ),
	(Vec)PetscToPointer( (rhs) ),ctx);
}
void PETSC_STDCALL tsdefaultsystemmatrixbc_(TS ts,Mat A,Mat B,void*ctx, int *ierr ){
*ierr = TSDefaultSystemMatrixBC(
	(TS)PetscToPointer( (ts) ),
	(Mat)PetscToPointer( (A) ),
	(Mat)PetscToPointer( (B) ),ctx);
}
void PETSC_STDCALL tsdefaultsolutionbc_(TS ts,Vec sol,void*ctx, int *ierr ){
*ierr = TSDefaultSolutionBC(
	(TS)PetscToPointer( (ts) ),
	(Vec)PetscToPointer( (sol) ),ctx);
}
void PETSC_STDCALL tsdefaultprestep_(TS ts, int *ierr ){
*ierr = TSDefaultPreStep(
	(TS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL tsdefaultupdate_(TS ts,PetscReal *t,PetscReal *dt, int *ierr ){
*ierr = TSDefaultUpdate(
	(TS)PetscToPointer( (ts) ),*t,dt);
}
void PETSC_STDCALL tsdefaultpoststep_(TS ts, int *ierr ){
*ierr = TSDefaultPostStep(
	(TS)PetscToPointer( (ts) ));
}
void PETSC_STDCALL tsstep_(TS ts,int *steps,PetscReal *ptime, int *ierr ){
*ierr = TSStep(
	(TS)PetscToPointer( (ts) ),steps,ptime);
}
void PETSC_STDCALL tsgettime_(TS ts,PetscReal* t, int *ierr ){
*ierr = TSGetTime(
	(TS)PetscToPointer( (ts) ),t);
}
#if defined(__cplusplus)
}
#endif
