#include "petsc.h"
#include "petscfix.h"
/* vinv.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescale_ PVECSTRIDESCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescale_ pvecstridescale
#else
#define vecstridescale_ pvecstridescale_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescale_ VECSTRIDESCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescale_ vecstridescale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemax_ PVECSTRIDEMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemax_ pvecstridemax
#else
#define vecstridemax_ pvecstridemax_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemax_ VECSTRIDEMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemax_ vecstridemax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemin_ PVECSTRIDEMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemin_ pvecstridemin
#else
#define vecstridemin_ pvecstridemin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemin_ VECSTRIDEMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemin_ vecstridemin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescaleall_ PVECSTRIDESCALEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescaleall_ pvecstridescaleall
#else
#define vecstridescaleall_ pvecstridescaleall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescaleall_ VECSTRIDESCALEALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescaleall_ vecstridescaleall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridenormall_ PVECSTRIDENORMALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridenormall_ pvecstridenormall
#else
#define vecstridenormall_ pvecstridenormall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridenormall_ VECSTRIDENORMALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridenormall_ vecstridenormall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemaxall_ PVECSTRIDEMAXALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemaxall_ pvecstridemaxall
#else
#define vecstridemaxall_ pvecstridemaxall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridemaxall_ VECSTRIDEMAXALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridemaxall_ vecstridemaxall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstrideminall_ PVECSTRIDEMINALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstrideminall_ pvecstrideminall
#else
#define vecstrideminall_ pvecstrideminall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstrideminall_ VECSTRIDEMINALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstrideminall_ vecstrideminall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegatherall_ PVECSTRIDEGATHERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegatherall_ pvecstridegatherall
#else
#define vecstridegatherall_ pvecstridegatherall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegatherall_ VECSTRIDEGATHERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegatherall_ vecstridegatherall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatterall_ PVECSTRIDESCATTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatterall_ pvecstridescatterall
#else
#define vecstridescatterall_ pvecstridescatterall_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatterall_ VECSTRIDESCATTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatterall_ vecstridescatterall
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegather_ PVECSTRIDEGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegather_ pvecstridegather
#else
#define vecstridegather_ pvecstridegather_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridegather_ VECSTRIDEGATHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridegather_ vecstridegather
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatter_ PVECSTRIDESCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatter_ pvecstridescatter
#else
#define vecstridescatter_ pvecstridescatter_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstridescatter_ VECSTRIDESCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstridescatter_ vecstridescatter
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsqrt_ PVECSQRT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsqrt_ pvecsqrt
#else
#define vecsqrt_ pvecsqrt_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsqrt_ VECSQRT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsqrt_ vecsqrt
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsum_ PVECSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsum_ pvecsum
#else
#define vecsum_ pvecsum_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsum_ VECSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsum_ vecsum
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecshift_ PVECSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecshift_ pvecshift
#else
#define vecshift_ pvecshift_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecshift_ VECSHIFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecshift_ vecshift
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecabs_ PVECABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecabs_ pvecabs
#else
#define vecabs_ pvecabs_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecabs_ VECABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecabs_ vecabs
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpermute_ PVECPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpermute_ pvecpermute
#else
#define vecpermute_ pvecpermute_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpermute_ VECPERMUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpermute_ vecpermute
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecequal_ PVECEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecequal_ pvecequal
#else
#define vecequal_ pvecequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecequal_ VECEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecequal_ vecequal
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   vecstridescale_(Vec v,PetscInt *start,PetscScalar *scale, int *__ierr ){
*__ierr = VecStrideScale(
	(Vec)PetscToPointer((v) ),*start,scale);
}
void PETSC_STDCALL   vecstridemax_(Vec v,PetscInt *start,PetscInt *idex,PetscReal *nrm, int *__ierr ){
*__ierr = VecStrideMax(
	(Vec)PetscToPointer((v) ),*start,idex,nrm);
}
void PETSC_STDCALL   vecstridemin_(Vec v,PetscInt *start,PetscInt *idex,PetscReal *nrm, int *__ierr ){
*__ierr = VecStrideMin(
	(Vec)PetscToPointer((v) ),*start,idex,nrm);
}
void PETSC_STDCALL   vecstridescaleall_(Vec v,PetscScalar *scales, int *__ierr ){
*__ierr = VecStrideScaleAll(
	(Vec)PetscToPointer((v) ),scales);
}
void PETSC_STDCALL   vecstridenormall_(Vec v,NormType *ntype,PetscReal *nrm, int *__ierr ){
*__ierr = VecStrideNormAll(
	(Vec)PetscToPointer((v) ),*ntype,nrm);
}
void PETSC_STDCALL   vecstridemaxall_(Vec v,PetscInt *idex,PetscReal *nrm, int *__ierr ){
*__ierr = VecStrideMaxAll(
	(Vec)PetscToPointer((v) ),idex,nrm);
}
void PETSC_STDCALL   vecstrideminall_(Vec v,PetscInt *idex,PetscReal *nrm, int *__ierr ){
*__ierr = VecStrideMinAll(
	(Vec)PetscToPointer((v) ),idex,nrm);
}
void PETSC_STDCALL   vecstridegatherall_(Vec v,Vec *s,InsertMode *addv, int *__ierr ){
*__ierr = VecStrideGatherAll(
	(Vec)PetscToPointer((v) ),s,*addv);
}
void PETSC_STDCALL   vecstridescatterall_(Vec *s,Vec v,InsertMode *addv, int *__ierr ){
*__ierr = VecStrideScatterAll(s,
	(Vec)PetscToPointer((v) ),*addv);
}
void PETSC_STDCALL   vecstridegather_(Vec v,PetscInt *start,Vec s,InsertMode *addv, int *__ierr ){
*__ierr = VecStrideGather(
	(Vec)PetscToPointer((v) ),*start,
	(Vec)PetscToPointer((s) ),*addv);
}
void PETSC_STDCALL   vecstridescatter_(Vec s,PetscInt *start,Vec v,InsertMode *addv, int *__ierr ){
*__ierr = VecStrideScatter(
	(Vec)PetscToPointer((s) ),*start,
	(Vec)PetscToPointer((v) ),*addv);
}
void PETSC_STDCALL   vecsqrt_(Vec v, int *__ierr ){
*__ierr = VecSqrt(
	(Vec)PetscToPointer((v) ));
}
void PETSC_STDCALL   vecsum_(Vec v,PetscScalar *sum, int *__ierr ){
*__ierr = VecSum(
	(Vec)PetscToPointer((v) ),sum);
}
void PETSC_STDCALL   vecshift_(Vec v,PetscScalar *shift, int *__ierr ){
*__ierr = VecShift(
	(Vec)PetscToPointer((v) ),*shift);
}
void PETSC_STDCALL   vecabs_(Vec v, int *__ierr ){
*__ierr = VecAbs(
	(Vec)PetscToPointer((v) ));
}
void PETSC_STDCALL   vecpermute_(Vec x,IS row,PetscTruth *inv, int *__ierr ){
*__ierr = VecPermute(
	(Vec)PetscToPointer((x) ),
	(IS)PetscToPointer((row) ),*inv);
}
void PETSC_STDCALL   vecequal_(Vec vec1,Vec vec2,PetscTruth *flg, int *__ierr ){
*__ierr = VecEqual(
	(Vec)PetscToPointer((vec1) ),
	(Vec)PetscToPointer((vec2) ),flg);
}
#if defined(__cplusplus)
}
#endif
