/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#if defined USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#include <sys/types.h>
#endif
#ifdef AIX
#include <sys/select.h>
#include <values.h>
#endif
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#include <sys/time.h>
#include "main.h"

extern short get_var_from_pftprc(FILE *, const char *, char *, int);
extern void  set_tty(int);
extern char *tabdir(char *);
extern short create_dir(char *, char *);
extern short save_dir(char *, char *);
extern short copy_file(char *, char *);
extern short save_tags(char *);
extern void mhelp(void);
extern short set_prog(char **, char *);
extern char *get_subject(char *, char *, char *);
extern long pftp_pager(char *, char *, char *);
extern void warranty(void);
extern void rm_empty_dirs(void);
extern short empty_dir(char *);
extern long read_pinfo(char **, long *, short);
extern void write_pinfo(char **);
extern long set_entry_in_files(char **, char *, long *);
extern void rm_entry_from_files(char **, char *, long *);
extern long read_cur_dir(char **, long *);
extern char browse_dir(char *);
extern void lhost(int *, short);
extern void free_vec(char **);

long tlastentry;
long dlastentry;
char PFTP_SORT_BY='a';
char *tfiles[PFTP_MAX_PFM_ENTRY]; /* holds the selected files */
char *dfiles[PFTP_MAX_PFM_ENTRY]; /* holds the selected files */
char *pager[SONAME]; /* holds the pager program and its arguments */
char *headline;
char *lastline;
char secondline[LONAME];
char *saving_str;
char *blankline;
char *curdir; /* holds the selected files */
short CLEAR_TAG;
short USE_PFTPPAGER;


void pmanager(short PFTP_PEEK)
{
   char *pmain[PFTP_MAX_PFM_ENTRY]; /* holds Pinfo entries */
   char *Pinfodir=NULL, *Puni=NULL, *cdir=NULL, *update_tmp_str=NULL;
   char **tmp=NULL, *subj=NULL;
   char c='\0', *ctmp=NULL;
   char skip_first=0;
   char update=1, update_last_line=0;
   long num=0, cur=1;
   long endnum=0, lastnum=0, j=0;
   long incoming=0, tmp_incoming=0;
   int height=_WINROWS_-4;
   int firstline=0;
   int MENU_UPDATE_SEC=DEFAULT_MENU_UPDATE;
   time_t entry_date=0;
   struct stat buf;
#ifndef AIX
   fd_set rfds;
#else
   SELLIST(BITS(int), BITS(int)) rfds;
#endif
   pftp_tv tv;
   *tfiles = NULL;

   for (tmp=pmain, num=0; num < PFTP_MAX_PFM_ENTRY; tmp++, num++) *tmp=NULL;
   for (endnum=PFTP_MAX_PFM_ENTRY, tmp=tfiles; j < endnum; j++, tmp++) *tmp=NULL;
   for (endnum=PFTP_MAX_PFM_ENTRY, tmp=dfiles; j < endnum; j++, tmp++) *tmp=NULL;
   endnum = j = num = 0;

   tlastentry = dlastentry = 0;
   (*statstr)->OVERWRITE = 0;
   (*statstr)->_SKIP_ = 0;
   CLEAR_TAG = 0;
   USE_PFTPPAGER = 0;

   MEM_CHECK((cdir = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((headline = (char *)calloc(LONAME, sizeof(char))));
   sprintf(headline, "****** Port-FTP Version " VERSION " ****** file and directory manager ");
   for (ctmp=headline; *ctmp; ctmp++);
   for (; ctmp - headline < _WINCOLS_; ctmp++) *ctmp = '*';
   *(ctmp-1) = ' ';
   *ctmp = '\0';
   MEM_CHECK((lastline = (char *)calloc(LONAME, sizeof(char))));
   sprintf(lastline, "[%dH**** <q> quit, <t> tag, <s> save, <space> more, <b> back, <?> help ***", _WINROWS_);
   for (num=0, ctmp=lastline; *ctmp != 'H'; ctmp++, num++);
   for (ctmp=lastline; *ctmp; ctmp++);
   for (; ctmp - lastline < _WINCOLS_+num; ctmp++) *ctmp = '*';
   *ctmp = '\r';
   *++ctmp = '\0';
   MEM_CHECK((saving_str = (char *)calloc(SONAME, sizeof(char))));
   sprintf(saving_str, "[%dH* Saving ...", _WINROWS_);
   for (num=0, ctmp=saving_str; *ctmp != 'H'; ctmp++, num++);
   for (ctmp=saving_str; *ctmp; ctmp++);
   for (; ctmp - saving_str < _WINCOLS_+num; ctmp++) *ctmp = ' ';
   *ctmp = '\r';
   *++ctmp = '\0';
   MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
   for (ctmp=blankline; ctmp - blankline < _WINCOLS_; ctmp++) *ctmp = ' ';
   *ctmp='\r';
   *++ctmp='\0';
   MEM_CHECK((curdir = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((Puni = (char *)calloc(SONAME, sizeof(char))));
   MEM_CHECK((Pinfodir = (char *)calloc(LONAME, sizeof(char))));
   MEM_CHECK((update_tmp_str = (char *)calloc(SONAME, sizeof(char))));

   /*
    * Hold current directory.
    */
#ifdef NEXTSTEP
   getwd(curdir);
#else
   getcwd(curdir, LONAME);
#endif

   /*
    * Get the interval between main menu update in seconds.
    */
   if (get_var_from_pftprc((FILE *)NULL, "PFTPIUPDATE", update_tmp_str, 0)) {
      MENU_UPDATE_SEC = atoi(update_tmp_str);
   }
   free(update_tmp_str);

   /*
    * Get the name of the upload directory.
    */
   if (!get_var_from_pftprc((FILE *)NULL, "PFTPRECEIVE", Pinfodir, 0)) {
      if (PFTP_PEEK == 2) {
         free(Pinfodir);
         return;
      }
      if (!PFTP_PEEK) fprintf(stderr,  "** PFTPRECEIVE is not defined.  Please, rtfm!\n");
      exit(PFTP_UPLOADDIR_ERR);
   }

   /*
    * Check if directory exists.  If not create it.
    */
   if (stat(Pinfodir, &buf)) {
      if (mkdir(Pinfodir, 0755) < 0) {
         fprintf(stderr, "** %s: %s!\n", Pinfodir, _PFTP_ERROR_ARRAY_);
         exit(PFTP_FILE_OPEN_ERR);
      }
   }

   /*
    * Change to the upload directory.
    */
   if (chdir(Pinfodir) < 0) {
      fprintf(stderr, "** %s: %s\n", Pinfodir, _PFTP_ERROR_ARRAY_);
      exit(PFTP_CHDIR_ERR);
   }

   if (!PFTP_PEEK) {
      /*
       * Lock the upload directory if it's unlocked.
       */
      sprintf(Puni, "%s:%d",
      getenv("HOSTNAME")? getenv("HOSTNAME"): getenv("HOST")? getenv("HOST"): "unknown_host"
      , getpid());
      if ((num = open(Puni, O_CREAT, 0600)) < 0) {
         fprintf(stderr, "** %s: %s\n", Puni, _PFTP_ERROR_ARRAY_);
         exit(PFTP_FILE_OPEN_ERR);
      }
      close(num);
      link(Puni, "lock");
      buf.st_mode = 0;
      if (stat(Puni, &buf) < 0) {
         fprintf(stderr, "** %s: %s\n", Puni, _PFTP_ERROR_ARRAY_);
         exit(PFTP_FILE_OPEN_ERR);
      }
      if (buf.st_nlink != 2) {
         fprintf(stderr, "**\n** There is another pftp manager already running!\n");
         fprintf(stderr, "** Look in `%s' to see the host name and the pid.\n",
         Pinfodir);
         fprintf(stderr, "** If the lock file is outdated remove the `hostname:pid' file\n");
         fprintf(stderr, "** and the `lock' file.\n**\n");
         unlink(Puni);
         if (Pinfodir) free(Pinfodir);
         if (Puni) free(Puni);
         if (curdir) free(curdir);
         if (blankline) free(blankline);
         if (saving_str) free(saving_str);
         if (lastline) free(lastline);
         if (headline) free(headline);
         if (cdir) free(cdir);
         exit(PFTP_PFM_ERR);
      }
      
      /*
       * Set PFTP_SORT_BY.
       */
      if (get_var_from_pftprc((FILE *)NULL, "PFTPSORTBY", Pinfodir, 0)) {
         if (*Pinfodir == 's') PFTP_SORT_BY = 's';
         else if (*Pinfodir == 't') PFTP_SORT_BY = 't';
      }

      /*
       * Set the pager.
       */
      if (!set_prog(pager, "PFTPPAGER")) USE_PFTPPAGER = 1;
   }
   if (Pinfodir) free(Pinfodir);

   /*
    * Read the Pinfo file.
    */
   if ((lastnum = read_pinfo(pmain, &incoming, PFTP_PEEK)) < 0) {
      if (PFTP_PEEK == 2) {
         free_vec(pmain);
         return;
      }
      if (!PFTP_PEEK) {
         unlink(Puni);
         unlink("lock");
      }
      exit(PFTP_FILE_OPEN_ERR);
   }
   if (lastnum > 0) endnum = lastnum - 1;

   /*
    * Just peeking.
    */
   if (PFTP_PEEK) {
      if (PFTP_PEEK == 2) {
         /*
          * Count number of new data entries.
          */
         for (tmp=pmain; *tmp; tmp++) {
            if (**tmp == 'N') (*statstr)->bsize++;
         }
         free_vec(pmain);
         return;
      }
      for (tmp=pmain; *tmp && **tmp != 'N' && **tmp != 'O'; tmp++);
      if (*tmp) {
         fprintf(stdout, PFTP_NEW_DATA_MSG);
         exit(PFTP_NEW_DATA);
      }
      exit(PFTP_NO_ERR);
   }

   /*
    * Start interaction with the user.
    */
   num=0;
   cur= *pmain ? 0 : -1;
   fprintf(stdout, "[?25l\r");
   MEM_CHECK((subj = (char *)calloc(LONAME, sizeof(char))));
   set_tty(2);
   do {
      do {
         if (update && update < 3) {
            firstline = num;
            if (update == 1) {
               fprintf(stdout, "[H[J%s\n", headline);
               fprintf(stdout, "%s\n", blankline);
            }
            else fprintf(stdout, "[H\n\n");
            for (j=0; j < height && *(pmain+num); j++, num++) {
               *subj = '\0';
               entry_date = atol(DATESTRING(num));
               sprintf(cdir, "%s %s %.15s  %s  %s", num==cur? "-->": "   ",
               *(pmain+num), asctime(localtime(&entry_date))+4, USERSTRING(num),
               get_subject(subj, USERSTRING(num), DATESTRING(num)) ? subj: "");
               *(cdir+_WINCOLS_) = '\0';
               fprintf(stdout, "%s%s%s", update != 1 ? blankline: "", cdir, *subj ? "": "\n");
            }
            if (update == 1) fprintf(stdout, lastline);
            fprintf(stdout, "[%dH%4ld", _WINCOLS_, cur+1);
            update=0;
         }
         if (update == 3) {
            fprintf(stdout, "[H\n* You have new data.\n");
            update = 0;
         }
         if (!MENU_UPDATE_SEC) break;
#ifndef AIX
         FD_ZERO(&rfds);
         FD_SET(0, &rfds);
#else
         rfds.fdsmask[0 / BITS(int)] = 1 << (0 % BITS(0));
#endif
         tv.tv_sec = MENU_UPDATE_SEC;
         tv.tv_usec = 0;
         /*
          * Look if new data arrived.
          */
         tmp_incoming = incoming;
         if (lastnum != read_cur_dir(NULL, &incoming) || incoming != tmp_incoming) {
            if ((lastnum - (incoming - tmp_incoming)) != endnum) update = 3;
            lastnum = read_pinfo(pmain, &incoming, PFTP_PEEK);
            if (lastnum > 0) endnum = lastnum - 1;
            if (endnum < height) {
               num -= height;
               if (num < 0) num = 0;
               if (cur < 0) cur = 0;
               update = 2;
            }
         }
         else update = 0;
         fflush(stdout);
      }
#ifndef AIX
      while (select(1, &rfds, NULL, NULL, (struct timeval *)&tv) <= 0);
#else
      while (select(BITS(0), &rfds, NULL, NULL, (struct timeval *)&tv) <= 0);
#endif
      while ((c = fgetc(stdin)) == '' || c == '[' || c == 'O');
      if (update_last_line) {
         fprintf(stdout, "%s\b%4ld", lastline, cur+1);
         update_last_line = 0;
      }
      do {
         switch(c) {
            case 'j':
            case 'B':
               c = 0;
               if (cur < 0) break;
               if (cur < firstline + height - 1 && cur < endnum) {
                  fprintf(stdout, "[%ldH   ", cur+3-firstline);
                  cur++;
                  fprintf(stdout, "[%ldH-->[%dH%4ld", cur+3-firstline, _WINROWS_, cur+1);
                  break;
               }
               else if (cur >= endnum) {
                  cur = endnum;
                  break;
               }
               else if (cur < firstline + height - 1) break;
               else cur++;
            case ' ':
            case '6':
               if (cur < 0) break;
               if (c == '6') c = ' ';
               if (num > endnum) update = 2;
               if (num + height > endnum) num = endnum - height + 1;
               if (num < 0) num = 0;
               if (c == ' ') {
                  if (update == 2) cur = endnum;
                  else cur = num;
               }
               update = 2;
               break;
            case 'g':
            case '1':
               if (cur < 0) break;
               if (cur) update = 2;
               num = 0;
               cur = 0;
               break;
            case 'G':
            case '4':
               if (cur < 0) break;
               num = endnum - height + 1;
               cur = endnum;
               if (num < 0) num = 0;
               update = 2;
               break;
            case 'k':
            case 'A':
               if (cur < 0) break;
               if (cur > firstline) {
                  fprintf(stdout, "[%ldH   ", cur+3-firstline);
                  cur--;
                  fprintf(stdout, "[%ldH-->[%dH%4ld", cur+3-firstline, _WINROWS_, cur+1);
                  break;
               }
               else if (cur > firstline) break;
            case 'b':
            case '5':
               if (c == '5') c = 'b';
               if (cur < 0) break;
               num -= 2 * height;
               if (num < 0) num = 0;
               if (c == 'b') cur = num;
               else cur--;
               if (cur < 0) cur = 0;
               update = 2;
               break;
            case '':
               lastnum = read_pinfo(pmain, &incoming, PFTP_PEEK);
               if (lastnum > 0) endnum = lastnum - 1;
               if ((endnum - num < height)) {
                  num -= height;
                  if (num < 0) num = 0;
                  if (endnum && cur < 0) cur = 0;
               }
               update = 1;
               break;
            case 'l':
            case 'C':
               if (cur < 0) break;
               sprintf(cdir, "%s/%s", USERSTRING(cur), DATESTRING(cur));
               buf.st_mode = 0;
               if (stat(cdir, &buf) < 0) {
                  fprintf(stderr, "[%dH** %s: %s\n",
                  _WINROWS_, cdir, _PFTP_ERROR_ARRAY_);
               }
               if (**(pmain+cur) == 'N' || **(pmain+cur) == 'O') **(pmain+cur) = ' ';
               if (buf.st_mode & S_IFDIR) {
                  if ((int)(c = browse_dir(cdir)) >= 0) {
                     num -= height;
                     if (num < 0) num = 0;
                     update = 1;
                  }
                  else {
                     c = 'd';
                     update_last_line = 1;
                  }
               }
               if (CLEAR_TAG && (*(*(pmain+cur)+2) == '*')) *(*(pmain+cur)+2) = ' ';
               CLEAR_TAG = 0;
               break;
            case 't':
               if (cur < 0) break;
               if (*(*(pmain+cur)+2) == '*') *(*(pmain+cur)+2) = ' ';
               else {
                  *(*(pmain+cur)+2) = '*';
                  if (**(pmain+cur) != 'I' && **(pmain+cur) != 'D') **(pmain+cur) = ' ';
               }
               sprintf(cdir, "%s/%s", USERSTRING(cur), DATESTRING(cur));
               if ((j = set_entry_in_files(tfiles, cdir, &tlastentry)) >= 0) {
                  rm_entry_from_files(tfiles, *(tfiles+j), &tlastentry);
               }
               entry_date = atol(DATESTRING(cur));
               sprintf(cdir, " %s %.15s  %s  %s", 
               *(pmain+cur), asctime(localtime(&entry_date))+4, USERSTRING(cur),
               get_subject(subj, USERSTRING(cur), DATESTRING(cur)) ? subj: "");
               *(cdir+_WINCOLS_-4) = '\0';
               fprintf(stdout, "[%ldH-->%s[%dH", \
               cur+3-firstline, cdir, _WINROWS_);
               c = 'j';
               break;
            case 'd':
               if (cur < 0) {
                  c = 0;
                  break;
               }
               if (!skip_first) {
                  if (**(pmain+cur) == 'D') **(pmain+cur) = ' ';
                  else if (**(pmain+cur) != 'I') **(pmain+cur) = 'D';
               }
               skip_first = 0;
               sprintf(cdir, "%s/%s", USERSTRING(cur), DATESTRING(cur));
               if ((j = set_entry_in_files(dfiles, cdir, &dlastentry)) >= 0) {
                  rm_entry_from_files(dfiles, *(dfiles+j), &dlastentry);
               }
               entry_date = atol(DATESTRING(cur));
               sprintf(cdir, " %s %.15s  %s  %s", \
               *(pmain+cur), asctime(localtime(&entry_date))+4, USERSTRING(cur), \
               get_subject(subj, USERSTRING(cur), DATESTRING(cur)) ? subj: "");
               *(cdir+_WINCOLS_-4) = '\0';
               fprintf(stdout, "[%ldH-->%s[%dH", \
               cur+3-firstline, cdir, _WINROWS_);
               if (!update_last_line) c = 'j';
               else c = 0;
               break;
            case 'n':
            case 'N':
               if (cur < 0) break;
               if (**(pmain+cur) != 'N') {
                  if (**(pmain+cur) == 'D') {
                     c = 'd';
                     skip_first = 1;
                  }
                  **(pmain+cur) = 'N';
                  entry_date = atol(DATESTRING(cur));
                  sprintf(cdir, " %s %.15s  %s  %s", 
                  *(pmain+cur), asctime(localtime(&entry_date))+4, USERSTRING(cur),
                  get_subject(subj, USERSTRING(cur), DATESTRING(cur)) ? subj: "");
                  *(cdir+_WINCOLS_-4) = '\0';
                  fprintf(stdout, "[%ldH-->%s[%dH",
                  cur+3-firstline, cdir, _WINROWS_);
               }
               if (c != 'd') c = 'j';
               break;
            case '\n':
               if (cur < 0) break;
               sprintf(cdir, "%s/%s/%s", USERSTRING(cur), DATESTRING(cur), PFTP_INFO_FILE);
               entry_date = atol(DATESTRING(cur));
               sprintf(secondline, " From: %s   Date: %s", USERSTRING(cur), asctime(localtime(&entry_date))+4);
               for (ctmp=secondline; *ctmp && ctmp - secondline < _WINCOLS_; ctmp++);
               for (; ctmp - secondline < _WINCOLS_; ctmp++) *ctmp = ' ';
               *ctmp = '\0';
               buf.st_mode = 0;
               if (!stat(cdir, &buf) && pftp_pager(cdir, secondline, blankline)) {
                     num -= height;
                     if (num < 0) num = 0;
                     update = 1;
               }
               else {
                  fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
                  fprintf(stderr, "** No message file available.");
               }
               break;
            case 'S':
               if (cur < 0) break;
               sprintf(cdir, "%s/%s/%s", USERSTRING(cur), DATESTRING(cur), PFTP_INFO_FILE);
               buf.st_mode = 0;
               if (!stat(cdir, &buf) && (buf.st_mode & S_IFREG)) {
                  char *dest=NULL;
                  MEM_CHECK((ctmp = (char *)calloc(LONAME, sizeof(char))));
                  fprintf(stdout, "[?25h\r");
                  if ((dest = tabdir(curdir))) {
                     buf.st_mode = 0;
                     if (!stat(dest, &buf) && (buf.st_mode & S_IFDIR)) {
                        sprintf(ctmp, "%s/mesg_from_%s", dest, USERSTRING(cur));
                     }
                     else strcpy(ctmp, dest);
                     if (create_dir(dest, NULL)) {
                        fprintf(stderr, "%s", saving_str);
                        copy_file(cdir, ctmp);
                     }
                     rm_entry_from_files(dfiles, cdir, &dlastentry);
                  }
                  fprintf(stdout, "[?25l\r");
                  free(ctmp);
                  num -= height;
                  if (num < 0) num = 0;
                  update = 1;
               }
               else {
                  fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
                  fprintf(stderr, "** No message file available.");
               }
               break;
            case 's':
               if (cur < 0) break;
               for (j=0,tmp=tfiles; tmp - tfiles <= tlastentry; tmp++) {
                  buf.st_mode = 0;
                  if (*tmp && !stat(*tmp, &buf) && (buf.st_mode & S_IFREG)) {
                     j = 1;
                     break;
                  }
               }
               /*
                * Make cursor visible.
                */
               fprintf(stdout, "[?25h\r");
               if (j) {
                  fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
                  fprintf(stdout, " Save a) taged files  b) current directory  c) cancel: ");
                  while ((c = fgetc(stdin)) != 'a' && c != 'b' && c != 'c');
               }
               if (c != 'c') {
                  char *dest=NULL;
                  if ((dest = tabdir(curdir))) {
                     if (c == 'b' || !j) {
                        /*
                         * Save current directory.
                         */
                        sprintf(cdir, "%s/%s", USERSTRING(cur), DATESTRING(cur));
                        buf.st_mode = 0;
                        if (!stat(dest, &buf)) {
                           if (buf.st_mode & S_IFDIR) {
                              fprintf(stderr, "%s", saving_str);
                              save_dir(cdir, dest);
                           }
                           else {
                              fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
                              fprintf(stdout, "** `%s' is not a directory as needed.", dest);
                           }
                        }
                        else if (create_dir(dest, "")) {
                           fprintf(stderr, "%s", saving_str);
                           save_dir(cdir, dest);
                        }
                        c = 'd';
                     }
                     else if (create_dir(dest, "")) {
                        fprintf(stderr, "%s", saving_str);
                        save_tags(dest);
                        if (*(*(pmain+cur)+2) == '*') *(*(pmain+cur)+2) = ' ';
                     }
                  }
               }
               fprintf(stdout, "[?25l\r");
               (*statstr)->OVERWRITE = 0;
               (*statstr)->_SKIP_ = 0;
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
            case '?':
               mhelp();
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
            case 'w':
               warranty();
               num -= height;
               if (num < 0) num = 0;
               update = 1;
               break;
         }
      } while (c == 'j' || c == 'd');
   } while (c != 'q');
   unlink(Puni);
   unlink("lock");
   if (Puni) free(Puni);

   /*
    * Remove files from dfiles.
    */
   num = 0; 
   for (tmp=dfiles; tmp-dfiles <= dlastentry; tmp++) {
      if (*tmp) {
         num = 1;
         break;
      }
   }
   fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
   if (num) {
      fprintf(stdout, " Delete marked files (Y|n)? ");
      while ((c = fgetc(stdin)) != 'y' && c != 'Y' && c != 'n' && c != 'N' && c != '\n');
      if (c == 'y' || c == 'Y' || c == '\n') {
         for (tmp=dfiles; tmp - dfiles <= dlastentry; tmp++) {
            if (*tmp) {
               buf.st_mode = 0;
               if (!stat(*tmp, &buf)) {
                  if ((buf.st_mode & S_IFDIR) && empty_dir(*tmp)) rmdir(*tmp);
                  else unlink(*tmp);
               }
            }
         }
      }
      free_vec(dfiles);
   }
   free_vec(tfiles);

   if (subj) free(subj);
   if (curdir) free(curdir);
   if (blankline) free(blankline);
   if (saving_str) free(saving_str);
   if (lastline) free(lastline);
   if (headline) free(headline);
   if (cdir) free(cdir);
   /*
    * Remove empty `user@date' directories.
    */
   rm_empty_dirs();

   /*
    * Read and write `Pinfo'.
    */
   write_pinfo(pmain);

   fprintf(stdout, "[?25h\r");
   if (!(*statstr)->host_number) fprintf(stdout, "[%dH*** Have a nice day! ;^)                                              \r\n", _WINROWS_);
   set_tty(0);
}
