####################################################################################################################################
# CONFIG HELP DATA MODULE
#
# This module is automatically generated by doc.pl and should never be manually edited.
####################################################################################################################################
package pgBackRest::Config::ConfigHelpData;

use strict;
use warnings FATAL => qw(all);
use Carp qw(confess);

use Exporter qw(import);
    our @EXPORT = qw();

####################################################################################################################################
# Data used by the ConfigHelp module to generate command-line help
####################################################################################################################################
my $oConfigHelpData =
{
    # Option Help
    #-------------------------------------------------------------------------------------------------------------------------------
    option =>
    {
        # ARCHIVE-ASYNC Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-async' =>
        {
            section => 'archive',
            summary =>
                "Archive WAL segments asynchronously.",
            description =>
                "WAL segments will be copied to the local repo, then a process will be forked to compress the segment and " .
                    "transfer it to the remote repo if configured. Control will be returned to PostgreSQL as soon as the WAL " .
                    "segment is copied locally."
        },

        # ARCHIVE-CHECK Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-check' =>
        {
            section => 'backup',
            summary =>
                "Check that WAL segments are present in the archive before backup completes.",
            description =>
                "Checks that all WAL segments required to make the backup consistent are present in the WAL archive. It's a " .
                    "good idea to leave this as the default unless you are using another method for archiving."
        },

        # ARCHIVE-COPY Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-copy' =>
        {
            section => 'backup',
            summary =>
                "Copy WAL segments needed for consistency to the backup.",
            description =>
                "This slightly paranoid option protects against corruption or premature expiration in the WAL segment archive " .
                    "by storing the WAL segments directly in the backup. PITR won't be possible without the WAL segment archive " .
                    "and this option also consumes more space.\n" .
                "\n" .
                "Even though WAL segments will be restored with the backup, PostgreSQL will ignore them if a recovery.conf file " .
                    "exists and instead use archive_command to fetch WAL segments. Specifying type=none when restoring will not " .
                    "create recovery.conf and force PostgreSQL to use the WAL segments in pg_xlog. This will get the database " .
                    "cluster to a consistent state."
        },

        # ARCHIVE-MAX-MB Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-max-mb' =>
        {
            section => 'archive',
            summary =>
                "Limit size of the local asynchronous archive queue when archive-async=y.",
            description =>
                "After the limit is reached, the following will happen:\n" .
                "\n" .
                "* pgBackRest will notify Postgres that the archive was successfully backed up, then DROP IT.\n" .
                "* An error will be logged to the console and also to the Postgres log.\n" .
                "* A stop file will be written in the lock directory and no more archive files will be backed up until it is " .
                    "removed.\n" .
                "\n" .
                "If this occurs then the archive log stream will be interrupted and PITR will not be possible past that point. " .
                    "A new backup will be required to regain full restore capability.\n" .
                "\n" .
                "The purpose of this feature is to prevent the log volume from filling up at which point Postgres will stop " .
                    "completely. Better to lose the backup than have PostgreSQL go down.\n" .
                "\n" .
                "To start normal archiving again you'll need to remove the stop file which will be located at " .
                    "\${repo-path}/lock/\${stanza}-archive.stop where \${repo-path} is the path set in the general section, and " .
                    "\${stanza} is the backup stanza."
        },

        # ARCHIVE-TIMEOUT Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-timeout' =>
        {
            section => 'general',
            summary =>
                "Archive timeout.",
            description =>
                "Set maximum time, in seconds, to wait for WAL segments to reach the archive. The timeout applies to the check " .
                    "command and to the backup command when waiting for WAL segments required to make the backup consistent to " .
                    "be archived."
        },

        # BACKUP-HOST Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'backup-host' =>
        {
            section => 'backup',
            summary =>
                "Backup host when operating remotely via SSH.",
            description =>
                "Make sure that trusted SSH authentication is configured between the db host and the backup host.\n" .
                "\n" .
                "When backing up to a locally mounted network filesystem this setting is not required."
        },

        # BACKUP-USER Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'backup-user' =>
        {
            section => 'backup',
            summary =>
                "Backup host user when backup-host is set.",
            description =>
                "Defines the user that will be used for operations on the backup server. Preferably this is not the postgres " .
                    "user but rather some other user like backrest. If PostgreSQL runs on the backup server the postgres user " .
                    "can be placed in the backrest group so it has read permissions on the repository without being able to " .
                    "damage the contents accidentally."
        },

        # BUFFER-SIZE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'buffer-size' =>
        {
            section => 'general',
            summary =>
                "Buffer size for file operations.",
            description =>
                "Set the buffer size used for copy, compress, and uncompress functions. A maximum of 3 buffers will be in use " .
                    "at a time per thread. An additional maximum of 256K per thread may be used for zlib buffers."
        },

        # CMD-REMOTE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'cmd-remote' =>
        {
            section => 'command',
            summary =>
                "pgBackRest exe path on the remote host.",
            description =>
                "Required only if the path to pgbackrest is different on the local and remote systems. If not defined, the " .
                    "remote exe path will be set the same as the local exe path."
        },

        # COMPRESS Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'compress' =>
        {
            section => 'general',
            summary =>
                "Use gzip file compression.",
            description =>
                "Backup files are compatible with command-line gzip tools."
        },

        # COMPRESS-LEVEL Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'compress-level' =>
        {
            section => 'general',
            summary =>
                "Compression level for stored files.",
            description =>
                "Sets the zlib level to be used for file compression when compress=y."
        },

        # COMPRESS-LEVEL-NETWORK Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'compress-level-network' =>
        {
            section => 'general',
            summary =>
                "Compression level for network transfer when compress=n.",
            description =>
                "Sets the zlib level to be used for protocol compression when compress=n and the database cluster is not on the " .
                    "same host as the backup. Protocol compression is used to reduce network traffic but can be disabled by " .
                    "setting compress-level-network=0. When compress=y the compress-level-network setting is ignored and " .
                    "compress-level is used instead so that the file is only compressed once. SSH compression is always disabled."
        },

        # CONFIG Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'config' =>
        {
            summary =>
                "pgBackRest configuration file.",
            description =>
                "Use this option to specify a different configuration file than the default."
        },

        # CONFIG-REMOTE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'config-remote' =>
        {
            section => 'general',
            summary =>
                "pgBackRest remote configuration file.",
            description =>
                "Sets the location of the remote configuration file. This is only required if the remote configuration file is " .
                    "in a different location than the local configuration file."
        },

        # DB-HOST Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-host' =>
        {
            section => 'stanza',
            summary =>
                "Cluster host for operating remotely via SSH.",
            description =>
                "Used for backups where the database cluster host is different from the backup host."
        },

        # DB-INCLUDE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-include' =>
        {
            section => 'restore',
            summary =>
                "Restore only specified databases.",
            description =>
                "This feature allows only selected databases to be restored. Databases not specifically included will be " .
                    "restored as sparse, zeroed files to save space but still allow PostgreSQL to perform recovery. After " .
                    "recovery the databases that were not included will not be accessible but can be removed with the drop " .
                    "database command.\n" .
                "\n" .
                "Note that built-in databases (template0, template1, and postgres) are always restored.\n" .
                "\n" .
                "The --db-include option can be passed multiple times to specify more than one database to include."
        },

        # DB-PATH Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-path' =>
        {
            section => 'stanza',
            summary =>
                "Cluster data directory.",
            description =>
                "This should be the same as the data_directory setting in postgresql.conf. Even though this value can be read " .
                    "from postgresql.conf or the database cluster it is prudent to set it in case those resources are not " .
                    "available during a restore or offline backup scenario.\n" .
                "\n" .
                "The db-path option is tested against the value reported by PostgreSQL on every online backup so it should " .
                    "always be current."
        },

        # DB-PORT Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-port' =>
        {
            section => 'stanza',
            summary =>
                "Cluster port.",
            description =>
                "Port that PostgreSQL is running on. This usually does not need to be specified as most database clusters run " .
                    "on the default port."
        },

        # DB-SOCKET-PATH Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-socket-path' =>
        {
            section => 'stanza',
            summary =>
                "Cluster unix socket path.",
            description =>
                "The unix socket directory that was specified when PostgreSQL was started. pgBackRest will automatically look " .
                    "in the standard location for your OS so there usually no need to specify this setting unless the socket " .
                    "directory was explicitly modified with the unix_socket_directory setting in postgressql.conf."
        },

        # DB-TIMEOUT Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-timeout' =>
        {
            section => 'general',
            summary =>
                "Database query timeout.",
            description =>
                "Sets the timeout, in seconds, for queries against the database. This includes the pg_start_backup() and " .
                    "pg_stop_backup() functions which can each take a substantial amount of time. Because of this the timeout " .
                    "should be kept high unless you know that these functions will return quickly (i.e. if you have set " .
                    "startfast=y and you know that the database cluster will not generate many WAL segments during the backup)."
        },

        # DB-USER Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'db-user' =>
        {
            section => 'stanza',
            summary =>
                "Cluster host logon user when db-host is set.",
            description =>
                "This user will also own the remote pgBackRest process and will initiate connections to PostgreSQL. For this to " .
                    "work correctly the user should be the PostgreSQL database cluster owner which is generally postgres, the " .
                    "default."
        },

        # HARDLINK Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'hardlink' =>
        {
            section => 'backup',
            summary =>
                "Hardlink files between backups.",
            description =>
                "Enable hard-linking of files in differential and incremental backups to their full backups. This gives the " .
                    "appearance that each backup is a full backup. Be careful, though, because modifying files that are " .
                    "hard-linked can affect all the backups in the set."
        },

        # LINK-ALL Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'link-all' =>
        {
            section => 'restore',
            summary =>
                "Restore all symlinks.",
            description =>
                "By default symlinked directories and files are restored as normal directories and files in \$PGDATA. This is " .
                    "because it may not be safe to restore symlinks to their original destinations on a system other than where " .
                    "the original backup was performed. This option restores all the symlinks just as they were on the original " .
                    "system where the backup was performed."
        },

        # LINK-MAP Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'link-map' =>
        {
            section => 'restore',
            summary =>
                "Modify the destination of a symlink.",
            description =>
                "Allows the destination file or path of a symlink to be changed on restore. This is useful for restoring to " .
                    "systems that have a different storage layout than the original system where the backup was generated."
        },

        # LOCK-PATH Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'lock-path' =>
        {
            section => 'general',
            summary =>
                "Path where lock files are stored.",
            description =>
                "The lock path provides a location for pgBackRest to create lock files to prevent conflicting operations from " .
                    "being run concurrently."
        },

        # LOG-LEVEL-CONSOLE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'log-level-console' =>
        {
            section => 'log',
            summary =>
                "Level for console logging.",
            description =>
                "The following log levels are supported:\n" .
                "\n" .
                "* off - No logging at all (not recommended)\n" .
                "* error - Log only errors\n" .
                "* warn - Log warnings and errors\n" .
                "* info - Log info, warnings, and errors\n" .
                "* detail - Log detail, info, warnings, and errors\n" .
                "* debug - Log debug, detail, info, warnings, and errors\n" .
                "* trace - Log trace (very verbose debugging), debug, info, warnings, and errors"
        },

        # LOG-LEVEL-FILE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'log-level-file' =>
        {
            section => 'log',
            summary =>
                "Level for file logging.",
            description =>
                "The following log levels are supported:\n" .
                "\n" .
                "* off - No logging at all (not recommended)\n" .
                "* error - Log only errors\n" .
                "* warn - Log warnings and errors\n" .
                "* info - Log info, warnings, and errors\n" .
                "* detail - Log detail, info, warnings, and errors\n" .
                "* debug - Log debug, detail, info, warnings, and errors\n" .
                "* trace - Log trace (very verbose debugging), debug, info, warnings, and errors"
        },

        # LOG-PATH Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'log-path' =>
        {
            section => 'general',
            summary =>
                "Path where log files are stored.",
            description =>
                "The log path provides a location for pgBackRest to store log files. Note that if log-level-file=none then no " .
                    "log path is required."
        },

        # MANIFEST-SAVE-THRESHOLD Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'manifest-save-threshold' =>
        {
            section => 'backup',
            summary =>
                "Manifest save threshold during backup.",
            description =>
                "Defines how often the manifest will be saved during a backup (in bytes). Saving the manifest is important " .
                    "because it stores the checksums and allows the resume function to work efficiently. The actual threshold " .
                    "used is 1% of the backup size or manifest-save-threshold, whichever is greater."
        },

        # NEUTRAL-UMASK Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'neutral-umask' =>
        {
            section => 'general',
            summary =>
                "Use a neutral umask.",
            description =>
                "Sets the umask to 0000 so modes in the repository are created in a sensible way. The default directory mode is " .
                    "0750 and default file mode is 0640. The lock and log directories set the directory and file mode to 0770 " .
                    "and 0660 respectively.\n" .
                "\n" .
                "To use the executing user's umask instead specify neutral-umask=n in the config file or --no-neutral-umask on " .
                    "the command line."
        },

        # ONLINE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'online' =>
        {
            summary =>
                "Perform an online backup.",
            description =>
                "Specifying --no-online prevents pgBackRest from running pg_start_backup() and pg_stop_backup() on the database " .
                    "cluster. In order for this to work PostgreSQL should be shut down and pgBackRest will generate an error if " .
                    "it is not.\n" .
                "\n" .
                "The purpose of this option is to allow offline backups. The pg_xlog directory is copied as-is and " .
                    "archive-check is automatically disabled for the backup."
        },

        # PROTOCOL-TIMEOUT Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'protocol-timeout' =>
        {
            section => 'general',
            summary =>
                "Protocol timeout.",
            description =>
                "Sets the timeout, in seconds, that the master or remote process will wait for a new message to be received on " .
                    "the protocol layer. This prevents processes from waiting indefinitely for a message. The protocol-timeout " .
                    "option must be greater than the db-timeout option."
        },

        # RECOVERY-OPTION Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'recovery-option' =>
        {
            section => 'restore',
            summary =>
                "Set an option in recovery.conf.",
            description =>
                "See http://www.postgresql.org/docs/X.X/static/recovery-config.html for details on recovery.conf options " .
                    "(replace X.X with your PostgreSQL version). This option can be used multiple times.\n" .
                "\n" .
                "Note: The restore_command option will be automatically generated but can be overridden with this option. Be " .
                    "careful about specifying your own restore_command as pgBackRest is designed to handle this for you. Target " .
                    "Recovery options (recovery_target_name, recovery_target_time, etc.) are generated automatically by " .
                    "pgBackRest and should not be set with this option.\n" .
                "\n" .
                "Since pgBackRest does not start PostgreSQL after writing the recovery.conf file, it is always possible to " .
                    "edit/check recovery.conf before manually restarting."
        },

        # REPO-PATH Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'repo-path' =>
        {
            section => 'general',
            summary =>
                "Repository path where WAL segments and backups stored.",
            description =>
                "The repository is where pgBackRest stores backup and archives WAL segments.\n" .
                "\n" .
                "If you are new to backup then it will be difficult to estimate in advance how much space you'll need. The best " .
                    "thing to do is take some backups then record the size of different types of backups (full/incr/diff) and " .
                    "measure the amount of WAL generated per day. This will give you a general idea of how much space you'll " .
                    "need, though of course requirements will likely change over time as your database evolves."
        },

        # RESUME Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'resume' =>
        {
            section => 'backup',
            summary =>
                "Allow resume of failed backup.",
            description =>
                "Defines whether the resume feature is enabled. Resume can greatly reduce the amount of time required to run a " .
                    "backup after a previous backup of the same type has failed. It adds complexity, however, so it may be " .
                    "desirable to disable in environments that do not require the feature."
        },

        # RETENTION-ARCHIVE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'retention-archive' =>
        {
            section => 'expire',
            summary =>
                "Number of backups worth of WAL to retain.",
            description =>
                "Number of backups worth of archive log to keep."
        },

        # RETENTION-ARCHIVE-TYPE Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'retention-archive-type' =>
        {
            section => 'expire',
            summary =>
                "Backup type for WAL retention.",
            description =>
                "If set to full pgBackRest will keep archive logs for the number of full backups defined by retention-archive. " .
                    "If set to diff (differential) pgBackRest will keep archive logs for the number of full and differential " .
                    "backups defined by retention-archive. If set to incr (incremental) pgBackRest will keep archive logs for " .
                    "the number of full, differential, and incremental backups defined by retention-archive."
        },

        # RETENTION-DIFF Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'retention-diff' =>
        {
            section => 'expire',
            summary =>
                "Number of differential backups to retain.",
            description =>
                "When a differential backup expires, all incremental backups associated with the differential backup will also " .
                    "expire. When not defined all differential backups will be kept until the full backups they depend on expire."
        },

        # RETENTION-FULL Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'retention-full' =>
        {
            section => 'expire',
            summary =>
                "Number of full backups to retain.",
            description =>
                "When a full backup expires, all differential and incremental backups associated with the full backup will also " .
                    "expire. When not defined then all full backups will be kept."
        },

        # SPOOL-PATH Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'spool-path' =>
        {
            section => 'general',
            summary =>
                "Path where WAL segments are spooled during async archiving.",
            description =>
                "When asynchronous archiving is enabled pgBackRest needs a local directory to store WAL segments before they " .
                    "are compressed and moved to the repository. Depending on the volume of WAL generated this directory could " .
                    "become very large so be sure to plan accordingly.\n" .
                "\n" .
                "The max-archive-mb option can be used to limit the amount of WAL that will be spooled locally."
        },

        # STANZA Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'stanza' =>
        {
            summary =>
                "Command stanza.",
            description =>
                "A stanza is the configuration for a PostgreSQL database cluster that defines where it is located, how it will " .
                    "be backed up, archiving options, etc. Most db servers will only have one Postgres database cluster and " .
                    "therefore one stanza, whereas backup servers will have a stanza for every database cluster that needs to " .
                    "be backed up.\n" .
                "\n" .
                "It is tempting to name the stanza after the primary cluster but a better name describes the databases " .
                    "contained in the cluster. Because the stanza name will be used for the primary and all replicas it is more " .
                    "appropriate to choose a name that describes the actual function of the cluster, such as app or dw, rather " .
                    "than the local cluster name, such as main or prod."
        },

        # START-FAST Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'start-fast' =>
        {
            section => 'backup',
            summary =>
                "Force a checkpoint to start backup quickly.",
            description =>
                "Forces a checkpoint (by passing y to the fast parameter of pg_start_backup()) so the backup begins " .
                    "immediately. Otherwise the backup will start after the next regular checkpoint.\n" .
                "\n" .
                "This feature only works in PostgreSQL >= 8.4."
        },

        # STOP-AUTO Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'stop-auto' =>
        {
            section => 'backup',
            summary =>
                "Stop prior failed backup on new backup.",
            description =>
                "This will only be done if an exclusive advisory lock can be acquired to demonstrate that the prior failed " .
                    "backup process has really stopped.\n" .
                "\n" .
                "This feature relies on pg_is_in_backup() so only works on PostgreSQL >= 9.3.\n" .
                "\n" .
                "The setting is disabled by default because it assumes that pgBackRest is the only process doing exclusive " .
                    "online backups. It depends on an advisory lock that only pgBackRest sets so it may abort other processes " .
                    "that do exclusive online backups. Note that base_backup and pg_dump are safe to use with this setting " .
                    "because they do not call pg_start_backup() so are not exclusive."
        },

        # TABLESPACE-MAP Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'tablespace-map' =>
        {
            section => 'restore',
            summary =>
                "Restore a tablespace into the specified directory.",
            description =>
                "Moves a tablespace to a new location during the restore. This is useful when tablespace locations are not the " .
                    "same on a replica, or an upgraded system has different mount points.\n" .
                "\n" .
                "Since PostgreSQL 9.2 tablespace locations are not stored in pg_tablespace so moving tablespaces can be done " .
                    "with impunity. However, moving a tablespace to the data_directory is not recommended and may cause " .
                    "problems. For more information on moving tablespaces " .
                    "http://www.databasesoup.com/2013/11/moving-tablespaces.html is a good resource."
        },

        # TABLESPACE-MAP-ALL Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'tablespace-map-all' =>
        {
            section => 'restore',
            summary =>
                "Restore all tablespaces into the specified directory.",
            description =>
                "By default tablespaces are restored into their original locations and while this behavior can be modified by " .
                    "with the tablespace-map open it is sometime preferable to remap all tablespaces to a new directory all at " .
                    "once. This is particularly useful for development or staging systems that may not have the same storage " .
                    "layout as the original system where the backup was generated.\n" .
                "\n" .
                "The path specified will be the parent path used to create all the tablespaces in the backup."
        },

        # THREAD-MAX Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'thread-max' =>
        {
            section => 'general',
            summary =>
                "Max threads to use in process.",
            description =>
                "Each thread will perform compression and transfer to make the command run faster, but don't set thread-max so " .
                    "high that it impacts database performance."
        },

        # THREAD-TIMEOUT Option Help
        #---------------------------------------------------------------------------------------------------------------------------
        'thread-timeout' =>
        {
            section => 'general',
            summary =>
                "Max time a thread can run.",
            description =>
                "This limits the amount of time (in seconds) that a thread might be stuck due to unforeseen issues executing " .
                    "the command. Has no affect when thread-max=1."
        }
    },

    # Command Help
    #-------------------------------------------------------------------------------------------------------------------------------
    command =>
    {
        # ARCHIVE-GET Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-get' =>
        {
            summary =>
                "Get a WAL segment from the archive.",
            description =>
                "WAL segments are required for restoring a PostgreSQL cluster or maintaining a replica.",

            option =>
            {
                'backup-host' => 'section',
                'backup-user' => 'section',
                'buffer-size' => 'section',
                'cmd-remote' => 'section',
                'compress' => 'section',
                'compress-level' => 'section',
                'compress-level-network' => 'section',
                'config' => 'default',
                'config-remote' => 'section',
                'db-path' => 'section',
                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'neutral-umask' => 'section',
                'protocol-timeout' => 'section',
                'repo-path' => 'section',
                'stanza' => 'default'
            }
        },

        # ARCHIVE-PUSH Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'archive-push' =>
        {
            summary =>
                "Push a WAL segment to the archive.",
            description =>
                "The WAL segment may be pushed immediately to the archive or stored locally depending on the value of " .
                    "archive-async",

            option =>
            {
                'archive-async' => 'section',
                'archive-max-mb' => 'section',
                'backup-host' => 'section',
                'backup-user' => 'section',
                'buffer-size' => 'section',
                'cmd-remote' => 'section',
                'compress' => 'section',
                'compress-level' => 'section',
                'compress-level-network' => 'section',
                'config' => 'default',
                'config-remote' => 'section',
                'db-path' => 'section',
                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'neutral-umask' => 'section',
                'protocol-timeout' => 'section',
                'repo-path' => 'section',
                'spool-path' => 'section',
                'stanza' => 'default'
            }
        },

        # BACKUP Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'backup' =>
        {
            summary =>
                "Backup a database cluster.",
            description =>
                "pgBackRest does not have a built-in scheduler so it's best to run it from cron or some other scheduling " .
                    "mechanism.",

            option =>
            {
                'archive-check' => 'section',
                'archive-copy' => 'section',
                'archive-timeout' => 'section',
                'backup-host' => 'section',
                'buffer-size' => 'section',
                'cmd-remote' => 'section',
                'compress' => 'section',
                'compress-level' => 'section',
                'compress-level-network' => 'section',
                'config' => 'default',
                'config-remote' => 'section',
                'db-host' => 'section',
                'db-path' => 'section',
                'db-port' => 'section',
                'db-socket-path' => 'section',
                'db-timeout' => 'section',
                'db-user' => 'section',

                # FORCE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'force' =>
                {
                    summary =>
                        "Force an offline backup.",
                    description =>
                        "When used with --no-start-stop a backup will be run even if pgBackRest thinks that PostgreSQL is " .
                            "running. This option should be used with extreme care as it will likely result in a bad backup.\n" .
                        "\n" .
                        "There are some scenarios where a backup might still be desirable under these conditions. For example, " .
                            "if a server crashes and the database cluster volume can only be mounted read-only, it would be a " .
                            "good idea to take a backup even if postmaster.pid is present. In this case it would be better to " .
                            "revert to the prior backup and replay WAL, but possibly there is a very important transaction in a " .
                            "WAL segment that did not get archived."
                },

                'hardlink' => 'section',
                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'manifest-save-threshold' => 'section',
                'neutral-umask' => 'section',
                'online' => 'default',
                'protocol-timeout' => 'section',
                'repo-path' => 'section',
                'resume' => 'section',
                'retention-archive' => 'section',
                'retention-archive-type' => 'section',
                'retention-diff' => 'section',
                'retention-full' => 'section',
                'stanza' => 'default',
                'start-fast' => 'section',
                'stop-auto' => 'section',
                'thread-max' => 'section',
                'thread-timeout' => 'section',

                # TYPE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'type' =>
                {
                    summary =>
                        "Backup type.",
                    description =>
                        "The following backup types are supported:\n" .
                        "\n" .
                        "* full - all database cluster files will be copied and there will be no dependencies on previous " .
                            "backups.\n" .
                        "* incr - incremental from the last successful backup.\n" .
                        "* diff - like an incremental backup but always based on the last full backup."
                }
            }
        },

        # CHECK Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'check' =>
        {
            summary =>
                "Check the configuration.",
            description =>
                "The check command validates that pgBackRest and the archive_command setting are configured correctly for " .
                    "archiving and backups. It detects misconfigurations, particularly in archiving, that result in incomplete " .
                    "backups because required WAL segments did not reach the archive. The command can be run on the database or " .
                    "the backup host.\n" .
                "\n" .
                "Note that pg_create_restore_point('pgBackRest Archive Check') and pg_switch_xlog() are called to force " .
                    "PostgreSQL to archive a WAL segment. Restore points are only supported in PostgreSQL >= 9.1 so for older " .
                    "versions the check command may fail if there has been no write activity since the last log rotation.",

            option =>
            {
                'archive-check' => 'section',
                'archive-timeout' => 'section',
                'backup-host' => 'section',
                'backup-user' => 'section',
                'buffer-size' => 'section',
                'cmd-remote' => 'section',
                'compress-level' => 'section',
                'compress-level-network' => 'section',
                'config' => 'default',
                'config-remote' => 'section',
                'db-host' => 'section',
                'db-path' => 'section',
                'db-port' => 'section',
                'db-socket-path' => 'section',
                'db-timeout' => 'section',
                'db-user' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'neutral-umask' => 'section',
                'online' => 'default',
                'protocol-timeout' => 'section',
                'repo-path' => 'section',
                'stanza' => 'default'
            }
        },

        # EXPIRE Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'expire' =>
        {
            summary =>
                "Expire backups that exceed retention.",
            description =>
                "pgBackRest does backup rotation but is not concerned with when the backups were created. If two full backups " .
                    "are configured for retention, pgBackRest will keep two full backups no matter whether they occur two hours " .
                    "or two weeks apart.",

            option =>
            {
                'backup-host' => 'section',
                'config' => 'default',
                'db-host' => 'section',
                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'repo-path' => 'section',
                'retention-archive' => 'section',
                'retention-archive-type' => 'section',
                'retention-diff' => 'section',
                'retention-full' => 'section',
                'stanza' => 'default'
            }
        },

        # HELP Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'help' =>
        {
            summary =>
                "Get help.",
            description =>
                "Three levels of help are provided. If no command is specified then general help will be displayed. If a " .
                    "command is specified then a full description of the command will be displayed along with a list of valid " .
                    "options. If an option is specified in addition to a command then the a full description of the option as " .
                    "it applies to the command will be displayed.",

        },

        # INFO Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'info' =>
        {
            summary =>
                "Retrieve information about backups.",
            description =>
                "The info command operates on a single stanza or all stanzas. Text output is the default and gives a " .
                    "human-readable summary of backups for the stanza(s) requested. This format is subject to change with any " .
                    "release.\n" .
                "\n" .
                "For machine-readable output use --output=json. The JSON output contains far more information than the text " .
                    "output, however this feature is currently experimental so the format may change between versions.",

            option =>
            {
                'backup-host' => 'section',
                'backup-user' => 'section',
                'buffer-size' => 'section',
                'cmd-remote' => 'section',
                'compress-level' => 'section',
                'compress-level-network' => 'section',
                'config' => 'default',
                'config-remote' => 'section',
                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',

                # OUTPUT Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'output' =>
                {
                    summary =>
                        "Output format.",
                    description =>
                        "The following output types are supported:\n" .
                        "\n" .
                        "* text - Human-readable summary of backup information.\n" .
                        "* json - Exhaustive machine-readable backup information in JSON format."
                },

                'protocol-timeout' => 'section',
                'repo-path' => 'section',
                'stanza' => 'default'
            }
        },

        # RESTORE Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'restore' =>
        {
            summary =>
                "Restore a database cluster.",
            description =>
                "This command is generally run manually, but there are instances where it might be automated.",

            option =>
            {
                'backup-host' => 'section',
                'backup-user' => 'section',
                'buffer-size' => 'section',
                'cmd-remote' => 'section',
                'compress' => 'section',
                'compress-level' => 'section',
                'compress-level-network' => 'section',
                'config' => 'default',
                'config-remote' => 'section',
                'db-include' => 'section',
                'db-path' => 'section',

                # DELTA Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'delta' =>
                {
                    summary =>
                        "Restore using delta.",
                    description =>
                        "By default the PostgreSQL data and tablespace directories are expected to be present but empty. This " .
                            "option performs a delta restore using checksums."
                },

                # FORCE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'force' =>
                {
                    summary =>
                        "Force a restore.",
                    description =>
                        "By itself this option forces the PostgreSQL data and tablespace paths to be completely overwritten. In " .
                            "combination with --delta a timestamp/size delta will be performed instead of using checksums."
                },

                'link-all' => 'section',
                'link-map' => 'section',

                # LOCK Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'lock' =>
                {
                    summary =>
                        "Create a lock so restores on a stanza cannot run simultaneously.",
                    description =>
                        "Locking during restores is enabled by default but can be disabled using --no-lock. Be very careful " .
                            "when disabling this option because simultaneous restores to a single path might result in a " .
                            "corrupt cluster."
                },

                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'neutral-umask' => 'section',
                'protocol-timeout' => 'section',
                'recovery-option' => 'section',
                'repo-path' => 'section',

                # SET Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'set' =>
                {
                    summary =>
                        "Backup set to restore.",
                    description =>
                        "The backup set to be restored. latest will restore the latest backup, otherwise provide the name of " .
                            "the backup to restore."
                },

                'stanza' => 'default',
                'tablespace-map' => 'section',
                'tablespace-map-all' => 'section',

                # TARGET Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'target' =>
                {
                    summary =>
                        "Recovery target.",
                    description =>
                        "Defines the recovery target when --type is name, xid, or time."
                },

                # TARGET-ACTION Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'target-action' =>
                {
                    summary =>
                        "Action to take when recovery target is reached.",
                    description =>
                        "The following actions are supported:\n" .
                        "\n" .
                        "* pause - pause when recovery target is reached.\n" .
                        "* promote - promote and switch timeline when recovery target is reached.\n" .
                        "* shutdown - shutdown server when recovery target is reached.\n" .
                        "\n" .
                        "This option is only supported on PostgreSQL >= 9.5."
                },

                # TARGET-EXCLUSIVE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'target-exclusive' =>
                {
                    summary =>
                        "Stop just before the recovery target is reached.",
                    description =>
                        "Defines whether recovery to the target would be exclusive (the default is inclusive) and is only valid " .
                            "when --type is time or xid. For example, using --target-exclusive would exclude the contents of " .
                            "transaction 1007 when --type=xid and --target=1007. See the recovery_target_inclusive option in " .
                            "the PostgreSQL docs for more information."
                },

                # TARGET-TIMELINE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'target-timeline' =>
                {
                    summary =>
                        "Recover along a timeline.",
                    description =>
                        "See recovery_target_timeline in the PostgreSQL docs for more information."
                },

                'thread-max' => 'section',
                'thread-timeout' => 'section',

                # TYPE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'type' =>
                {
                    summary =>
                        "Recovery type.",
                    description =>
                        "The following recovery types are supported:\n" .
                        "\n" .
                        "* default - recover to the end of the archive stream.\n" .
                        "* immediate - recover only until the database becomes consistent. This option is only supported on " .
                            "PostgreSQL >= 9.4.\n" .
                        "* name - recover the restore point specified in --target.\n" .
                        "* xid - recover to the transaction id specified in --target.\n" .
                        "* time - recover to the time specified in --target.\n" .
                        "* preserve - preserve the existing recovery.conf file.\n" .
                        "* none - no recovery.conf file is written so PostgreSQL will attempt to achieve consistency using WAL " .
                            "segments present in pg_xlog. Provide the required WAL segments or use the archive-copy setting to " .
                            "include them with the backup."
                }
            }
        },

        # START Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'start' =>
        {
            summary =>
                "Allow pgBackRest processes to run.",
            description =>
                "If the pgBackRest processes were previously stopped using the stop command then they can be started again " .
                    "using the start command. Note that this will not immediately start up any pgBackRest processes but they " .
                    "are allowed to run.",

            option =>
            {
                'backup-host' => 'section',
                'config' => 'default',
                'db-host' => 'section',
                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'repo-path' => 'section',
                'stanza' => 'default'
            }
        },

        # STOP Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'stop' =>
        {
            summary =>
                "Stop pgBackRest processes from running.",
            description =>
                "Does not allow any new pgBackRest processes to run. By default running processes will be allowed to complete " .
                    "successfully. Use the --force option to terminate running processes.\n" .
                "\n" .
                "pgBackRest processes will return an error if they are run after the stop command completes.",

            option =>
            {
                'backup-host' => 'section',
                'config' => 'default',
                'db-host' => 'section',

                # FORCE Option Help
                #-------------------------------------------------------------------------------------------------------------------
                'force' =>
                {
                    summary =>
                        "Force all pgBackRest processes to stop.",
                    description =>
                        "This option will send TERM signals to all running pgBackRest processes to effect a graceful but " .
                            "immediate shutdown. Note that this will also shutdown processes that were initiated on another " .
                            "system but have remotes running on the current system. For instance, if a backup was started on " .
                            "the backup server then running stop --force on the database server will shutdown the backup " .
                            "process on the backup server."
                },

                'lock-path' => 'section',
                'log-level-console' => 'section',
                'log-level-file' => 'section',
                'log-path' => 'section',
                'repo-path' => 'section',
                'stanza' => 'default'
            }
        },

        # VERSION Command Help
        #---------------------------------------------------------------------------------------------------------------------------
        'version' =>
        {
            summary =>
                "Get version.",
            description =>
                "Displays installed pgBackRest version.",

        }
    }
};

####################################################################################################################################
# configHelpDataGet
####################################################################################################################################
sub configHelpDataGet
{
    return $oConfigHelpData;
}

push @EXPORT, qw(configHelpDataGet);

1;
