/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSWebGLRenderingContext_h
#define JSWebGLRenderingContext_h

#if ENABLE(WEBGL)

#include "JSCanvasRenderingContext.h"
#include <runtime/JSObjectWithGlobalObject.h>

namespace WebCore {

class WebGLRenderingContext;

class JSWebGLRenderingContext : public JSCanvasRenderingContext {
    typedef JSCanvasRenderingContext Base;
public:
    JSWebGLRenderingContext(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<WebGLRenderingContext>);
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }

    virtual void visitChildren(JSC::SlotVisitor&);

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue getAttachedShaders(JSC::ExecState*);
    JSC::JSValue getBufferParameter(JSC::ExecState*);
    JSC::JSValue getExtension(JSC::ExecState*);
    JSC::JSValue getFramebufferAttachmentParameter(JSC::ExecState*);
    JSC::JSValue getParameter(JSC::ExecState*);
    JSC::JSValue getProgramParameter(JSC::ExecState*);
    JSC::JSValue getRenderbufferParameter(JSC::ExecState*);
    JSC::JSValue getShaderParameter(JSC::ExecState*);
    JSC::JSValue getSupportedExtensions(JSC::ExecState*);
    JSC::JSValue getTexParameter(JSC::ExecState*);
    JSC::JSValue getUniform(JSC::ExecState*);
    JSC::JSValue getVertexAttrib(JSC::ExecState*);
    JSC::JSValue uniform1fv(JSC::ExecState*);
    JSC::JSValue uniform1iv(JSC::ExecState*);
    JSC::JSValue uniform2fv(JSC::ExecState*);
    JSC::JSValue uniform2iv(JSC::ExecState*);
    JSC::JSValue uniform3fv(JSC::ExecState*);
    JSC::JSValue uniform3iv(JSC::ExecState*);
    JSC::JSValue uniform4fv(JSC::ExecState*);
    JSC::JSValue uniform4iv(JSC::ExecState*);
    JSC::JSValue uniformMatrix2fv(JSC::ExecState*);
    JSC::JSValue uniformMatrix3fv(JSC::ExecState*);
    JSC::JSValue uniformMatrix4fv(JSC::ExecState*);
    JSC::JSValue vertexAttrib1fv(JSC::ExecState*);
    JSC::JSValue vertexAttrib2fv(JSC::ExecState*);
    JSC::JSValue vertexAttrib3fv(JSC::ExecState*);
    JSC::JSValue vertexAttrib4fv(JSC::ExecState*);
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};


class JSWebGLRenderingContextPrototype : public JSC::JSObjectWithGlobalObject {
    typedef JSC::JSObjectWithGlobalObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
    JSWebGLRenderingContextPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure) : JSC::JSObjectWithGlobalObject(globalData, globalObject, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionActiveTexture(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionAttachShader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindAttribLocation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindFramebuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindRenderbuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindTexture(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendColor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendEquation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendEquationSeparate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendFunc(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendFuncSeparate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBufferData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBufferSubData(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCheckFramebufferStatus(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClear(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClearColor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClearDepth(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClearStencil(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionColorMask(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCompileShader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCopyTexImage2D(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCopyTexSubImage2D(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateFramebuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateProgram(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateRenderbuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateShader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateTexture(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCullFace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteFramebuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteProgram(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteRenderbuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteShader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteTexture(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDepthFunc(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDepthMask(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDepthRange(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDetachShader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDisable(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDisableVertexAttribArray(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDrawArrays(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDrawElements(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionEnable(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionEnableVertexAttribArray(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFinish(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFlush(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFramebufferRenderbuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFramebufferTexture2D(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFrontFace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGenerateMipmap(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetActiveAttrib(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetActiveUniform(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetAttachedShaders(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetAttribLocation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetBufferParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetContextAttributes(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetError(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetExtension(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetFramebufferAttachmentParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetProgramParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetProgramInfoLog(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetRenderbufferParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetShaderParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetShaderInfoLog(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetShaderSource(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetSupportedExtensions(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetTexParameter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetUniform(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetUniformLocation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetVertexAttrib(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetVertexAttribOffset(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionHint(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsBuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsContextLost(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsEnabled(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsFramebuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsProgram(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsRenderbuffer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsShader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsTexture(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionLineWidth(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionLinkProgram(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionPixelStorei(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionPolygonOffset(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionReadPixels(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionReleaseShaderCompiler(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionRenderbufferStorage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionSampleCoverage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionScissor(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionShaderSource(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilFunc(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilFuncSeparate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilMask(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilMaskSeparate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilOp(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilOpSeparate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexParameterf(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexParameteri(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexImage2D(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexSubImage2D(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1i(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1iv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2i(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2iv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3i(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3iv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4i(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4iv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniformMatrix2fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniformMatrix3fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniformMatrix4fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUseProgram(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionValidateProgram(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib1f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib1fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib2f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib2fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib3f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib3fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib4f(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib4fv(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttribPointer(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionViewport(JSC::ExecState*);
// Attributes

JSC::JSValue jsWebGLRenderingContextConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
// Constants

JSC::JSValue jsWebGLRenderingContextDEPTH_BUFFER_BIT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BUFFER_BIT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCOLOR_BUFFER_BIT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextPOINTS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINES(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINE_LOOP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINE_STRIP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTRIANGLES(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTRIANGLE_STRIP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTRIANGLE_FAN(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextZERO(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSRC_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_SRC_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSRC_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_SRC_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDST_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_DST_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDST_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_DST_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSRC_ALPHA_SATURATE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFUNC_ADD(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_EQUATION(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_EQUATION_RGB(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_EQUATION_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFUNC_SUBTRACT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFUNC_REVERSE_SUBTRACT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_DST_RGB(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_SRC_RGB(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_DST_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_SRC_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCONSTANT_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_CONSTANT_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCONSTANT_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_CONSTANT_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND_COLOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextARRAY_BUFFER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextELEMENT_ARRAY_BUFFER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextARRAY_BUFFER_BINDING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextELEMENT_ARRAY_BUFFER_BINDING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTREAM_DRAW(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTATIC_DRAW(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDYNAMIC_DRAW(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBUFFER_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBUFFER_USAGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCURRENT_VERTEX_ATTRIB(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRONT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBACK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRONT_AND_BACK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_2D(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCULL_FACE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLEND(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDITHER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_TEST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_TEST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSCISSOR_TEST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextPOLYGON_OFFSET_FILL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_ALPHA_TO_COVERAGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_COVERAGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNO_ERROR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINVALID_ENUM(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINVALID_VALUE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINVALID_OPERATION(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextOUT_OF_MEMORY(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCW(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCCW(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINE_WIDTH(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextALIASED_POINT_SIZE_RANGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextALIASED_LINE_WIDTH_RANGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCULL_FACE_MODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRONT_FACE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_RANGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_WRITEMASK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_CLEAR_VALUE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_FUNC(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_CLEAR_VALUE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_FUNC(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_FAIL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_PASS_DEPTH_FAIL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_PASS_DEPTH_PASS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_REF(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_VALUE_MASK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_WRITEMASK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_FUNC(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_FAIL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_PASS_DEPTH_FAIL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_PASS_DEPTH_PASS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_REF(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_VALUE_MASK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_WRITEMASK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVIEWPORT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSCISSOR_BOX(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCOLOR_CLEAR_VALUE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCOLOR_WRITEMASK(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNPACK_ALIGNMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextPACK_ALIGNMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_TEXTURE_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_VIEWPORT_DIMS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSUBPIXEL_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRED_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextGREEN_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBLUE_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextALPHA_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextPOLYGON_OFFSET_UNITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextPOLYGON_OFFSET_FACTOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_BINDING_2D(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_BUFFERS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLES(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_COVERAGE_VALUE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_COVERAGE_INVERT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNUM_COMPRESSED_TEXTURE_FORMATS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCOMPRESSED_TEXTURE_FORMATS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDONT_CARE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFASTEST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNICEST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextGENERATE_MIPMAP_HINT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBYTE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_BYTE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSHORT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_INT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_COMPONENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRGB(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRGBA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLUMINANCE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLUMINANCE_ALPHA(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT_4_4_4_4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT_5_5_5_1(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT_5_6_5(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAGMENT_SHADER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_SHADER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_VERTEX_ATTRIBS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_VERTEX_UNIFORM_VECTORS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_VARYING_VECTORS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_COMBINED_TEXTURE_IMAGE_UNITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_VERTEX_TEXTURE_IMAGE_UNITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_TEXTURE_IMAGE_UNITS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_FRAGMENT_UNIFORM_VECTORS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSHADER_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDELETE_STATUS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINK_STATUS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVALIDATE_STATUS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextATTACHED_SHADERS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextACTIVE_UNIFORMS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextACTIVE_ATTRIBUTES(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSHADING_LANGUAGE_VERSION(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCURRENT_PROGRAM(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNEVER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLESS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextEQUAL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLEQUAL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextGREATER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNOTEQUAL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextGEQUAL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextALWAYS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextKEEP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextREPLACE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINCR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDECR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINVERT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINCR_WRAP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDECR_WRAP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVENDOR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERSION(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNEAREST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINEAR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNEAREST_MIPMAP_NEAREST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINEAR_MIPMAP_NEAREST(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNEAREST_MIPMAP_LINEAR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLINEAR_MIPMAP_LINEAR(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_MAG_FILTER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_MIN_FILTER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_WRAP_S(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_WRAP_T(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_BINDING_CUBE_MAP(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_POSITIVE_X(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_NEGATIVE_X(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_POSITIVE_Y(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_NEGATIVE_Y(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_POSITIVE_Z(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_NEGATIVE_Z(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_CUBE_MAP_TEXTURE_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE0(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE1(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE2(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE3(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE5(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE6(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE7(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE8(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE9(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE10(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE11(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE12(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE13(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE14(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE15(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE16(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE17(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE18(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE19(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE20(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE21(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE22(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE23(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE24(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE25(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE26(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE27(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE28(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE29(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE30(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextTEXTURE31(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextACTIVE_TEXTURE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextREPEAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCLAMP_TO_EDGE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMIRRORED_REPEAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT_VEC2(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT_VEC3(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT_VEC4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINT_VEC2(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINT_VEC3(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINT_VEC4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBOOL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBOOL_VEC2(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBOOL_VEC3(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBOOL_VEC4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT_MAT2(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT_MAT3(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFLOAT_MAT4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLER_2D(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSAMPLER_CUBE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_ENABLED(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_STRIDE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_NORMALIZED(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_POINTER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_BUFFER_BINDING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCOMPILE_STATUS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSHADER_COMPILER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLOW_FLOAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMEDIUM_FLOAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextHIGH_FLOAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextLOW_INT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMEDIUM_INT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextHIGH_INT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRGBA4(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRGB5_A1(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRGB565(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_COMPONENT16(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_INDEX(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_INDEX8(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_STENCIL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_WIDTH(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_HEIGHT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_INTERNAL_FORMAT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_RED_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_GREEN_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_BLUE_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_ALPHA_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_DEPTH_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_STENCIL_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_OBJECT_TYPE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_OBJECT_NAME(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCOLOR_ATTACHMENT0(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_ATTACHMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_ATTACHMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextDEPTH_STENCIL_ATTACHMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextNONE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_COMPLETE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_INCOMPLETE_ATTACHMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_INCOMPLETE_DIMENSIONS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_UNSUPPORTED(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_BINDING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_BINDING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextMAX_RENDERBUFFER_SIZE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextINVALID_FRAMEBUFFER_OPERATION(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNPACK_FLIP_Y_WEBGL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNPACK_PREMULTIPLY_ALPHA_WEBGL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextCONTEXT_LOST_WEBGL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextUNPACK_COLORSPACE_CONVERSION_WEBGL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsWebGLRenderingContextBROWSER_DEFAULT_WEBGL(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(WEBGL)

#endif
